/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.splunk.BooleanComparison;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.PivotFilter;

public class BooleanPivotFilter
extends PivotFilter {
    private final BooleanComparison comparison;
    private final boolean comparisonValue;

    BooleanPivotFilter(DataModelObject dataModelObject, String fieldName, BooleanComparison comparison, boolean comparisonValue) {
        super(dataModelObject, fieldName);
        if (dataModelObject.getField(fieldName).getType() != FieldType.BOOLEAN) {
            throw new IllegalArgumentException("Field " + fieldName + " on the data model object was of type " + dataModelObject.getField(fieldName).getType().toString() + ", expected boolean.");
        }
        this.comparison = comparison;
        this.comparisonValue = comparisonValue;
    }

    @Override
    JsonElement toJson() {
        JsonObject root = new JsonObject();
        this.addCommonFields(root);
        JsonObject filterRule = new JsonObject();
        filterRule.add("comparator", (JsonElement)new JsonPrimitive(this.comparison.toString()));
        filterRule.add("compareTo", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.comparisonValue)));
        root.add("rule", (JsonElement)filterRule);
        return root;
    }
}

