/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.kafka.DefaultPollExceptionStrategy;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.KafkaManualCommit;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.PollOnError;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.BridgeExceptionHandlerToErrorHandler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsumer.class);
    protected ExecutorService executor;
    private final KafkaEndpoint endpoint;
    private final Processor processor;
    private final Long pollTimeoutMs;
    private final List<KafkaFetchRecords> tasks = new ArrayList<KafkaFetchRecords>();
    private volatile boolean stopOffsetRepo;
    private final BridgeExceptionHandlerToErrorHandler bridge = new BridgeExceptionHandlerToErrorHandler((DefaultConsumer)this);
    private PollExceptionStrategy pollExceptionStrategy;

    public KafkaConsumer(KafkaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
        this.pollTimeoutMs = endpoint.getConfiguration().getPollTimeoutMs();
    }

    protected void doBuild() throws Exception {
        super.doBuild();
        this.pollExceptionStrategy = this.endpoint.getComponent().getPollExceptionStrategy() != null ? this.endpoint.getComponent().getPollExceptionStrategy() : new DefaultPollExceptionStrategy(this.endpoint.getConfiguration().getPollOnError());
    }

    public KafkaEndpoint getEndpoint() {
        return (KafkaEndpoint)super.getEndpoint();
    }

    Properties getProps() {
        Properties props = this.endpoint.getConfiguration().createConsumerProperties();
        this.endpoint.updateClassProperties(props);
        String brokers = this.endpoint.getKafkaClientFactory().getBrokers(this.endpoint.getConfiguration());
        if (brokers != null) {
            props.put("bootstrap.servers", brokers);
        }
        if (this.endpoint.getConfiguration().getGroupId() != null) {
            String groupId = this.endpoint.getConfiguration().getGroupId();
            props.put("group.id", groupId);
            LOG.debug("Kafka consumer groupId is {}", (Object)groupId);
        } else {
            String randomGroupId = UUID.randomUUID().toString();
            props.put("group.id", randomGroupId);
            LOG.debug("Kafka consumer groupId is {} (generated)", (Object)randomGroupId);
        }
        if (this.endpoint.getConfiguration().getGroupInstanceId() != null) {
            String gid = this.endpoint.getConfiguration().getGroupInstanceId();
            LOG.debug("Kafka consumer groupInstanceId is {}", (Object)gid);
            props.put("group.instance.id", gid);
        }
        return props;
    }

    protected void doStart() throws Exception {
        boolean started;
        LOG.info("Starting Kafka consumer on topic: {} with breakOnFirstError: {}", (Object)this.endpoint.getConfiguration().getTopic(), (Object)this.endpoint.getConfiguration().isBreakOnFirstError());
        super.doStart();
        StateRepository<String, String> repo = this.endpoint.getConfiguration().getOffsetRepository();
        if (repo instanceof ServiceSupport && !(started = ((ServiceSupport)repo).isStarted())) {
            this.stopOffsetRepo = true;
            LOG.debug("Starting OffsetRepository: {}", repo);
            ServiceHelper.startService(this.endpoint.getConfiguration().getOffsetRepository());
        }
        this.executor = this.endpoint.createExecutor();
        String topic = this.endpoint.getConfiguration().getTopic();
        Pattern pattern = null;
        if (this.endpoint.getConfiguration().isTopicIsPattern()) {
            pattern = Pattern.compile(topic);
        }
        for (int i = 0; i < this.endpoint.getConfiguration().getConsumersCount(); ++i) {
            KafkaFetchRecords task = new KafkaFetchRecords(topic, pattern, i + "", this.getProps());
            task.preInit();
            this.executor.submit(task);
            this.tasks.add(task);
        }
    }

    protected void doStop() throws Exception {
        LOG.info("Stopping Kafka consumer on topic: {}", (Object)this.endpoint.getConfiguration().getTopic());
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                for (KafkaFetchRecords task : this.tasks) {
                    task.stop();
                }
                int timeout = this.getEndpoint().getConfiguration().getShutdownTimeout();
                LOG.debug("Shutting down Kafka consumer worker threads with timeout {} millis", (Object)timeout);
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor, (long)timeout);
            } else {
                this.executor.shutdownNow();
            }
            if (!this.executor.isTerminated()) {
                this.tasks.forEach(KafkaFetchRecords::shutdown);
                this.executor.shutdownNow();
            }
        }
        this.tasks.clear();
        this.executor = null;
        if (this.stopOffsetRepo) {
            StateRepository<String, String> repo = this.endpoint.getConfiguration().getOffsetRepository();
            LOG.debug("Stopping OffsetRepository: {}", repo);
            ServiceHelper.stopAndShutdownService(repo);
        }
        super.doStop();
    }

    private Exchange createKafkaExchange(ConsumerRecord record) {
        Exchange exchange = this.createExchange(false);
        Message message = exchange.getIn();
        message.setHeader("kafka.PARTITION", (Object)record.partition());
        message.setHeader("kafka.TOPIC", (Object)record.topic());
        message.setHeader("kafka.OFFSET", (Object)record.offset());
        message.setHeader("kafka.HEADERS", (Object)record.headers());
        message.setHeader("kafka.TIMESTAMP", (Object)record.timestamp());
        message.setHeader("CamelMessageTimestamp", (Object)record.timestamp());
        if (record.key() != null) {
            message.setHeader("kafka.KEY", record.key());
        }
        message.setBody(record.value());
        return exchange;
    }

    private void propagateHeaders(ConsumerRecord<Object, Object> record, Exchange exchange, KafkaConfiguration kafkaConfiguration) {
        HeaderFilterStrategy headerFilterStrategy = kafkaConfiguration.getHeaderFilterStrategy();
        KafkaHeaderDeserializer headerDeserializer = kafkaConfiguration.getHeaderDeserializer();
        StreamSupport.stream(record.headers().spliterator(), false).filter(header -> this.shouldBeFiltered((Header)header, exchange, headerFilterStrategy)).forEach(header -> exchange.getIn().setHeader(header.key(), headerDeserializer.deserialize(header.key(), header.value())));
    }

    private boolean shouldBeFiltered(Header header, Exchange exchange, HeaderFilterStrategy headerFilterStrategy) {
        return !headerFilterStrategy.applyFilterToExternalHeaders(header.key(), (Object)header.value(), exchange);
    }

    private boolean isAutoCommitEnabled() {
        return this.endpoint.getConfiguration().getAutoCommitEnable() != null && this.endpoint.getConfiguration().getAutoCommitEnable() != false;
    }

    protected String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + '/' + topicPartition.partition();
    }

    protected String serializeOffsetValue(long offset) {
        return String.valueOf(offset);
    }

    protected long deserializeOffsetValue(String offset) {
        return Long.parseLong(offset);
    }

    class KafkaFetchRecords
    implements Runnable,
    ConsumerRebalanceListener {
        private org.apache.kafka.clients.consumer.KafkaConsumer consumer;
        private final String topicName;
        private final Pattern topicPattern;
        private final String threadId;
        private final Properties kafkaProps;
        private final Map<String, Long> lastProcessedOffset = new ConcurrentHashMap<String, Long>();

        KafkaFetchRecords(String topicName, Pattern topicPattern, String id, Properties kafkaProps) {
            this.topicName = topicName;
            this.topicPattern = topicPattern;
            this.threadId = topicName + "-Thread " + id;
            this.kafkaProps = kafkaProps;
        }

        @Override
        public void run() {
            boolean first = true;
            AtomicBoolean reTry = new AtomicBoolean(true);
            AtomicBoolean reConnect = new AtomicBoolean(true);
            while (reTry.get() || reConnect.get()) {
                block8: {
                    try {
                        if (first || reConnect.get()) {
                            this.doInit();
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Error creating org.apache.kafka.clients.consumer.KafkaConsumer due {}", (Object)e.getMessage(), (Object)e);
                    }
                    if (!first) {
                        long delay = KafkaConsumer.this.endpoint.getConfiguration().getPollTimeoutMs();
                        String prefix = reConnect.get() ? "Reconnecting" : "Retrying";
                        LOG.info("{} {} to topic {} after {} ms", new Object[]{prefix, this.threadId, this.topicName, delay});
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException e) {
                            boolean stopping = KafkaConsumer.this.endpoint.getCamelContext().isStopping();
                            if (!stopping) break block8;
                            LOG.info("CamelContext is stopping so terminating KafkaConsumer thread: {} receiving from topic: {}", (Object)this.threadId, (Object)this.topicName);
                            return;
                        }
                    }
                }
                first = false;
                if (!KafkaConsumer.this.isRunAllowed() || KafkaConsumer.this.isStoppingOrStopped() || KafkaConsumer.this.isSuspendingOrSuspended()) {
                    return;
                }
                this.doRun(reTry, reConnect);
            }
            LOG.info("Terminating KafkaConsumer thread: {} receiving from topic: {}", (Object)this.threadId, (Object)this.topicName);
        }

        void preInit() {
            this.doInit();
        }

        protected void doInit() {
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(org.apache.kafka.clients.consumer.KafkaConsumer.class.getClassLoader());
                this.consumer = KafkaConsumer.this.endpoint.getKafkaClientFactory().getConsumer(this.kafkaProps);
            }
            finally {
                Thread.currentThread().setContextClassLoader(threadClassLoader);
            }
        }

        protected void doRun(AtomicBoolean retry, AtomicBoolean reconnect) {
            if (reconnect.get()) {
                this.doReconnectRun();
                reconnect.set(false);
            }
            this.doPollRun(retry, reconnect);
        }

        protected void doReconnectRun() {
            if (this.topicPattern != null) {
                LOG.info("Subscribing {} to topic pattern {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.subscribe(this.topicPattern, (ConsumerRebalanceListener)this);
            } else {
                LOG.info("Subscribing {} to topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.subscribe(Arrays.asList(this.topicName.split(",")), (ConsumerRebalanceListener)this);
            }
            StateRepository<String, String> offsetRepository = KafkaConsumer.this.endpoint.getConfiguration().getOffsetRepository();
            if (offsetRepository != null) {
                ConsumerRecords poll = this.consumer.poll(100L);
                for (TopicPartition topicPartition : this.consumer.assignment()) {
                    String offsetState = (String)offsetRepository.getState((Object)KafkaConsumer.this.serializeOffsetKey(topicPartition));
                    if (offsetState != null && !offsetState.isEmpty()) {
                        long offset = KafkaConsumer.this.deserializeOffsetValue(offsetState) + 1L;
                        LOG.debug("Resuming partition {} from offset {} from state", (Object)topicPartition.partition(), (Object)offset);
                        this.consumer.seek(topicPartition, offset);
                        continue;
                    }
                    List partitionRecords = poll.records(topicPartition);
                    if (partitionRecords.isEmpty()) continue;
                    long offset = ((ConsumerRecord)partitionRecords.get(0)).offset();
                    LOG.debug("Resuming partition {} from offset {}", (Object)topicPartition.partition(), (Object)offset);
                    this.consumer.seek(topicPartition, offset);
                }
            } else if (KafkaConsumer.this.endpoint.getConfiguration().getSeekTo() != null) {
                if (KafkaConsumer.this.endpoint.getConfiguration().getSeekTo().equals("beginning")) {
                    LOG.debug("{} is seeking to the beginning on topic {}", (Object)this.threadId, (Object)this.topicName);
                    this.consumer.poll(Duration.ofMillis(100L));
                    this.consumer.seekToBeginning((Collection)this.consumer.assignment());
                } else if (KafkaConsumer.this.endpoint.getConfiguration().getSeekTo().equals("end")) {
                    LOG.debug("{} is seeking to the end on topic {}", (Object)this.threadId, (Object)this.topicName);
                    this.consumer.poll(Duration.ofMillis(100L));
                    this.consumer.seekToEnd((Collection)this.consumer.assignment());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPollRun(AtomicBoolean retry, AtomicBoolean reconnect) {
            StateRepository<String, String> offsetRepository = KafkaConsumer.this.endpoint.getConfiguration().getOffsetRepository();
            boolean unsubscribing = false;
            TopicPartition partition = null;
            long partitionLastOffset = -1L;
            try {
                while (KafkaConsumer.this.isRunAllowed() && !KafkaConsumer.this.isStoppingOrStopped() && !KafkaConsumer.this.isSuspendingOrSuspended() && retry.get() && !reconnect.get()) {
                    boolean breakOnErrorHit = false;
                    LOG.trace("Polling {} from topic: {} with timeout: {}", new Object[]{this.threadId, this.topicName, KafkaConsumer.this.pollTimeoutMs});
                    ConsumerRecords allRecords = this.consumer.poll(KafkaConsumer.this.pollTimeoutMs.longValue());
                    Iterator partitionIterator = allRecords.partitions().iterator();
                    while (partitionIterator.hasNext()) {
                        partition = (TopicPartition)partitionIterator.next();
                        partitionLastOffset = -1L;
                        Iterator recordIterator = allRecords.records(partition).iterator();
                        LOG.debug("Records count {} received for partition {}", (Object)allRecords.records(partition).size(), (Object)partition);
                        if (breakOnErrorHit || !recordIterator.hasNext()) continue;
                        while (!breakOnErrorHit && recordIterator.hasNext()) {
                            ConsumerRecord record = (ConsumerRecord)recordIterator.next();
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Partition = {}, offset = {}, key = {}, value = {}", new Object[]{record.partition(), record.offset(), record.key(), record.value()});
                            }
                            Exchange exchange = KafkaConsumer.this.createKafkaExchange(record);
                            KafkaConsumer.this.propagateHeaders((ConsumerRecord<Object, Object>)record, exchange, KafkaConsumer.this.endpoint.getConfiguration());
                            if (!KafkaConsumer.this.isAutoCommitEnabled()) {
                                exchange.getIn().setHeader("kafka.LAST_RECORD_BEFORE_COMMIT", (Object)(!recordIterator.hasNext() ? 1 : 0));
                            }
                            if (KafkaConsumer.this.endpoint.getConfiguration().isAllowManualCommit()) {
                                KafkaManualCommit manual = KafkaConsumer.this.endpoint.getComponent().getKafkaManualCommitFactory().newInstance(exchange, this.consumer, this.topicName, this.threadId, offsetRepository, partition, record.offset());
                                exchange.getIn().setHeader("CamelKafkaManualCommit", (Object)manual);
                            }
                            if (!KafkaConsumer.this.isAutoCommitEnabled() || KafkaConsumer.this.endpoint.getConfiguration().isAllowManualCommit()) {
                                exchange.getIn().setHeader("kafka.LAST_POLL_RECORD", (Object)(!recordIterator.hasNext() && !partitionIterator.hasNext() ? 1 : 0));
                            }
                            try {
                                KafkaConsumer.this.processor.process(exchange);
                            }
                            catch (Exception e) {
                                exchange.setException((Throwable)e);
                            }
                            if (exchange.getException() != null) {
                                if (KafkaConsumer.this.endpoint.getConfiguration().isBreakOnFirstError()) {
                                    LOG.warn("Error during processing {} from topic: {}. Will seek consumer to offset: {} and re-connect and start polling again.", new Object[]{exchange, this.topicName, partitionLastOffset, exchange.getException()});
                                    this.commitOffset(offsetRepository, partition, partitionLastOffset, false, true);
                                    breakOnErrorHit = true;
                                } else {
                                    KafkaConsumer.this.getExceptionHandler().handleException("Error during processing", exchange, (Throwable)exchange.getException());
                                }
                            } else {
                                partitionLastOffset = record.offset();
                                this.lastProcessedOffset.put(KafkaConsumer.this.serializeOffsetKey(partition), partitionLastOffset);
                            }
                            KafkaConsumer.this.releaseExchange(exchange, false);
                        }
                        if (breakOnErrorHit) continue;
                        this.commitOffset(offsetRepository, partition, partitionLastOffset, false, false);
                    }
                    if (!breakOnErrorHit) continue;
                    reconnect.set(true);
                }
                if (!reconnect.get() && KafkaConsumer.this.isAutoCommitEnabled()) {
                    if ("async".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        LOG.info("Auto commitAsync on stop {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.commitAsync();
                    } else if ("sync".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        LOG.info("Auto commitSync on stop {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.commitSync();
                    } else if ("none".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        LOG.info("Auto commit on stop {} from topic {} is disabled (none)", (Object)this.threadId, (Object)this.topicName);
                    }
                }
                LOG.info("Unsubscribing {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                unsubscribing = true;
                this.consumer.unsubscribe();
            }
            catch (InterruptException e) {
                KafkaConsumer.this.getExceptionHandler().handleException("Interrupted while consuming " + this.threadId + " from kafka topic", (Throwable)e);
                LOG.info("Unsubscribing {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                this.consumer.unsubscribe();
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception caught while polling " + this.threadId + " from kafka topic " + this.topicName + " at offset " + this.lastProcessedOffset + ". Deciding what to do.", (Throwable)e);
                }
                if (unsubscribing) {
                    KafkaConsumer.this.getExceptionHandler().handleException("Error unsubscribing " + this.threadId + " from kafka topic " + this.topicName, (Throwable)e);
                } else {
                    PollOnError onError = KafkaConsumer.this.pollExceptionStrategy.handleException(e);
                    if (PollOnError.RETRY == onError) {
                        LOG.warn("{} consuming {} from topic {} causedby {}. Will attempt again polling the same message (stacktrace in DEBUG logging level)", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage()});
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("KafkaException consuming {} from topic {} causedby {}. Will attempt again polling the same message", new Object[]{this.threadId, this.topicName, e.getMessage(), e});
                        }
                        retry.set(true);
                    } else if (PollOnError.RECONNECT == onError) {
                        LOG.warn("{} consuming {} from topic {} causedby {}. Will attempt to re-connect on next run (stacktrace in DEBUG logging level)", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage()});
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} consuming {} from topic {} causedby {}. Will attempt to re-connect on next run", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage(), e});
                        }
                        reconnect.set(true);
                    } else if (PollOnError.ERROR_HANDLER == onError) {
                        KafkaConsumer.this.bridge.handleException((Throwable)e);
                        this.seekToNextOffset(partitionLastOffset);
                    } else if (PollOnError.DISCARD == onError) {
                        LOG.warn("{} consuming {} from topic {} causedby {}. Will discard the message and continue to poll the next message (stracktrace in DEBUG logging level).", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage()});
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} consuming {} from topic {} causedby {}. Will discard the message and continue to poll the next message.", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage(), e});
                        }
                        this.seekToNextOffset(partitionLastOffset);
                    } else if (PollOnError.STOP == onError) {
                        LOG.warn("{} consuming {} from topic {} causedby {}. Will stop consumer (stacktrace in DEBUG logging level).", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage()});
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} consuming {} from topic {} causedby {}. Will stop consumer.", new Object[]{e.getClass().getName(), this.threadId, this.topicName, e.getMessage(), e});
                        }
                        retry.set(false);
                        reconnect.set(false);
                    }
                }
            }
            finally {
                if (!retry.get() && !reconnect.get()) {
                    LOG.debug("Closing consumer {}", (Object)this.threadId);
                    IOHelper.close((Closeable)this.consumer);
                }
            }
        }

        private void seekToNextOffset(long partitionLastOffset) {
            block4: {
                Set tps;
                boolean logged;
                block3: {
                    logged = false;
                    tps = this.consumer.assignment();
                    if (tps == null || partitionLastOffset == -1L) break block3;
                    long next = partitionLastOffset + 1L;
                    LOG.info("Consumer seeking to next offset {} to continue polling next message from topic: {}", (Object)next, (Object)this.topicName);
                    for (TopicPartition tp : tps) {
                        this.consumer.seek(tp, next);
                    }
                    break block4;
                }
                if (tps == null) break block4;
                for (TopicPartition tp : tps) {
                    long next = this.consumer.position(tp) + 1L;
                    if (!logged) {
                        LOG.info("Consumer seeking to next offset {} to continue polling next message from topic: {}", (Object)next, (Object)this.topicName);
                        logged = true;
                    }
                    this.consumer.seek(tp, next);
                }
            }
        }

        private void commitOffset(StateRepository<String, String> offsetRepository, TopicPartition partition, long partitionLastOffset, boolean stopping, boolean forceCommit) {
            if (partitionLastOffset != -1L) {
                if (!KafkaConsumer.this.endpoint.getConfiguration().isAllowManualCommit() && offsetRepository != null) {
                    LOG.debug("Saving offset repository state {} [topic: {} partition: {} offset: {}]", new Object[]{this.threadId, this.topicName, partition.partition(), partitionLastOffset});
                    offsetRepository.setState((Object)KafkaConsumer.this.serializeOffsetKey(partition), (Object)KafkaConsumer.this.serializeOffsetValue(partitionLastOffset));
                } else if (stopping) {
                    if ("async".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        LOG.debug("Auto commitAsync on stop {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.commitAsync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)), null);
                    } else if ("sync".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        LOG.debug("Auto commitSync on stop {} from topic {}", (Object)this.threadId, (Object)this.topicName);
                        this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)));
                    } else if ("none".equals(KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitOnStop())) {
                        LOG.debug("Auto commit on stop {} from topic {} is disabled (none)", (Object)this.threadId, (Object)this.topicName);
                    }
                } else if (forceCommit) {
                    LOG.debug("Forcing commitSync {} [topic: {} partition: {} offset: {}]", new Object[]{this.threadId, this.topicName, partition.partition(), partitionLastOffset});
                    this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(partitionLastOffset + 1L)));
                }
            }
        }

        void stop() {
            this.consumer.wakeup();
        }

        void shutdown() {
            this.consumer.wakeup();
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            LOG.debug("onPartitionsRevoked: {} from topic {}", (Object)this.threadId, (Object)this.topicName);
            boolean stopping = KafkaConsumer.this.getEndpoint().getCamelContext().isStopping() && !KafkaConsumer.this.isRunAllowed();
            StateRepository<String, String> offsetRepository = KafkaConsumer.this.endpoint.getConfiguration().getOffsetRepository();
            for (TopicPartition partition : partitions) {
                String offsetKey = KafkaConsumer.this.serializeOffsetKey(partition);
                Long offset = this.lastProcessedOffset.get(offsetKey);
                if (offset == null) {
                    offset = -1L;
                }
                try {
                    if (!KafkaConsumer.this.endpoint.getConfiguration().getAutoCommitEnable().booleanValue()) continue;
                    this.commitOffset(offsetRepository, partition, offset, stopping, false);
                }
                catch (Exception e) {
                    LOG.error("Error saving offset repository state {} from offsetKey {} with offset: {}", new Object[]{this.threadId, offsetKey, offset});
                    throw e;
                }
                finally {
                    this.lastProcessedOffset.remove(offsetKey);
                }
            }
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            LOG.debug("onPartitionsAssigned: {} from topic {}", (Object)this.threadId, (Object)this.topicName);
            StateRepository<String, String> offsetRepository = KafkaConsumer.this.endpoint.getConfiguration().getOffsetRepository();
            if (offsetRepository != null) {
                for (TopicPartition partition : partitions) {
                    String offsetState = (String)offsetRepository.getState((Object)KafkaConsumer.this.serializeOffsetKey(partition));
                    if (offsetState == null || offsetState.isEmpty()) continue;
                    long offset = KafkaConsumer.this.deserializeOffsetValue(offsetState) + 1L;
                    LOG.debug("Resuming partition {} from offset {} from state", (Object)partition.partition(), (Object)offset);
                    this.consumer.seek(partition, offset);
                }
            }
        }
    }
}

