/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@UDFType(deterministic=true)
@Description(name="current_user", value="_FUNC_() - Returns current user name", extended="SessionState UserFromAuthenticator")
public class GenericUDFCurrentUser
extends GenericUDF {
    protected Text currentUser;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        String sessUserFromAuth;
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function CURRENT_USER does not take any arguments, but found " + arguments.length);
        }
        if (this.currentUser == null && (sessUserFromAuth = SessionState.getUserFromAuthenticator()) != null) {
            this.currentUser = new Text(sessUserFromAuth);
        }
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.currentUser;
    }

    public Text getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(Text currentUser) {
        this.currentUser = currentUser;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "CURRENT_USER()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFCurrentUser other = (GenericUDFCurrentUser)newInstance;
        if (this.currentUser != null) {
            other.currentUser = new Text(this.currentUser);
        }
    }
}

