/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.HighlyCompressedMapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HighlyCompressedMapStatus$
implements Serializable {
    public static final HighlyCompressedMapStatus$ MODULE$;

    static {
        new HighlyCompressedMapStatus$();
    }

    public HighlyCompressedMapStatus apply(BlockManagerId loc, long[] uncompressedSizes) {
        int numNonEmptyBlocks = 0;
        int numSmallBlocks = 0;
        long totalSmallBlockSize = 0L;
        RoaringBitmap emptyBlocks = new RoaringBitmap();
        int totalNumBlocks = uncompressedSizes.length;
        long threshold = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(SparkEnv x$3) {
                return BoxesRunTime.unboxToLong((Object)x$3.conf().get(package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_THRESHOLD()));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return BoxesRunTime.unboxToLong((Object)package$.MODULE$.SHUFFLE_ACCURATE_BLOCK_THRESHOLD().defaultValue().get());
            }
        }));
        ArrayBuffer hugeBlockSizesArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; i < totalNumBlocks; ++i) {
            BoxedUnit boxedUnit;
            long size = uncompressedSizes[i];
            if (size > 0L) {
                ++numNonEmptyBlocks;
                if (size < threshold) {
                    totalSmallBlockSize += size;
                    ++numSmallBlocks;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit = hugeBlockSizesArray.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToByte((byte)MapStatus$.MODULE$.compressSize(uncompressedSizes[i]))));
                continue;
            }
            emptyBlocks.add(i);
            boxedUnit = BoxedUnit.UNIT;
        }
        long avgSize = numSmallBlocks > 0 ? totalSmallBlockSize / (long)numSmallBlocks : 0L;
        emptyBlocks.trim();
        emptyBlocks.runOptimize();
        return new HighlyCompressedMapStatus(loc, numNonEmptyBlocks, emptyBlocks, avgSize, (Map<Object, Object>)hugeBlockSizesArray.toMap(Predef$.MODULE$.$conforms()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HighlyCompressedMapStatus$() {
        MODULE$ = this;
    }
}

