/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;

class MemoryManager {
    private static final Log LOG = LogFactory.getLog(MemoryManager.class);
    private static final int ROWS_BETWEEN_CHECKS = 5000;
    private final long totalMemoryPool;
    private final Map<Path, WriterInfo> writerList = new HashMap<Path, WriterInfo>();
    private long totalAllocation = 0L;
    private double currentScale = 1.0;
    private int rowsAddedSinceCheck = 0;

    MemoryManager(Configuration conf) {
        HiveConf.ConfVars poolVar = HiveConf.ConfVars.HIVE_ORC_FILE_MEMORY_POOL;
        double maxLoad = conf.getFloat(poolVar.varname, poolVar.defaultFloatVal);
        this.totalMemoryPool = Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * maxLoad);
    }

    synchronized void addWriter(Path path, long requestedAllocation, Callback callback) throws IOException {
        WriterInfo oldVal = this.writerList.get(path);
        if (oldVal == null) {
            oldVal = new WriterInfo(requestedAllocation, callback);
            this.writerList.put(path, oldVal);
            this.totalAllocation += requestedAllocation;
        } else {
            this.totalAllocation += requestedAllocation - oldVal.allocation;
            oldVal.allocation = requestedAllocation;
            oldVal.callback = callback;
        }
        this.updateScale(true);
    }

    synchronized void removeWriter(Path path) throws IOException {
        WriterInfo val = this.writerList.get(path);
        if (val != null) {
            this.writerList.remove(path);
            this.totalAllocation -= val.allocation;
            if (this.writerList.isEmpty()) {
                this.rowsAddedSinceCheck = 0;
            }
            this.updateScale(false);
        }
        if (this.writerList.isEmpty()) {
            this.rowsAddedSinceCheck = 0;
        }
    }

    long getTotalMemoryPool() {
        return this.totalMemoryPool;
    }

    synchronized double getAllocationScale() {
        return this.currentScale;
    }

    synchronized void addedRow() throws IOException {
        if (++this.rowsAddedSinceCheck >= 5000) {
            this.notifyWriters();
        }
    }

    void notifyWriters() throws IOException {
        LOG.debug((Object)("Notifying writers after " + this.rowsAddedSinceCheck));
        for (WriterInfo writer : this.writerList.values()) {
            boolean flushed = writer.callback.checkMemory(this.currentScale);
            if (!LOG.isDebugEnabled() || !flushed) continue;
            LOG.debug((Object)("flushed " + writer.toString()));
        }
        this.rowsAddedSinceCheck = 0;
    }

    private void updateScale(boolean isAllocate) throws IOException {
        this.currentScale = this.totalAllocation <= this.totalMemoryPool ? 1.0 : (double)this.totalMemoryPool / (double)this.totalAllocation;
    }

    public static interface Callback {
        public boolean checkMemory(double var1) throws IOException;
    }

    private static class WriterInfo {
        long allocation;
        Callback callback;

        WriterInfo(long allocation, Callback callback) {
            this.allocation = allocation;
            this.callback = callback;
        }
    }
}

