/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.spark_project.jetty.client.HttpClient;
import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.HttpExchange;
import org.spark_project.jetty.client.HttpRequest;
import org.spark_project.jetty.client.Origin;
import org.spark_project.jetty.client.SendFailure;
import org.spark_project.jetty.client.api.Connection;
import org.spark_project.jetty.util.Promise;

public abstract class MultiplexHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final AtomicReference<ConnectState> connect = new AtomicReference<ConnectState>(ConnectState.DISCONNECTED);
    private final AtomicInteger requestsPerConnection = new AtomicInteger();
    private int maxRequestsPerConnection = 1024;
    private C connection;

    protected MultiplexHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public void setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
    }

    @Override
    public void send() {
        block5: while (true) {
            ConnectState current = this.connect.get();
            switch (current) {
                case DISCONNECTED: {
                    if (!this.connect.compareAndSet(current, ConnectState.CONNECTING)) continue block5;
                    this.newConnection(this);
                    return;
                }
                case CONNECTING: {
                    return;
                }
                case CONNECTED: {
                    if (this.process(this.connection)) continue block5;
                    return;
                }
                default: {
                    this.abort(new IllegalStateException("Invalid connection state " + (Object)((Object)current)));
                    return;
                }
            }
        }
    }

    @Override
    public void succeeded(Connection result2) {
        this.connection = result2;
        Connection connection = this.connection;
        if (this.connect.compareAndSet(ConnectState.CONNECTING, ConnectState.CONNECTED)) {
            this.send();
        } else {
            connection.close();
            this.failed(new IllegalStateException("Invalid connection state " + this.connect));
        }
    }

    @Override
    public void failed(Throwable x) {
        this.connect.set(ConnectState.DISCONNECTED);
        this.abort(x);
    }

    protected boolean process(C connection) {
        int max2;
        int next2;
        int count2;
        do {
            max2 = this.getMaxRequestsPerConnection();
            count2 = this.requestsPerConnection.get();
            next2 = count2 + 1;
            if (next2 <= max2) continue;
            return false;
        } while (!this.requestsPerConnection.compareAndSet(count2, next2));
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {}/{} {} on {}", next2, max2, exchange, connection);
        }
        if (exchange == null) {
            this.requestsPerConnection.decrementAndGet();
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            this.requestsPerConnection.decrementAndGet();
            exchange.abort(cause);
        } else {
            SendFailure result2 = this.send(connection, exchange);
            if (result2 != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send failed {} for {}", result2, exchange);
                }
                this.requestsPerConnection.decrementAndGet();
                if (result2.retry) {
                    this.send(exchange);
                } else {
                    request.abort(result2.failure);
                }
            }
        }
        return this.getHttpExchanges().peek() != null;
    }

    @Override
    public void release(Connection connection) {
        this.requestsPerConnection.decrementAndGet();
        this.send();
    }

    @Override
    public void close() {
        super.close();
        C connection = this.connection;
        if (connection != null) {
            connection.close();
        }
    }

    @Override
    public void close(Connection connection) {
        block1: {
            ConnectState current;
            super.close(connection);
            while (!this.connect.compareAndSet(current = this.connect.get(), ConnectState.DISCONNECTED)) {
            }
            if (!this.getHttpClient().isRemoveIdleDestinations()) break block1;
            this.getHttpClient().removeDestination(this);
        }
    }

    protected abstract SendFailure send(C var1, HttpExchange var2);

    private static enum ConnectState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED;

    }
}

