/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;

public class RelMdUtil {
    public static final SqlFunction ARTIFICIAL_SELECTIVITY_FUNC = new SqlFunction("ARTIFICIAL_SELECTIVITY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, null, OperandTypes.NUMERIC, SqlFunctionCategory.SYSTEM);

    private RelMdUtil() {
    }

    public static RexNode makeSemiJoinSelectivityRexNode(SemiJoin rel) {
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        double selectivity = RelMdUtil.computeSemiJoinSelectivity(rel.getLeft(), rel.getRight(), rel);
        RexLiteral selec = rexBuilder.makeApproxLiteral(new BigDecimal(selectivity));
        return rexBuilder.makeCall((SqlOperator)ARTIFICIAL_SELECTIVITY_FUNC, selec);
    }

    public static double getSelectivityValue(RexNode artificialSelecFuncNode) {
        assert (artificialSelecFuncNode instanceof RexCall);
        RexCall call = (RexCall)artificialSelecFuncNode;
        assert (call.getOperator() == ARTIFICIAL_SELECTIVITY_FUNC);
        RexNode operand = call.getOperands().get(0);
        BigDecimal bd = (BigDecimal)((RexLiteral)operand).getValue();
        return bd.doubleValue();
    }

    public static double computeSemiJoinSelectivity(SemiJoin rel) {
        return RelMdUtil.computeSemiJoinSelectivity(rel.getLeft(), rel.getRight(), rel.getLeftKeys(), rel.getRightKeys());
    }

    public static double computeSemiJoinSelectivity(RelNode factRel, RelNode dimRel, SemiJoin rel) {
        return RelMdUtil.computeSemiJoinSelectivity(factRel, dimRel, rel.getLeftKeys(), rel.getRightKeys());
    }

    public static double computeSemiJoinSelectivity(RelNode factRel, RelNode dimRel, List<Integer> factKeyList, List<Integer> dimKeyList) {
        Double selectivity;
        Double dimCard;
        ImmutableBitSet.Builder factKeys = ImmutableBitSet.builder();
        for (int factCol : factKeyList) {
            factKeys.set(factCol);
        }
        ImmutableBitSet.Builder dimKeyBuilder = ImmutableBitSet.builder();
        for (int dimCol : dimKeyList) {
            dimKeyBuilder.set(dimCol);
        }
        ImmutableBitSet dimKeys = dimKeyBuilder.build();
        Double factPop = RelMetadataQuery.getPopulationSize(factRel, factKeys.build());
        if (factPop == null) {
            factPop = RelMetadataQuery.getPopulationSize(dimRel, dimKeys);
        }
        if ((dimCard = RelMetadataQuery.getDistinctRowCount(dimRel, dimKeys, null)) != null && factPop != null) {
            if (factPop < 1.0) {
                factPop = 1.0;
            }
            selectivity = dimCard / factPop;
        } else {
            selectivity = RelMetadataQuery.getPercentageOriginalRows(dimRel);
        }
        if (selectivity == null) {
            selectivity = Math.pow(0.1, dimKeys.cardinality());
        } else if (selectivity > 1.0) {
            selectivity = 1.0;
        }
        return selectivity;
    }

    public static boolean areColumnsDefinitelyUnique(RelNode rel, ImmutableBitSet colMask) {
        Boolean b = RelMetadataQuery.areColumnsUnique(rel, colMask, false);
        return b != null && b != false;
    }

    public static Boolean areColumnsUnique(RelNode rel, List<RexInputRef> columnRefs) {
        ImmutableBitSet.Builder colMask = ImmutableBitSet.builder();
        for (RexInputRef columnRef : columnRefs) {
            colMask.set(columnRef.getIndex());
        }
        return RelMetadataQuery.areColumnsUnique(rel, colMask.build());
    }

    public static boolean areColumnsDefinitelyUnique(RelNode rel, List<RexInputRef> columnRefs) {
        Boolean b = RelMdUtil.areColumnsUnique(rel, columnRefs);
        return b != null && b != false;
    }

    public static boolean areColumnsDefinitelyUniqueWhenNullsFiltered(RelNode rel, ImmutableBitSet colMask) {
        Boolean b = RelMetadataQuery.areColumnsUnique(rel, colMask, true);
        if (b == null) {
            return false;
        }
        return b;
    }

    public static Boolean areColumnsUniqueWhenNullsFiltered(RelNode rel, List<RexInputRef> columnRefs) {
        ImmutableBitSet.Builder colMask = ImmutableBitSet.builder();
        for (RexInputRef columnRef : columnRefs) {
            colMask.set(columnRef.getIndex());
        }
        return RelMetadataQuery.areColumnsUnique(rel, colMask.build(), true);
    }

    public static boolean areColumnsDefinitelyUniqueWhenNullsFiltered(RelNode rel, List<RexInputRef> columnRefs) {
        Boolean b = RelMdUtil.areColumnsUniqueWhenNullsFiltered(rel, columnRefs);
        if (b == null) {
            return false;
        }
        return b;
    }

    public static void setLeftRightBitmaps(ImmutableBitSet groupKey, ImmutableBitSet.Builder leftMask, ImmutableBitSet.Builder rightMask, int nFieldsOnLeft) {
        for (int bit : groupKey) {
            if (bit < nFieldsOnLeft) {
                leftMask.set(bit);
                continue;
            }
            rightMask.set(bit - nFieldsOnLeft);
        }
    }

    public static Double numDistinctVals(Double domainSize, Double numSelected) {
        double res;
        if (domainSize == null || numSelected == null) {
            return null;
        }
        double dSize = RelMdUtil.capInfinity(domainSize);
        double numSel = RelMdUtil.capInfinity(numSelected);
        double d = res = dSize > 0.0 ? (1.0 - Math.exp(-1.0 * numSel / dSize)) * dSize : 0.0;
        if (res > dSize) {
            res = dSize;
        }
        if (res > numSel) {
            res = numSel;
        }
        if (res < 0.0) {
            res = 0.0;
        }
        return res;
    }

    public static double capInfinity(Double d) {
        return d.isInfinite() ? Double.MAX_VALUE : d;
    }

    public static double guessSelectivity(RexNode predicate) {
        return RelMdUtil.guessSelectivity(predicate, false);
    }

    public static double guessSelectivity(RexNode predicate, boolean artificialOnly) {
        double sel = 1.0;
        if (predicate == null || predicate.isAlwaysTrue()) {
            return sel;
        }
        double artificialSel = 1.0;
        for (RexNode pred : RelOptUtil.conjunctions(predicate)) {
            if (pred.getKind() == SqlKind.IS_NOT_NULL) {
                sel *= 0.9;
                continue;
            }
            if (pred instanceof RexCall && ((RexCall)pred).getOperator() == ARTIFICIAL_SELECTIVITY_FUNC) {
                artificialSel *= RelMdUtil.getSelectivityValue(pred);
                continue;
            }
            if (pred.isA(SqlKind.EQUALS)) {
                sel *= 0.15;
                continue;
            }
            if (pred.isA(SqlKind.COMPARISON)) {
                sel *= 0.5;
                continue;
            }
            sel *= 0.25;
        }
        if (artificialOnly) {
            return artificialSel;
        }
        return sel * artificialSel;
    }

    public static RexNode unionPreds(RexBuilder rexBuilder, RexNode pred1, RexNode pred2) {
        ArrayList<RexNode> unionList = new ArrayList<RexNode>();
        HashSet<String> strings = new HashSet<String>();
        for (RexNode rex : RelOptUtil.conjunctions(pred1)) {
            if (!strings.add(rex.toString())) continue;
            unionList.add(rex);
        }
        for (RexNode rex2 : RelOptUtil.conjunctions(pred2)) {
            if (!strings.add(rex2.toString())) continue;
            unionList.add(rex2);
        }
        return RexUtil.composeConjunction(rexBuilder, unionList, true);
    }

    public static RexNode minusPreds(RexBuilder rexBuilder, RexNode pred1, RexNode pred2) {
        List<RexNode> list1 = RelOptUtil.conjunctions(pred1);
        List<RexNode> list2 = RelOptUtil.conjunctions(pred2);
        ArrayList<RexNode> minusList = new ArrayList<RexNode>();
        for (RexNode rex1 : list1) {
            boolean add = true;
            for (RexNode rex2 : list2) {
                if (rex2.toString().compareTo(rex1.toString()) != 0) continue;
                add = false;
                break;
            }
            if (!add) continue;
            minusList.add(rex1);
        }
        return RexUtil.composeConjunction(rexBuilder, minusList, true);
    }

    public static void setAggChildKeys(ImmutableBitSet groupKey, Aggregate aggRel, ImmutableBitSet.Builder childKey) {
        List<AggregateCall> aggCalls = aggRel.getAggCallList();
        for (int bit : groupKey) {
            if (bit < aggRel.getGroupCount()) {
                childKey.set(bit);
                continue;
            }
            AggregateCall agg = aggCalls.get(bit - (aggRel.getGroupCount() + aggRel.getIndicatorCount()));
            for (Integer arg : agg.getArgList()) {
                childKey.set(arg);
            }
        }
    }

    public static void splitCols(List<RexNode> projExprs, ImmutableBitSet groupKey, ImmutableBitSet.Builder baseCols, ImmutableBitSet.Builder projCols) {
        for (int bit : groupKey) {
            RexNode e = projExprs.get(bit);
            if (e instanceof RexInputRef) {
                baseCols.set(((RexInputRef)e).getIndex());
                continue;
            }
            projCols.set(bit);
        }
    }

    public static Double cardOfProjExpr(Project rel, RexNode expr) {
        return expr.accept(new CardOfProjExpr(rel));
    }

    public static Double getJoinPopulationSize(RelNode joinRel, ImmutableBitSet groupKey) {
        ImmutableBitSet.Builder leftMask = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightMask = ImmutableBitSet.builder();
        RelNode left = joinRel.getInputs().get(0);
        RelNode right = joinRel.getInputs().get(1);
        RelMdUtil.setLeftRightBitmaps(groupKey, leftMask, rightMask, left.getRowType().getFieldCount());
        Double population = NumberUtil.multiply(RelMetadataQuery.getPopulationSize(left, leftMask.build()), RelMetadataQuery.getPopulationSize(right, rightMask.build()));
        return RelMdUtil.numDistinctVals(population, RelMetadataQuery.getRowCount(joinRel));
    }

    public static Double getJoinDistinctRowCount(RelNode joinRel, JoinRelType joinType, ImmutableBitSet groupKey, RexNode predicate, boolean useMaxNdv) {
        ImmutableBitSet.Builder leftMask = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightMask = ImmutableBitSet.builder();
        RelNode left = joinRel.getInputs().get(0);
        RelNode right = joinRel.getInputs().get(1);
        RelMdUtil.setLeftRightBitmaps(groupKey, leftMask, rightMask, left.getRowType().getFieldCount());
        RexNode leftPred = null;
        RexNode rightPred = null;
        if (predicate != null) {
            ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
            ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
            ArrayList<RexNode> joinFilters = new ArrayList<RexNode>();
            List<RexNode> predList = RelOptUtil.conjunctions(predicate);
            RelOptUtil.classifyFilters(joinRel, predList, joinType, joinType == JoinRelType.INNER, !joinType.generatesNullsOnLeft(), !joinType.generatesNullsOnRight(), joinFilters, leftFilters, rightFilters);
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            leftPred = RexUtil.composeConjunction(rexBuilder, leftFilters, true);
            rightPred = RexUtil.composeConjunction(rexBuilder, rightFilters, true);
        }
        Double distRowCount = useMaxNdv ? Double.valueOf(Math.max(RelMetadataQuery.getDistinctRowCount(left, leftMask.build(), leftPred), RelMetadataQuery.getDistinctRowCount(right, rightMask.build(), rightPred))) : NumberUtil.multiply(RelMetadataQuery.getDistinctRowCount(left, leftMask.build(), leftPred), RelMetadataQuery.getDistinctRowCount(right, rightMask.build(), rightPred));
        return RelMdUtil.numDistinctVals(distRowCount, RelMetadataQuery.getRowCount(joinRel));
    }

    private static class CardOfProjExpr
    extends RexVisitorImpl<Double> {
        private Project rel;

        public CardOfProjExpr(Project rel) {
            super(true);
            this.rel = rel;
        }

        @Override
        public Double visitInputRef(RexInputRef var) {
            int index = var.getIndex();
            ImmutableBitSet col = ImmutableBitSet.of(index);
            Double distinctRowCount = RelMetadataQuery.getDistinctRowCount(this.rel.getInput(), col, null);
            if (distinctRowCount == null) {
                return null;
            }
            return RelMdUtil.numDistinctVals(distinctRowCount, RelMetadataQuery.getRowCount(this.rel));
        }

        @Override
        public Double visitLiteral(RexLiteral literal) {
            return RelMdUtil.numDistinctVals(1.0, RelMetadataQuery.getRowCount(this.rel));
        }

        @Override
        public Double visitCall(RexCall call) {
            Double distinctRowCount;
            Double rowCount = RelMetadataQuery.getRowCount(this.rel);
            if (call.isA(SqlKind.MINUS_PREFIX)) {
                distinctRowCount = RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0));
            } else if (call.isA((Collection<SqlKind>)ImmutableList.of((Object)((Object)SqlKind.PLUS), (Object)((Object)SqlKind.MINUS)))) {
                Double card0 = RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0));
                if (card0 == null) {
                    return null;
                }
                Double card1 = RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(1));
                if (card1 == null) {
                    return null;
                }
                distinctRowCount = Math.max(card0, card1);
            } else {
                distinctRowCount = call.isA((Collection<SqlKind>)ImmutableList.of((Object)((Object)SqlKind.TIMES), (Object)((Object)SqlKind.DIVIDE))) ? NumberUtil.multiply(RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0)), RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(1))) : (call.getOperands().size() == 1 ? RelMdUtil.cardOfProjExpr(this.rel, call.getOperands().get(0)) : Double.valueOf(rowCount / 10.0));
            }
            return RelMdUtil.numDistinctVals(distinctRowCount, rowCount);
        }
    }
}

