/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.MimetypesFileTypeMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;

public class SolrProducer
extends DefaultProducer {
    private SolrClient httpServer;
    private SolrClient concSolrServer;
    private SolrClient cloudSolrServer;

    public SolrProducer(SolrEndpoint endpoint, SolrClient solrServer, SolrClient concSolrServer, SolrClient cloudSolrServer) {
        super((Endpoint)endpoint);
        this.httpServer = solrServer;
        this.concSolrServer = concSolrServer;
        this.cloudSolrServer = cloudSolrServer;
    }

    private SolrClient getBestSolrServer(String operation) {
        if (this.cloudSolrServer != null) {
            return this.cloudSolrServer;
        }
        if ("INSERT_STREAMING".equals(operation)) {
            return this.concSolrServer;
        }
        return this.httpServer;
    }

    public void process(Exchange exchange) throws Exception {
        String operation = (String)exchange.getIn().getHeader("SolrOperation");
        if (operation == null) {
            throw new IllegalArgumentException("SolrOperation header is missing");
        }
        SolrClient serverToUse = this.getBestSolrServer(operation);
        if (operation.equalsIgnoreCase("INSERT")) {
            this.insert(exchange, serverToUse);
        } else if (operation.equalsIgnoreCase("INSERT_STREAMING")) {
            this.insert(exchange, serverToUse);
        } else if (operation.equalsIgnoreCase("DELETE_BY_ID")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.deleteById((String)exchange.getIn().getBody(String.class));
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("DELETE_BY_QUERY")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.deleteByQuery((String)exchange.getIn().getBody(String.class));
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("ADD_BEAN")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.add(serverToUse.getBinder().toSolrInputDocument(exchange.getIn().getBody()));
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("ADD_BEANS")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            Collection body = (Collection)exchange.getIn().getBody(Collection.class);
            updateRequest.add((Collection)body.stream().map(arg_0 -> ((DocumentObjectBinder)serverToUse.getBinder()).toSolrInputDocument(arg_0)).collect(Collectors.toList()));
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("COMMIT")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("SOFT_COMMIT")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true, true);
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("ROLLBACK")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.rollback();
            updateRequest.process(serverToUse);
        } else if (operation.equalsIgnoreCase("OPTIMIZE")) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, true, true, 1);
            updateRequest.process(serverToUse);
        } else {
            throw new IllegalArgumentException("SolrOperation header value '" + operation + "' is not supported");
        }
    }

    private void insert(Exchange exchange, SolrClient solrServer) throws Exception {
        Object body = exchange.getIn().getBody();
        boolean invalid = false;
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("Content-Type", String.class))) {
            String mimeType = (String)exchange.getIn().getHeader("Content-Type", String.class);
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler());
            updateRequest.setBasicAuthCredentials(this.getEndpoint().getUsername(), this.getEndpoint().getPassword());
            updateRequest.addFile((File)body, mimeType);
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
                String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
                updateRequest.setParam(paramName, entry.getValue().toString());
            }
            updateRequest.process(solrServer);
        } else if (body instanceof File) {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            String mimeType = mimeTypesMap.getContentType((File)body);
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler());
            updateRequest.setBasicAuthCredentials(this.getEndpoint().getUsername(), this.getEndpoint().getPassword());
            updateRequest.addFile((File)body, mimeType);
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
                String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
                updateRequest.setParam(paramName, entry.getValue().toString());
            }
            updateRequest.process(solrServer);
        } else if (body instanceof SolrInputDocument) {
            UpdateRequest updateRequest = this.createUpdateRequest();
            updateRequest.add((SolrInputDocument)body);
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
                String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
                updateRequest.setParam(paramName, entry.getValue().toString());
            }
            updateRequest.process(solrServer);
        } else if (body instanceof List) {
            List list = (List)body;
            if (list.size() > 0 && list.get(0) instanceof SolrInputDocument) {
                UpdateRequest updateRequest = this.createUpdateRequest();
                updateRequest.add((Collection)list);
                for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("SolrParam.")) continue;
                    String paramName = ((String)entry.getKey()).substring("SolrParam.".length());
                    updateRequest.setParam(paramName, entry.getValue().toString());
                }
                updateRequest.process(solrServer);
            } else {
                invalid = true;
            }
        } else {
            boolean hasSolrHeaders = false;
            for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                hasSolrHeaders = true;
                break;
            }
            if (hasSolrHeaders) {
                UpdateRequest updateRequest = this.createUpdateRequest();
                SolrInputDocument doc = new SolrInputDocument(new String[0]);
                for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("SolrField.")) continue;
                    String fieldName = ((String)entry.getKey()).substring("SolrField.".length());
                    doc.setField(fieldName, entry.getValue());
                }
                updateRequest.add(doc);
                updateRequest.process(solrServer);
            } else if (body instanceof String) {
                String bodyAsString = (String)body;
                if (!bodyAsString.startsWith("<add")) {
                    bodyAsString = "<add>" + bodyAsString + "</add>";
                }
                DirectXmlRequest xmlRequest = new DirectXmlRequest(this.getRequestHandler(), bodyAsString);
                xmlRequest.setBasicAuthCredentials(this.getEndpoint().getUsername(), this.getEndpoint().getPassword());
                solrServer.request((SolrRequest)xmlRequest);
            } else {
                invalid = true;
            }
        }
        if (invalid) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unable to find data in Exchange to update Solr");
        }
    }

    private String getRequestHandler() {
        String requestHandler = this.getEndpoint().getRequestHandler();
        return requestHandler == null ? "/update" : requestHandler;
    }

    private UpdateRequest createUpdateRequest() {
        UpdateRequest updateRequest = new UpdateRequest(this.getRequestHandler());
        updateRequest.setBasicAuthCredentials(this.getEndpoint().getUsername(), this.getEndpoint().getPassword());
        return updateRequest;
    }

    public SolrEndpoint getEndpoint() {
        return (SolrEndpoint)super.getEndpoint();
    }

    protected void doShutdown() throws Exception {
        this.getEndpoint().onProducerShutdown(this);
    }
}

