/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Collections;
import org.apache.camel.component.kafka.KafkaManualCommit;
import org.apache.camel.spi.StateRepository;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKafkaManualCommit
implements KafkaManualCommit {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKafkaManualCommit.class);
    private final KafkaConsumer consumer;
    private final String topicName;
    private final String threadId;
    private final StateRepository<String, String> offsetRepository;
    private final TopicPartition partition;
    private final long recordOffset;

    public DefaultKafkaManualCommit(KafkaConsumer consumer, String topicName, String threadId, StateRepository<String, String> offsetRepository, TopicPartition partition, long recordOffset) {
        this.consumer = consumer;
        this.topicName = topicName;
        this.threadId = threadId;
        this.offsetRepository = offsetRepository;
        this.partition = partition;
        this.recordOffset = recordOffset;
    }

    @Override
    public void commitSync() {
        this.commitOffset(this.offsetRepository, this.partition, this.recordOffset);
    }

    protected void commitOffset(StateRepository<String, String> offsetRepository, TopicPartition partition, long recordOffset) {
        if (recordOffset != -1L) {
            if (offsetRepository != null) {
                offsetRepository.setState((Object)this.serializeOffsetKey(partition), (Object)this.serializeOffsetValue(recordOffset));
            } else {
                LOG.debug("CommitSync {} from topic {} with offset: {}", new Object[]{this.threadId, this.topicName, recordOffset});
                this.consumer.commitSync(Collections.singletonMap(partition, new OffsetAndMetadata(recordOffset + 1L)));
            }
        }
    }

    protected String serializeOffsetKey(TopicPartition topicPartition) {
        return topicPartition.topic() + '/' + topicPartition.partition();
    }

    protected String serializeOffsetValue(long offset) {
        return String.valueOf(offset);
    }

    public KafkaConsumer getConsumer() {
        return this.consumer;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public StateRepository<String, String> getOffsetRepository() {
        return this.offsetRepository;
    }

    public TopicPartition getPartition() {
        return this.partition;
    }

    public long getRecordOffset() {
        return this.recordOffset;
    }
}

