/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.event;

import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.event.AbstractExchangeEvent;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.util.URISupport;

public class ExchangeFailureHandledEvent
extends AbstractExchangeEvent
implements CamelEvent.ExchangeFailureHandledEvent {
    private static final long serialVersionUID = -7554809462006009548L;
    private final transient Processor failureHandler;
    private final boolean deadLetterChannel;
    private final String deadLetterUri;
    private final boolean handled;

    public ExchangeFailureHandledEvent(Exchange source, Processor failureHandler, boolean deadLetterChannel, String deadLetterUri) {
        super(source);
        this.failureHandler = failureHandler;
        this.deadLetterChannel = deadLetterChannel;
        this.deadLetterUri = deadLetterUri;
        this.handled = ((ExtendedExchange)source.adapt(ExtendedExchange.class)).isErrorHandlerHandledSet() && ((ExtendedExchange)source.adapt(ExtendedExchange.class)).isErrorHandlerHandled();
    }

    public Processor getFailureHandler() {
        return this.failureHandler;
    }

    public boolean isDeadLetterChannel() {
        return this.deadLetterChannel;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public boolean isContinued() {
        return !this.handled;
    }

    @Override
    public String toString() {
        if (this.isDeadLetterChannel()) {
            String uri = URISupport.sanitizeUri((String)this.deadLetterUri);
            return this.getExchange().getExchangeId() + " exchange failed: " + this.getExchange() + " but was handled by dead letter channel: " + uri;
        }
        return this.getExchange().getExchangeId() + " exchange failed: " + this.getExchange() + " but was processed by failure processor: " + this.failureHandler;
    }
}

