/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.transforms;

import java.util.Map;
import org.apache.camel.TypeConverter;
import org.apache.camel.kafkaconnector.transforms.CamelTransformSupport;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class CamelTypeConverterTransform<R extends ConnectRecord<R>>
extends CamelTransformSupport<R> {
    public static final String FIELD_TARGET_TYPE_CONFIG = "target.type";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("target.type", ConfigDef.Type.CLASS, null, ConfigDef.Importance.HIGH, "The target field type to convert the value from, this is full qualified Java class, e.g: java.util.Map");
    private static TypeConverter typeConverter;
    private Class<?> fieldTargetType;

    public R apply(R record) {
        Schema schema = this.operatingSchema(record);
        Object value = this.operatingValue(record);
        Object convertedValue = this.convertValueWithCamelTypeConverter(value);
        Schema updatedSchema = this.getOrBuildRecordSchema(schema, convertedValue);
        return this.newRecord(record, updatedSchema, convertedValue);
    }

    private Object convertValueWithCamelTypeConverter(Object originalValue) {
        Object convertedValue = typeConverter.tryConvertTo(this.fieldTargetType, originalValue);
        if (convertedValue == null) {
            throw new DataException(String.format("CamelTypeConverter was not able to convert value `%s` to target type of `%s`", originalValue, this.fieldTargetType.getSimpleName()));
        }
        return convertedValue;
    }

    private Schema getOrBuildRecordSchema(Schema originalSchema, Object value) {
        SchemaBuilder builder = SchemaUtil.copySchemaBasics((Schema)originalSchema, (SchemaBuilder)SchemaHelper.buildSchemaBuilderForType(value));
        if (originalSchema.isOptional()) {
            builder.optional();
        }
        if (originalSchema.defaultValue() != null) {
            builder.defaultValue(this.convertValueWithCamelTypeConverter(originalSchema.defaultValue()));
        }
        return builder.build();
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    public void configure(Map<String, ?> props) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, props);
        this.fieldTargetType = config.getClass(FIELD_TARGET_TYPE_CONFIG);
        if (this.fieldTargetType == null) {
            throw new ConfigException("Configuration 'target.type' can not be empty!");
        }
        typeConverter = this.getCamelContext().getTypeConverter();
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    public static final class Value<R extends ConnectRecord<R>>
    extends CamelTypeConverterTransform<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, updatedValue, record.timestamp());
        }
    }

    public static final class Key<R extends ConnectRecord<R>>
    extends CamelTypeConverterTransform<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return record.key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), updatedSchema, updatedValue, record.valueSchema(), record.value(), record.timestamp());
        }
    }
}

