/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CreatePartitionsRequestData
implements ApiMessage {
    private List<CreatePartitionsTopic> topics;
    private int timeoutMs;
    private boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public CreatePartitionsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreatePartitionsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public CreatePartitionsRequestData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public CreatePartitionsRequestData() {
        this.topics = new ArrayList<CreatePartitionsTopic>(0);
        this.timeoutMs = 0;
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 37;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<CreatePartitionsTopic> newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatePartitionsTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new ArrayList<CreatePartitionsTopic>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatePartitionsTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (CreatePartitionsTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (CreatePartitionsTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<CreatePartitionsTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new CreatePartitionsTopic((Struct)nestedObject, _version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        this.validateOnly = struct.getBoolean("validate_only");
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (CreatePartitionsTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("validate_only", (Object)this.validateOnly);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("CreatePartitionsRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("CreatePartitionsRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        this.topics = new ArrayList<CreatePartitionsTopic>();
        for (JsonNode _element : _topicsNode) {
            this.topics.add(new CreatePartitionsTopic(_element, _version));
        }
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("CreatePartitionsRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        this.timeoutMs = MessageUtil.jsonNodeToInt(_timeoutMsNode, "CreatePartitionsRequestData");
        JsonNode _validateOnlyNode = _node.get("validateOnly");
        if (_validateOnlyNode == null) {
            throw new RuntimeException("CreatePartitionsRequestData: unable to locate field 'validateOnly', which is mandatory in version " + _version);
        }
        if (!_validateOnlyNode.isBoolean()) {
            throw new RuntimeException("CreatePartitionsRequestData expected Boolean type, but got " + _node.getNodeType());
        }
        this.validateOnly = _validateOnlyNode.asBoolean();
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (CreatePartitionsTopic _element : this.topics) {
            _topicsArray.add(_element.toJson(_version));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        _node.set("timeoutMs", (JsonNode)new IntNode(this.timeoutMs));
        _node.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)this.validateOnly));
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1)) : (_arraySize += 4);
        for (CreatePartitionsTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreatePartitionsRequestData)) {
            return false;
        }
        CreatePartitionsRequestData other = (CreatePartitionsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public CreatePartitionsRequestData duplicate() {
        CreatePartitionsRequestData _duplicate = new CreatePartitionsRequestData();
        ArrayList<CreatePartitionsTopic> newTopics = new ArrayList<CreatePartitionsTopic>(this.topics.size());
        for (CreatePartitionsTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        _duplicate.timeoutMs = this.timeoutMs;
        _duplicate.validateOnly = this.validateOnly;
        return _duplicate;
    }

    public String toString() {
        return "CreatePartitionsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public List<CreatePartitionsTopic> topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreatePartitionsRequestData setTopics(List<CreatePartitionsTopic> v) {
        this.topics = v;
        return this;
    }

    public CreatePartitionsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreatePartitionsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatePartitionsTopic.SCHEMA_0), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."));
        SCHEMA_2 = new Schema(new Field("topics", new CompactArrayOf(CreatePartitionsTopic.SCHEMA_2), "Each topic that we want to create new partitions inside."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the partitions to be created."), new Field("validate_only", Type.BOOLEAN, "If true, then validate the request, but don't actually increase the number of partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class CreatePartitionsAssignment
    implements Message {
        private List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsAssignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatePartitionsAssignment(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public CreatePartitionsAssignment(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public CreatePartitionsAssignment() {
            this.brokerIds = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
            } else {
                _writable.writeInt(this.brokerIds.size());
            }
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsAssignment");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            Object[] _nestedObjects = struct.getArray("broker_ids");
            this.brokerIds = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.brokerIds.add((Integer)nestedObject);
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsAssignment");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            Integer[] _nestedObjects = new Integer[this.brokerIds.size()];
            int i = 0;
            for (Integer element : this.brokerIds) {
                _nestedObjects[i++] = element;
            }
            struct.set("broker_ids", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _brokerIdsNode = _node.get("brokerIds");
            if (_brokerIdsNode == null) {
                throw new RuntimeException("CreatePartitionsAssignment: unable to locate field 'brokerIds', which is mandatory in version " + _version);
            }
            if (!_brokerIdsNode.isArray()) {
                throw new RuntimeException("CreatePartitionsAssignment expected a JSON array, but got " + _node.getNodeType());
            }
            this.brokerIds = new ArrayList<Integer>();
            for (JsonNode _element : _brokerIdsNode) {
                this.brokerIds.add(MessageUtil.jsonNodeToInt(_element, "CreatePartitionsAssignment element"));
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            ArrayNode _brokerIdsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : this.brokerIds) {
                _brokerIdsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("brokerIds", (JsonNode)_brokerIdsArray);
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsAssignment");
            }
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsAssignment)) {
                return false;
            }
            CreatePartitionsAssignment other = (CreatePartitionsAssignment)obj;
            return !(this.brokerIds == null ? other.brokerIds != null : !this.brokerIds.equals(other.brokerIds));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.brokerIds == null ? 0 : this.brokerIds.hashCode());
            return hashCode;
        }

        @Override
        public CreatePartitionsAssignment duplicate() {
            CreatePartitionsAssignment _duplicate = new CreatePartitionsAssignment();
            ArrayList<Integer> newBrokerIds = new ArrayList<Integer>(this.brokerIds.size());
            for (Integer _element : this.brokerIds) {
                newBrokerIds.add(_element);
            }
            _duplicate.brokerIds = newBrokerIds;
            return _duplicate;
        }

        public String toString() {
            return "CreatePartitionsAssignment(brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_ids", new ArrayOf(Type.INT32), "The assigned broker IDs."));
            SCHEMA_2 = new Schema(new Field("broker_ids", new CompactArrayOf(Type.INT32), "The assigned broker IDs."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class CreatePartitionsTopic
    implements Message {
        private String name;
        private int count;
        private List<CreatePartitionsAssignment> assignments;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public CreatePartitionsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatePartitionsTopic(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public CreatePartitionsTopic(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public CreatePartitionsTopic() {
            this.name = "";
            this.count = 0;
            this.assignments = new ArrayList<CreatePartitionsAssignment>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<CreatePartitionsAssignment> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.count = _readable.readInt();
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.assignments = null;
                } else {
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                    }
                    this.assignments = newCollection;
                }
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    this.assignments = null;
                } else {
                    newCollection = new ArrayList<CreatePartitionsAssignment>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new CreatePartitionsAssignment(_readable, _version));
                    }
                    this.assignments = newCollection;
                }
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.count);
            if (_version >= 2) {
                if (this.assignments == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.assignments.size() + 1);
                    _stringBytes = this.assignments.iterator();
                    while (_stringBytes.hasNext()) {
                        CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                        assignmentsElement.write(_writable, _cache, _version);
                    }
                }
            } else if (this.assignments == null) {
                _writable.writeInt(-1);
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    CreatePartitionsAssignment assignmentsElement = (CreatePartitionsAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatePartitionsTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.count = struct.getInt("count");
            Object[] _nestedObjects = struct.getArray("assignments");
            if (_nestedObjects == null) {
                this.assignments = null;
            } else {
                this.assignments = new ArrayList<CreatePartitionsAssignment>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.assignments.add(new CreatePartitionsAssignment((Struct)nestedObject, _version));
                }
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatePartitionsTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("count", (Object)this.count);
            if (this.assignments == null) {
                struct.set("assignments", null);
            } else {
                Struct[] _nestedObjects = new Struct[this.assignments.size()];
                int i = 0;
                for (CreatePartitionsAssignment element : this.assignments) {
                    _nestedObjects[i++] = element.toStruct(_version);
                }
                struct.set("assignments", (Object)_nestedObjects);
            }
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatePartitionsTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatePartitionsTopic expected a string type, but got " + _node.getNodeType());
            }
            this.name = _nameNode.asText();
            JsonNode _countNode = _node.get("count");
            if (_countNode == null) {
                throw new RuntimeException("CreatePartitionsTopic: unable to locate field 'count', which is mandatory in version " + _version);
            }
            this.count = MessageUtil.jsonNodeToInt(_countNode, "CreatePartitionsTopic");
            JsonNode _assignmentsNode = _node.get("assignments");
            if (_assignmentsNode == null) {
                throw new RuntimeException("CreatePartitionsTopic: unable to locate field 'assignments', which is mandatory in version " + _version);
            }
            if (_assignmentsNode.isNull()) {
                this.assignments = null;
            } else {
                if (!_assignmentsNode.isArray()) {
                    throw new RuntimeException("CreatePartitionsTopic expected a JSON array, but got " + _node.getNodeType());
                }
                this.assignments = new ArrayList<CreatePartitionsAssignment>();
                for (JsonNode _element : _assignmentsNode) {
                    this.assignments.add(new CreatePartitionsAssignment(_element, _version));
                }
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(this.name));
            _node.set("count", (JsonNode)new IntNode(this.count));
            if (this.assignments == null) {
                _node.set("assignments", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _assignmentsArray = new ArrayNode(JsonNodeFactory.instance);
                for (CreatePartitionsAssignment _element : this.assignments) {
                    _assignmentsArray.add(_element.toJson(_version));
                }
                _node.set("assignments", (JsonNode)_assignmentsArray);
            }
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatePartitionsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 4;
            if (this.assignments == null) {
                _size = _version >= 2 ? ++_size : (_size += 4);
            } else {
                int _arraySize = 0;
                _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.assignments.size() + 1)) : (_arraySize += 4);
                for (CreatePartitionsAssignment assignmentsElement : this.assignments) {
                    _arraySize += assignmentsElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatePartitionsTopic)) {
                return false;
            }
            CreatePartitionsTopic other = (CreatePartitionsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.count != other.count) {
                return false;
            }
            return !(this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.count;
            hashCode = 31 * hashCode + (this.assignments == null ? 0 : this.assignments.hashCode());
            return hashCode;
        }

        @Override
        public CreatePartitionsTopic duplicate() {
            CreatePartitionsTopic _duplicate = new CreatePartitionsTopic();
            _duplicate.name = this.name;
            _duplicate.count = this.count;
            if (this.assignments == null) {
                _duplicate.assignments = null;
            } else {
                ArrayList<CreatePartitionsAssignment> newAssignments = new ArrayList<CreatePartitionsAssignment>(this.assignments.size());
                for (CreatePartitionsAssignment _element : this.assignments) {
                    newAssignments.add(_element.duplicate());
                }
                _duplicate.assignments = newAssignments;
            }
            return _duplicate;
        }

        public String toString() {
            return "CreatePartitionsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", count=" + this.count + ", assignments=" + (this.assignments == null ? "null" : MessageUtil.deepToString(this.assignments.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public int count() {
            return this.count;
        }

        public List<CreatePartitionsAssignment> assignments() {
            return this.assignments;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatePartitionsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatePartitionsTopic setCount(int v) {
            this.count = v;
            return this;
        }

        public CreatePartitionsTopic setAssignments(List<CreatePartitionsAssignment> v) {
            this.assignments = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", ArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_0), "The new partition assignments."));
            SCHEMA_2 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("count", Type.INT32, "The new partition count."), new Field("assignments", CompactArrayOf.nullable(CreatePartitionsAssignment.SCHEMA_2), "The new partition assignments."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

