/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;

@Metadata(label="bean", description="An AggregationStrategy which just uses the original exchange which can be needed when you want to preserve the original Exchange. For example when splitting an Exchange and then you may want to keep routing using the original Exchange.", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class UseOriginalAggregationStrategy
implements AggregationStrategy {
    private final Exchange original;
    private final boolean propagateException;

    public UseOriginalAggregationStrategy() {
        this(null, true);
    }

    public UseOriginalAggregationStrategy(boolean propagateException) {
        this(null, propagateException);
    }

    public UseOriginalAggregationStrategy(Exchange original, boolean propagateException) {
        this.original = original;
        this.propagateException = propagateException;
    }

    public UseOriginalAggregationStrategy newInstance(Exchange original) {
        return new UseOriginalAggregationStrategy(original, this.propagateException);
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (this.propagateException) {
            Exception exception = this.checkException(oldExchange, newExchange);
            if (exception != null) {
                if (this.original != null) {
                    this.original.setException((Throwable)exception);
                } else {
                    oldExchange.setException((Throwable)exception);
                }
            }
            if ((exception = this.checkCaughtException(oldExchange, newExchange)) != null) {
                if (this.original != null) {
                    this.original.setProperty("CamelExceptionCaught", (Object)exception);
                } else {
                    oldExchange.setProperty("CamelExceptionCaught", (Object)exception);
                }
            }
        }
        return this.original != null ? this.original : oldExchange;
    }

    protected Exception checkException(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange == null) {
            return newExchange.getException();
        }
        return newExchange != null && newExchange.getException() != null ? newExchange.getException() : oldExchange.getException();
    }

    protected Exception checkCaughtException(Exchange oldExchange, Exchange newExchange) {
        Exception caught = (Exception)newExchange.getProperty("CamelExceptionCaught", Exception.class);
        if (caught == null && oldExchange != null) {
            caught = (Exception)oldExchange.getProperty("CamelExceptionCaught", Exception.class);
        }
        return caught;
    }

    public Exchange getOriginal() {
        return this.original;
    }

    public String toString() {
        return "UseOriginalAggregationStrategy";
    }
}

