/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurerResolver
implements ConfigurerResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurerResolver.class);
    protected FactoryFinder factoryFinder;

    public DefaultConfigurerResolver() {
    }

    public DefaultConfigurerResolver(FactoryFinder factoryFinder) {
        this.factoryFinder = factoryFinder;
    }

    public PropertyConfigurer resolvePropertyConfigurer(String name, CamelContext context) {
        Class<?> type;
        if (ObjectHelper.isEmpty((Object)name)) {
            return null;
        }
        PropertyConfigurer configurer = (PropertyConfigurer)context.getRegistry().lookupByNameAndType(name, PropertyConfigurer.class);
        if (configurer != null) {
            return configurer;
        }
        if (name.endsWith("-configurer")) {
            name = name.substring(0, name.length() - 11);
        }
        try {
            type = this.findConfigurer(name, context);
            if (type == null) {
                if (name.startsWith("org.apache.camel.") && name.contains("CamelContext")) {
                    type = this.findConfigurer(ExtendedCamelContext.class.getName(), context);
                }
                if (type == null) {
                    return null;
                }
            }
        }
        catch (NoFactoryAvailableException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Configurer registered for scheme: " + name, e);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Found configurer: {} via type: {} via: {}{}", new Object[]{name, type.getName(), this.factoryFinder.getResourcePath(), name});
        }
        if (PropertyConfigurer.class.isAssignableFrom(type)) {
            return (PropertyConfigurer)context.getInjector().newInstance(type, false);
        }
        throw new IllegalArgumentException("Type is not a PropertyConfigurer implementation. Found: " + type.getName());
    }

    private Class<?> findConfigurer(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder("META-INF/services/org/apache/camel/configurer/");
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }

    protected Logger getLog() {
        return LOG;
    }
}

