/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.types.BinaryOperatorType;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.builder.PredicateBuilder;
import org.apache.camel.support.builder.ValueBuilder;
import org.apache.camel.util.ObjectHelper;

public class BinaryExpression
extends BaseSimpleNode {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(\\d+)(\\.\\.)(\\d+)$");
    private final BinaryOperatorType operator;
    private SimpleNode left;
    private SimpleNode right;

    public BinaryExpression(SimpleToken token) {
        super(token);
        this.operator = BinaryOperatorType.asOperator(token.getText());
    }

    @Override
    public String toString() {
        return this.left + " " + this.token.getText() + " " + this.right;
    }

    public boolean acceptLeftNode(SimpleNode lef) {
        this.left = lef;
        return true;
    }

    public boolean acceptRightNode(SimpleNode right) {
        this.right = right;
        return true;
    }

    public BinaryOperatorType getOperator() {
        return this.operator;
    }

    @Override
    public Expression createExpression(String expression) {
        ObjectHelper.notNull((Object)this.left, (String)"left node", (Object)this);
        ObjectHelper.notNull((Object)this.right, (String)"right node", (Object)this);
        Expression leftExp = this.left.createExpression(expression);
        Expression rightExp = this.right.createExpression(expression);
        if (this.operator == BinaryOperatorType.EQ) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isEqualTo((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.EQ_IGNORE) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isEqualToIgnoreCase((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.GT) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isGreaterThan((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.GTE) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isGreaterThanOrEqualTo((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.LT) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isLessThan((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.LTE) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isLessThanOrEqualTo((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_EQ) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.isNotEqualTo((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_EQ_IGNORE) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.not((Predicate)PredicateBuilder.isEqualToIgnoreCase((Expression)leftExp, (Expression)rightExp)));
        }
        if (this.operator == BinaryOperatorType.CONTAINS) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.contains((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_CONTAINS) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.not((Predicate)PredicateBuilder.contains((Expression)leftExp, (Expression)rightExp)));
        }
        if (this.operator == BinaryOperatorType.CONTAINS_IGNORECASE) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.containsIgnoreCase((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_CONTAINS_IGNORECASE) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.not((Predicate)PredicateBuilder.containsIgnoreCase((Expression)leftExp, (Expression)rightExp)));
        }
        if (this.operator == BinaryOperatorType.IS || this.operator == BinaryOperatorType.NOT_IS) {
            return this.createIsExpression(expression, leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.REGEX || this.operator == BinaryOperatorType.NOT_REGEX) {
            return this.createRegexExpression(leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.IN || this.operator == BinaryOperatorType.NOT_IN) {
            return this.createInExpression(leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.RANGE || this.operator == BinaryOperatorType.NOT_RANGE) {
            return this.createRangeExpression(expression, leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.STARTS_WITH) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.startsWith((Expression)leftExp, (Expression)rightExp));
        }
        if (this.operator == BinaryOperatorType.ENDS_WITH) {
            return this.createExpression(leftExp, rightExp, PredicateBuilder.endsWith((Expression)leftExp, (Expression)rightExp));
        }
        throw new SimpleParserException("Unknown binary operator " + (Object)((Object)this.operator), this.token.getIndex());
    }

    private Expression createIsExpression(final String expression, final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                String name = (String)rightExp.evaluate(exchange, String.class);
                if (name == null || "null".equals(name)) {
                    throw new SimpleIllegalSyntaxException(expression, BinaryExpression.this.right.getToken().getIndex(), (Object)((Object)BinaryExpression.this.operator) + " operator cannot accept null. A class type must be provided.");
                }
                Class rightType = exchange.getContext().getClassResolver().resolveClass(name);
                if (rightType == null) {
                    throw new SimpleIllegalSyntaxException(expression, BinaryExpression.this.right.getToken().getIndex(), (Object)((Object)BinaryExpression.this.operator) + " operator cannot find class with name: " + name);
                }
                Predicate predicate = PredicateBuilder.isInstanceOf((Expression)leftExp, (Class)rightType);
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_IS) {
                    predicate = PredicateBuilder.not((Predicate)predicate);
                }
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return BinaryExpression.this.left + " " + BinaryExpression.this.token.getText() + " " + BinaryExpression.this.right;
            }
        };
    }

    private Expression createRegexExpression(final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Predicate predicate = PredicateBuilder.regex((Expression)leftExp, (String)((String)rightExp.evaluate(exchange, String.class)));
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_REGEX) {
                    predicate = PredicateBuilder.not((Predicate)predicate);
                }
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return BinaryExpression.this.left + " " + BinaryExpression.this.token.getText() + " " + BinaryExpression.this.right;
            }
        };
    }

    private Expression createInExpression(final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)rightExp.evaluate(exchange, Object.class));
                ArrayList values = new ArrayList();
                while (it.hasNext()) {
                    values.add(it.next());
                }
                ValueBuilder vb = new ValueBuilder(leftExp);
                Predicate predicate = vb.in(values.toArray());
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_IN) {
                    predicate = PredicateBuilder.not((Predicate)predicate);
                }
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return BinaryExpression.this.left + " " + BinaryExpression.this.token.getText() + " " + BinaryExpression.this.right;
            }
        };
    }

    private Expression createRangeExpression(final String expression, final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                String range = (String)rightExp.evaluate(exchange, String.class);
                Matcher matcher = RANGE_PATTERN.matcher(range);
                if (!matcher.matches()) {
                    throw new SimpleIllegalSyntaxException(expression, BinaryExpression.this.right.getToken().getIndex(), (Object)((Object)BinaryExpression.this.operator) + " operator is not valid. Valid syntax:'from..to' (where from and to are numbers).");
                }
                Expression from = ExpressionBuilder.constantExpression((Object)matcher.group(1));
                Expression to = ExpressionBuilder.constantExpression((Object)matcher.group(3));
                Predicate predicate = PredicateBuilder.isGreaterThanOrEqualTo((Expression)leftExp, (Expression)from);
                predicate = PredicateBuilder.and((Predicate)predicate, (Predicate)PredicateBuilder.isLessThanOrEqualTo((Expression)leftExp, (Expression)to));
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_RANGE) {
                    predicate = PredicateBuilder.not((Predicate)predicate);
                }
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return BinaryExpression.this.left + " " + BinaryExpression.this.token.getText() + " " + BinaryExpression.this.right;
            }
        };
    }

    private Expression createExpression(final Expression left, final Expression right, final Predicate predicate) {
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                boolean answer = predicate.matches(exchange);
                return (T)exchange.getContext().getTypeConverter().convertTo(type, (Object)answer);
            }

            public String toString() {
                return left + " " + BinaryExpression.this.token.getText() + " " + right;
            }
        };
    }
}

