/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.util.Arrays;

public class HexUtil {
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexUtil() {
        throw new InstantiationError("This class must not be instantiated");
    }

    public static String convertStringToHexString(String data) {
        return HexUtil.convertBytesToHexString(data.getBytes());
    }

    public static String convertByteToHexString(byte data) {
        StringBuilder stringBuilder = new StringBuilder(2);
        stringBuilder.append(hexChar[data >> 4 & 0xF]);
        stringBuilder.append(hexChar[data & 0xF]);
        return stringBuilder.toString();
    }

    public static String convertBytesToHexString(byte[] data) {
        return HexUtil.convertBytesToHexString(data, 0, data.length);
    }

    public static String convertBytesToHexString(byte[] data, int offset, int length) {
        return HexUtil.convertBytesToHexString(data, offset, length, "");
    }

    public static String convertBytesToHexString(byte[] data, int offset, int length, String byteDelimiter) {
        StringBuilder stringBuilder = new StringBuilder((length - offset) * (2 + byteDelimiter.length()));
        for (int i = offset; i < length; ++i) {
            stringBuilder.append(hexChar[data[i] >> 4 & 0xF]);
            stringBuilder.append(hexChar[data[i] & 0xF]);
            stringBuilder.append(byteDelimiter);
        }
        return stringBuilder.toString();
    }

    public static String convertHexStringToString(String hexString) {
        String uHexString = hexString.toLowerCase();
        StringBuilder sBld = new StringBuilder();
        for (int i = 0; i < uHexString.length(); i += 2) {
            char c = (char)Integer.parseInt(uHexString.substring(i, i + 2), 16);
            sBld.append(c);
        }
        return sBld.toString();
    }

    public static byte[] convertHexStringToBytes(String hexString) {
        return HexUtil.convertHexStringToBytes(hexString, 0, hexString.length());
    }

    public static byte[] convertHexStringToBytes(String hexString, int offset, int endIndex) {
        int i;
        String realHexString = hexString.substring(offset, endIndex).toLowerCase();
        byte[] data = realHexString.length() % 2 == 0 ? new byte[realHexString.length() / 2] : new byte[(int)Math.ceil((double)realHexString.length() / 2.0)];
        int j = 0;
        for (i = 0; i < realHexString.length(); i += 2) {
            char[] tmp;
            try {
                tmp = realHexString.substring(i, i + 2).toCharArray();
            }
            catch (StringIndexOutOfBoundsException siob) {
                tmp = (realHexString.substring(i) + "0").toCharArray();
            }
            data[j] = (byte)((Arrays.binarySearch(hexChar, tmp[0]) & 0xF) << 4);
            int n = j++;
            data[n] = (byte)(data[n] | (byte)(Arrays.binarySearch(hexChar, tmp[1]) & 0xF));
        }
        for (i = realHexString.length(); i > 0; i -= 2) {
        }
        return data;
    }
}

