/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSmResp;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.DataSmCommandTask;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.EnquireLinkCommandTask;
import org.jsmpp.session.SMPPOperation;
import org.jsmpp.session.SendCommandTask;
import org.jsmpp.session.UnbindCommandTask;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.util.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSMPPOperation
implements SMPPOperation {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSMPPOperation.class);
    private final Sequence sequence = new Sequence(1);
    private final PDUSender pduSender;
    private final Connection connection;
    private long transactionTimer = 2000L;

    public AbstractSMPPOperation(Connection connection, PDUSender pduSender) {
        this.connection = connection;
        this.pduSender = pduSender;
    }

    protected PDUSender pduSender() {
        return this.pduSender;
    }

    protected Connection connection() {
        return this.connection;
    }

    public void setTransactionTimer(long transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    public long getTransactionTimer() {
        return this.transactionTimer;
    }

    protected Command executeSendCommand(SendCommandTask task, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        int seqNum = this.sequence.nextValue();
        PendingResponse pendingResp = new PendingResponse(timeout);
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            logger.error("Failed sending {} command", (Object)task.getCommandName(), (Object)e);
            throw e;
        }
        try {
            pendingResp.waitDone();
            logger.debug("{} response received", (Object)task.getCommandName());
        }
        catch (ResponseTimeoutException e) {
            logger.debug("Response timeout for {} with sequence_number {}", (Object)task.getCommandName(), (Object)seqNum);
            throw e;
        }
        Object resp = pendingResp.getResponse();
        AbstractSMPPOperation.validateResponse(resp);
        return resp;
    }

    protected void executeSendCommandWithNoResponse(SendCommandTask task) throws PDUException, IOException {
        int seqNum = this.sequence.nextValue();
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            logger.error("Failed sending {} command", (Object)task.getCommandName(), (Object)e);
            throw e;
        }
    }

    private static void validateResponse(Command response) throws NegativeResponseException {
        if (response.getCommandStatus() != 0) {
            throw new NegativeResponseException(response.getCommandStatus());
        }
    }

    @Override
    public void unbind() throws ResponseTimeoutException, InvalidResponseException, IOException {
        UnbindCommandTask task = new UnbindCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.transactionTimer);
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            logger.warn("Receive non-ok command_status ({}) for unbind_resp", (Object)e.getCommandStatus(), (Object)e);
        }
    }

    @Override
    public void unbindResp(int sequenceNumber) throws IOException {
        this.pduSender.sendUnbindResp(this.connection().getOutputStream(), 0, sequenceNumber);
    }

    @Override
    public DataSmResult dataSm(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, RegisteredDelivery registeredDelivery, DataCoding dataCoding, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        DataSmCommandTask task = new DataSmCommandTask(this.pduSender, serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, registeredDelivery, dataCoding, optionalParameters);
        DataSmResp resp = (DataSmResp)this.executeSendCommand(task, this.getTransactionTimer());
        return new DataSmResult(resp.getMessageId(), resp.getOptionalParameters());
    }

    @Override
    public void dataSmResp(int sequenceNumber, String messageId, OptionalParameter ... optionalParameters) throws PDUStringException, IOException {
        this.pduSender.sendDataSmResp(this.connection().getOutputStream(), sequenceNumber, messageId, optionalParameters);
    }

    @Override
    public void enquireLink() throws ResponseTimeoutException, InvalidResponseException, IOException {
        EnquireLinkCommandTask task = new EnquireLinkCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.getTransactionTimer());
        }
        catch (PDUException e) {
            logger.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            logger.warn("command_status of response should be always 0", (Throwable)e);
        }
    }

    @Override
    public void enquireLinkResp(int sequenceNumber) throws IOException {
        this.pduSender.sendEnquireLinkResp(this.connection().getOutputStream(), sequenceNumber);
    }

    @Override
    public void genericNack(int commandStatus, int sequenceNumber) throws IOException {
        this.pduSender.sendGenericNack(this.connection().getOutputStream(), commandStatus, sequenceNumber);
    }
}

