/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.MessageClass;

public class GeneralDataCoding
implements DataCoding {
    public static final GeneralDataCoding DEFAULT = new GeneralDataCoding();
    private final boolean compressed;
    private final Alphabet alphabet;
    private final MessageClass messageClass;

    public GeneralDataCoding() {
        this(Alphabet.ALPHA_DEFAULT);
    }

    public GeneralDataCoding(Alphabet alphabet) {
        this(alphabet, null);
    }

    public GeneralDataCoding(Alphabet alphabet, MessageClass messageClass) {
        this(alphabet, messageClass, false);
    }

    public GeneralDataCoding(Alphabet alphabet, MessageClass messageClass, boolean compressed) throws IllegalArgumentException {
        if (alphabet == null) {
            throw new IllegalArgumentException("alphabet is mandatory, can't be null");
        }
        this.alphabet = alphabet;
        this.messageClass = messageClass;
        this.compressed = compressed;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public MessageClass getMessageClass() {
        return this.messageClass;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public byte toByte() {
        byte value = this.compressed ? (byte)32 : 0;
        value = (byte)(value | this.alphabet.value());
        if (this.messageClass != null) {
            value = (byte)(value | 0x10);
            value = (byte)(value | this.messageClass.value());
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alphabet == null ? 0 : this.alphabet.hashCode());
        result = 31 * result + (this.compressed ? 1231 : 1237);
        result = 31 * result + (this.messageClass == null ? 0 : this.messageClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralDataCoding other = (GeneralDataCoding)obj;
        if (this.alphabet == null ? other.alphabet != null : !this.alphabet.equals((Object)other.alphabet)) {
            return false;
        }
        if (this.compressed != other.compressed) {
            return false;
        }
        return !(this.messageClass == null ? other.messageClass != null : !this.messageClass.equals((Object)other.messageClass));
    }

    public String toString() {
        return "DataCoding:" + (0xFF & this.toByte());
    }
}

