/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.SimpleMain;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelKafkaConnectMain
extends SimpleMain {
    public static final String CAMEL_DATAFORMAT_PROPERTIES_PREFIX = "camel.dataformat.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelKafkaConnectMain.class);
    protected volatile ConsumerTemplate consumerTemplate;
    protected volatile ProducerTemplate producerTemplate;

    public CamelKafkaConnectMain(CamelContext context) {
        super(context);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.consumerTemplate);
        this.consumerTemplate = null;
        ServiceHelper.stopService((Object)this.producerTemplate);
        this.producerTemplate = null;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerTemplate getProducerTemplate() {
        if (this.producerTemplate == null) {
            CamelKafkaConnectMain camelKafkaConnectMain = this;
            synchronized (camelKafkaConnectMain) {
                if (this.producerTemplate == null) {
                    this.producerTemplate = this.getCamelContext().createProducerTemplate();
                }
            }
        }
        return this.producerTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerTemplate getConsumerTemplate() {
        if (this.consumerTemplate == null) {
            CamelKafkaConnectMain camelKafkaConnectMain = this;
            synchronized (camelKafkaConnectMain) {
                if (this.consumerTemplate == null) {
                    this.consumerTemplate = this.getCamelContext().createConsumerTemplate();
                }
            }
        }
        return this.consumerTemplate;
    }

    public static Builder builder(String from, String to) {
        return new Builder(from, to);
    }

    public static final class Builder {
        private final String from;
        private final String to;
        private Map<String, String> props;
        private String marshallDataFormat;
        private String unmarshallDataFormat;
        private int aggregationSize;
        private long aggregationTimeout;

        public Builder(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public Builder withProperties(Map<String, String> props) {
            this.props = new HashMap<String, String>(props);
            return this;
        }

        public Builder withMarshallDataFormat(String dataformatId) {
            this.marshallDataFormat = dataformatId;
            return this;
        }

        public Builder withUnmarshallDataFormat(String dataformatId) {
            this.unmarshallDataFormat = dataformatId;
            return this;
        }

        public Builder withAggregationSize(int aggregationSize) {
            this.aggregationSize = aggregationSize;
            return this;
        }

        public Builder withAggregationTimeout(long aggregationTimeout) {
            this.aggregationTimeout = aggregationTimeout;
            return this;
        }

        public CamelKafkaConnectMain build(CamelContext camelContext) {
            CamelKafkaConnectMain camelMain = new CamelKafkaConnectMain(camelContext);
            camelMain.configure().setAutoConfigurationLogSummary(false);
            Properties camelProperties = new Properties();
            camelProperties.putAll(this.props);
            LOG.info("Setting initial properties in Camel context: [{}]", (Object)camelProperties);
            camelMain.setInitialProperties(camelProperties);
            camelMain.configure().addRoutesBuilder((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    RouteDefinition rd = this.from(from);
                    LOG.info("Creating Camel route from({})", (Object)from);
                    if (!ObjectHelper.isEmpty((Object)marshallDataFormat)) {
                        LOG.info(".marshal({})", (Object)marshallDataFormat);
                        rd.marshal(marshallDataFormat);
                    }
                    if (!ObjectHelper.isEmpty((Object)unmarshallDataFormat)) {
                        LOG.info(".unmarshal({})", (Object)unmarshallDataFormat);
                        rd.unmarshal(unmarshallDataFormat);
                    }
                    if (this.getContext().getRegistry().lookupByName("aggregate") != null) {
                        AggregationStrategy s = (AggregationStrategy)this.getContext().getRegistry().lookupByNameAndType("aggregate", AggregationStrategy.class);
                        LOG.info(".aggregate({}).constant(true).completionSize({}).completionTimeout({})", new Object[]{s, aggregationSize, aggregationTimeout});
                        LOG.info(".to({})", (Object)to);
                        ((AggregateDefinition)rd.aggregate(s).constant((Object)true)).completionSize(aggregationSize).completionTimeout(aggregationTimeout).toD(to);
                    } else {
                        LOG.info(".to({})", (Object)to);
                        rd.toD(to);
                    }
                }
            });
            return camelMain;
        }
    }
}

