/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.smpp;

import java.util.Map;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

public class CamelSmppSinkConnectorConfig
extends CamelSinkConnectorConfig {
    public static final String CAMEL_SINK_SMPP_PATH_HOST_CONF = "camel.sink.path.host";
    public static final String CAMEL_SINK_SMPP_PATH_HOST_DOC = "Hostname for the SMSC server to use.";
    public static final String CAMEL_SINK_SMPP_PATH_HOST_DEFAULT = "localhost";
    public static final String CAMEL_SINK_SMPP_PATH_PORT_CONF = "camel.sink.path.port";
    public static final String CAMEL_SINK_SMPP_PATH_PORT_DOC = "Port number for the SMSC server to use.";
    public static final String CAMEL_SINK_SMPP_PATH_PORT_DEFAULT = "2775";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_INITIAL_RECONNECT_DELAY_CONF = "camel.sink.endpoint.initialReconnectDelay";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_INITIAL_RECONNECT_DELAY_DOC = "Defines the initial delay in milliseconds after the consumer/producer tries to reconnect to the SMSC, after the connection was lost.";
    public static final Long CAMEL_SINK_SMPP_ENDPOINT_INITIAL_RECONNECT_DELAY_DEFAULT = 5000L;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_MAX_RECONNECT_CONF = "camel.sink.endpoint.maxReconnect";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_MAX_RECONNECT_DOC = "Defines the maximum number of attempts to reconnect to the SMSC, if SMSC returns a negative bind response";
    public static final Integer CAMEL_SINK_SMPP_ENDPOINT_MAX_RECONNECT_DEFAULT = Integer.MAX_VALUE;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_RECONNECT_DELAY_CONF = "camel.sink.endpoint.reconnectDelay";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_RECONNECT_DELAY_DOC = "Defines the interval in milliseconds between the reconnect attempts, if the connection to the SMSC was lost and the previous was not succeed.";
    public static final Long CAMEL_SINK_SMPP_ENDPOINT_RECONNECT_DELAY_DEFAULT = 5000L;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SPLITTING_POLICY_CONF = "camel.sink.endpoint.splittingPolicy";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SPLITTING_POLICY_DOC = "You can specify a policy for handling long messages: ALLOW - the default, long messages are split to 140 bytes per message TRUNCATE - long messages are split and only the first fragment will be sent to the SMSC. Some carriers drop subsequent fragments so this reduces load on the SMPP connection sending parts of a message that will never be delivered. REJECT - if a message would need to be split, it is rejected with an SMPP NegativeResponseException and the reason code signifying the message is too long. One of: [ALLOW] [REJECT] [TRUNCATE]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SPLITTING_POLICY_DEFAULT = "ALLOW";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_TYPE_CONF = "camel.sink.endpoint.systemType";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_TYPE_DOC = "This parameter is used to categorize the type of ESME (External Short Message Entity) that is binding to the SMSC (max. 13 characters).";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_CONF = "camel.sink.endpoint.destAddr";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_DOC = "Defines the destination SME address. For mobile terminated messages, this is the directory number of the recipient MS. Only for SubmitSm, SubmitMulti, CancelSm and DataSm.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_DEFAULT = "1717";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_NPI_CONF = "camel.sink.endpoint.destAddrNpi";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_NPI_DOC = "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_NPI_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_TON_CONF = "camel.sink.endpoint.destAddrTon";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_TON_DOC = "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_TON_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_LAZY_SESSION_CREATION_CONF = "camel.sink.endpoint.lazySessionCreation";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_LAZY_SESSION_CREATION_DOC = "Sessions can be lazily created to avoid exceptions, if the SMSC is not available when the Camel producer is started. Camel will check the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of the first exchange. If they are present, Camel will use these data to connect to the SMSC.";
    public static final Boolean CAMEL_SINK_SMPP_ENDPOINT_LAZY_SESSION_CREATION_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_SMPP_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_NUMBERING_PLAN_INDICATOR_CONF = "camel.sink.endpoint.numberingPlanIndicator";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_NUMBERING_PLAN_INDICATOR_DOC = "Defines the numeric plan indicator (NPI) to be used in the SME. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_NUMBERING_PLAN_INDICATOR_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PRIORITY_FLAG_CONF = "camel.sink.endpoint.priorityFlag";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PRIORITY_FLAG_DOC = "Allows the originating SME to assign a priority level to the short message. Only for SubmitSm and SubmitMulti. Four Priority Levels are supported: 0: Level 0 (lowest) priority 1: Level 1 priority 2: Level 2 priority 3: Level 3 (highest) priority One of: [0] [1] [2] [3]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PRIORITY_FLAG_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PROTOCOL_ID_CONF = "camel.sink.endpoint.protocolId";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PROTOCOL_ID_DOC = "The protocol id";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PROTOCOL_ID_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_REGISTERED_DELIVERY_CONF = "camel.sink.endpoint.registeredDelivery";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_REGISTERED_DELIVERY_DOC = "Is used to request an SMSC delivery receipt and/or SME originated acknowledgements. The following values are defined: 0: No SMSC delivery receipt requested. 1: SMSC delivery receipt requested where final delivery outcome is success or failure. 2: SMSC delivery receipt requested where the final delivery outcome is delivery failure. One of: [0] [1] [2]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_REGISTERED_DELIVERY_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_REPLACE_IF_PRESENT_FLAG_CONF = "camel.sink.endpoint.replaceIfPresentFlag";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_REPLACE_IF_PRESENT_FLAG_DOC = "Used to request the SMSC to replace a previously submitted message, that is still pending delivery. The SMSC will replace an existing message provided that the source address, destination address and service type match the same fields in the new message. The following replace if present flag values are defined: 0: Don't replace 1: Replace One of: [0] [1]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_REPLACE_IF_PRESENT_FLAG_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SERVICE_TYPE_CONF = "camel.sink.endpoint.serviceType";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SERVICE_TYPE_DOC = "The service type parameter can be used to indicate the SMS Application service associated with the message. The following generic service_types are defined: CMT: Cellular Messaging CPT: Cellular Paging VMN: Voice Mail Notification VMA: Voice Mail Alerting WAP: Wireless Application Protocol USSD: Unstructured Supplementary Services Data One of: [CMT] [CPT] [VMN] [VMA] [WAP] [USSD]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SERVICE_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_CONF = "camel.sink.endpoint.sourceAddr";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_DOC = "Defines the address of SME (Short Message Entity) which originated this message.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_DEFAULT = "1616";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_NPI_CONF = "camel.sink.endpoint.sourceAddrNpi";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_NPI_DOC = "Defines the numeric plan indicator (NPI) to be used in the SME originator address parameters. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_NPI_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_TON_CONF = "camel.sink.endpoint.sourceAddrTon";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_TON_DOC = "Defines the type of number (TON) to be used in the SME originator address parameters. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_TON_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_TYPE_OF_NUMBER_CONF = "camel.sink.endpoint.typeOfNumber";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_TYPE_OF_NUMBER_DOC = "Defines the type of number (TON) to be used in the SME. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_TYPE_OF_NUMBER_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_SMPP_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ENQUIRE_LINK_TIMER_CONF = "camel.sink.endpoint.enquireLinkTimer";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ENQUIRE_LINK_TIMER_DOC = "Defines the interval in milliseconds between the confidence checks. The confidence check is used to test the communication path between an ESME and an SMSC.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ENQUIRE_LINK_TIMER_DEFAULT = "5000";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SESSION_STATE_LISTENER_CONF = "camel.sink.endpoint.sessionStateListener";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SESSION_STATE_LISTENER_DOC = "You can refer to a org.jsmpp.session.SessionStateListener in the Registry to receive callbacks when the session state changed.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SESSION_STATE_LISTENER_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_SMPP_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_TRANSACTION_TIMER_CONF = "camel.sink.endpoint.transactionTimer";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_TRANSACTION_TIMER_DOC = "Defines the maximum period of inactivity allowed after a transaction, after which an SMPP entity may assume that the session is no longer active. This timer may be active on either communicating SMPP entity (i.e. SMSC or ESME).";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_TRANSACTION_TIMER_DEFAULT = "10000";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ALPHABET_CONF = "camel.sink.endpoint.alphabet";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ALPHABET_DOC = "Defines encoding of data according the SMPP 3.4 specification, section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2 Alphabet One of: [0] [4] [8]";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ALPHABET_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DATA_CODING_CONF = "camel.sink.endpoint.dataCoding";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DATA_CODING_DOC = "Defines the data coding according the SMPP 3.4 specification, section 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2 (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990)";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_DATA_CODING_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ENCODING_CONF = "camel.sink.endpoint.encoding";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ENCODING_DOC = "Defines the encoding scheme of the short message user data. Only for SubmitSm, ReplaceSm and SubmitMulti.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_ENCODING_DEFAULT = "ISO-8859-1";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_HOST_CONF = "camel.sink.endpoint.httpProxyHost";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_HOST_DOC = "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the hostname or ip address of your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PASSWORD_CONF = "camel.sink.endpoint.httpProxyPassword";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PASSWORD_DOC = "If your HTTP proxy requires basic authentication, set this attribute to the password required for your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PORT_CONF = "camel.sink.endpoint.httpProxyPort";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PORT_DOC = "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the port of your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PORT_DEFAULT = "3128";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_USERNAME_CONF = "camel.sink.endpoint.httpProxyUsername";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_USERNAME_DOC = "If your HTTP proxy requires basic authentication, set this attribute to the username required for your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PROXY_HEADERS_CONF = "camel.sink.endpoint.proxyHeaders";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PROXY_HEADERS_DOC = "These headers will be passed to the proxy server while establishing the connection.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PROXY_HEADERS_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PASSWORD_DOC = "The password for connecting to SMSC server.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_ID_CONF = "camel.sink.endpoint.systemId";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_ID_DOC = "The system id (username) for connecting to SMSC server.";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_ID_DEFAULT = "smppclient";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_USING_SSLCONF = "camel.sink.endpoint.usingSSL";
    public static final String CAMEL_SINK_SMPP_ENDPOINT_USING_SSLDOC = "Whether using SSL with the smpps protocol";
    public static final Boolean CAMEL_SINK_SMPP_ENDPOINT_USING_SSLDEFAULT = false;
    public static final String CAMEL_SINK_SMPP_COMPONENT_INITIAL_RECONNECT_DELAY_CONF = "camel.component.smpp.initialReconnectDelay";
    public static final String CAMEL_SINK_SMPP_COMPONENT_INITIAL_RECONNECT_DELAY_DOC = "Defines the initial delay in milliseconds after the consumer/producer tries to reconnect to the SMSC, after the connection was lost.";
    public static final Long CAMEL_SINK_SMPP_COMPONENT_INITIAL_RECONNECT_DELAY_DEFAULT = 5000L;
    public static final String CAMEL_SINK_SMPP_COMPONENT_MAX_RECONNECT_CONF = "camel.component.smpp.maxReconnect";
    public static final String CAMEL_SINK_SMPP_COMPONENT_MAX_RECONNECT_DOC = "Defines the maximum number of attempts to reconnect to the SMSC, if SMSC returns a negative bind response";
    public static final Integer CAMEL_SINK_SMPP_COMPONENT_MAX_RECONNECT_DEFAULT = Integer.MAX_VALUE;
    public static final String CAMEL_SINK_SMPP_COMPONENT_RECONNECT_DELAY_CONF = "camel.component.smpp.reconnectDelay";
    public static final String CAMEL_SINK_SMPP_COMPONENT_RECONNECT_DELAY_DOC = "Defines the interval in milliseconds between the reconnect attempts, if the connection to the SMSC was lost and the previous was not succeed.";
    public static final Long CAMEL_SINK_SMPP_COMPONENT_RECONNECT_DELAY_DEFAULT = 5000L;
    public static final String CAMEL_SINK_SMPP_COMPONENT_SPLITTING_POLICY_CONF = "camel.component.smpp.splittingPolicy";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SPLITTING_POLICY_DOC = "You can specify a policy for handling long messages: ALLOW - the default, long messages are split to 140 bytes per message TRUNCATE - long messages are split and only the first fragment will be sent to the SMSC. Some carriers drop subsequent fragments so this reduces load on the SMPP connection sending parts of a message that will never be delivered. REJECT - if a message would need to be split, it is rejected with an SMPP NegativeResponseException and the reason code signifying the message is too long. One of: [ALLOW] [REJECT] [TRUNCATE]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SPLITTING_POLICY_DEFAULT = "ALLOW";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SYSTEM_TYPE_CONF = "camel.component.smpp.systemType";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SYSTEM_TYPE_DOC = "This parameter is used to categorize the type of ESME (External Short Message Entity) that is binding to the SMSC (max. 13 characters).";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SYSTEM_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_CONF = "camel.component.smpp.destAddr";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_DOC = "Defines the destination SME address. For mobile terminated messages, this is the directory number of the recipient MS. Only for SubmitSm, SubmitMulti, CancelSm and DataSm.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_DEFAULT = "1717";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_NPI_CONF = "camel.component.smpp.destAddrNpi";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_NPI_DOC = "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_NPI_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_TON_CONF = "camel.component.smpp.destAddrTon";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_TON_DOC = "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_TON_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_LAZY_SESSION_CREATION_CONF = "camel.component.smpp.lazySessionCreation";
    public static final String CAMEL_SINK_SMPP_COMPONENT_LAZY_SESSION_CREATION_DOC = "Sessions can be lazily created to avoid exceptions, if the SMSC is not available when the Camel producer is started. Camel will check the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of the first exchange. If they are present, Camel will use these data to connect to the SMSC.";
    public static final Boolean CAMEL_SINK_SMPP_COMPONENT_LAZY_SESSION_CREATION_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.smpp.lazyStartProducer";
    public static final String CAMEL_SINK_SMPP_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_SMPP_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_COMPONENT_NUMBERING_PLAN_INDICATOR_CONF = "camel.component.smpp.numberingPlanIndicator";
    public static final String CAMEL_SINK_SMPP_COMPONENT_NUMBERING_PLAN_INDICATOR_DOC = "Defines the numeric plan indicator (NPI) to be used in the SME. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_NUMBERING_PLAN_INDICATOR_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_PRIORITY_FLAG_CONF = "camel.component.smpp.priorityFlag";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PRIORITY_FLAG_DOC = "Allows the originating SME to assign a priority level to the short message. Only for SubmitSm and SubmitMulti. Four Priority Levels are supported: 0: Level 0 (lowest) priority 1: Level 1 priority 2: Level 2 priority 3: Level 3 (highest) priority One of: [0] [1] [2] [3]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PRIORITY_FLAG_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_PROTOCOL_ID_CONF = "camel.component.smpp.protocolId";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PROTOCOL_ID_DOC = "The protocol id";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PROTOCOL_ID_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_REGISTERED_DELIVERY_CONF = "camel.component.smpp.registeredDelivery";
    public static final String CAMEL_SINK_SMPP_COMPONENT_REGISTERED_DELIVERY_DOC = "Is used to request an SMSC delivery receipt and/or SME originated acknowledgements. The following values are defined: 0: No SMSC delivery receipt requested. 1: SMSC delivery receipt requested where final delivery outcome is success or failure. 2: SMSC delivery receipt requested where the final delivery outcome is delivery failure. One of: [0] [1] [2]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_REGISTERED_DELIVERY_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_REPLACE_IF_PRESENT_FLAG_CONF = "camel.component.smpp.replaceIfPresentFlag";
    public static final String CAMEL_SINK_SMPP_COMPONENT_REPLACE_IF_PRESENT_FLAG_DOC = "Used to request the SMSC to replace a previously submitted message, that is still pending delivery. The SMSC will replace an existing message provided that the source address, destination address and service type match the same fields in the new message. The following replace if present flag values are defined: 0: Don't replace 1: Replace One of: [0] [1]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_REPLACE_IF_PRESENT_FLAG_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_SERVICE_TYPE_CONF = "camel.component.smpp.serviceType";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SERVICE_TYPE_DOC = "The service type parameter can be used to indicate the SMS Application service associated with the message. The following generic service_types are defined: CMT: Cellular Messaging CPT: Cellular Paging VMN: Voice Mail Notification VMA: Voice Mail Alerting WAP: Wireless Application Protocol USSD: Unstructured Supplementary Services Data One of: [CMT] [CPT] [VMN] [VMA] [WAP] [USSD]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SERVICE_TYPE_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_CONF = "camel.component.smpp.sourceAddr";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_DOC = "Defines the address of SME (Short Message Entity) which originated this message.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_DEFAULT = "1616";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_NPI_CONF = "camel.component.smpp.sourceAddrNpi";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_NPI_DOC = "Defines the numeric plan indicator (NPI) to be used in the SME originator address parameters. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_NPI_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_TON_CONF = "camel.component.smpp.sourceAddrTon";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_TON_DOC = "Defines the type of number (TON) to be used in the SME originator address parameters. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_TON_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_TYPE_OF_NUMBER_CONF = "camel.component.smpp.typeOfNumber";
    public static final String CAMEL_SINK_SMPP_COMPONENT_TYPE_OF_NUMBER_DOC = "Defines the type of number (TON) to be used in the SME. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_TYPE_OF_NUMBER_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.smpp.basicPropertyBinding";
    public static final String CAMEL_SINK_SMPP_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_SMPP_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_SMPP_COMPONENT_CONFIGURATION_CONF = "camel.component.smpp.configuration";
    public static final String CAMEL_SINK_SMPP_COMPONENT_CONFIGURATION_DOC = "To use the shared SmppConfiguration as configuration.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_ENQUIRE_LINK_TIMER_CONF = "camel.component.smpp.enquireLinkTimer";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ENQUIRE_LINK_TIMER_DOC = "Defines the interval in milliseconds between the confidence checks. The confidence check is used to test the communication path between an ESME and an SMSC.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ENQUIRE_LINK_TIMER_DEFAULT = "5000";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SESSION_STATE_LISTENER_CONF = "camel.component.smpp.sessionStateListener";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SESSION_STATE_LISTENER_DOC = "You can refer to a org.jsmpp.session.SessionStateListener in the Registry to receive callbacks when the session state changed.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SESSION_STATE_LISTENER_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_TRANSACTION_TIMER_CONF = "camel.component.smpp.transactionTimer";
    public static final String CAMEL_SINK_SMPP_COMPONENT_TRANSACTION_TIMER_DOC = "Defines the maximum period of inactivity allowed after a transaction, after which an SMPP entity may assume that the session is no longer active. This timer may be active on either communicating SMPP entity (i.e. SMSC or ESME).";
    public static final String CAMEL_SINK_SMPP_COMPONENT_TRANSACTION_TIMER_DEFAULT = "10000";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ALPHABET_CONF = "camel.component.smpp.alphabet";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ALPHABET_DOC = "Defines encoding of data according the SMPP 3.4 specification, section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2 Alphabet One of: [0] [4] [8]";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ALPHABET_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_DATA_CODING_CONF = "camel.component.smpp.dataCoding";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DATA_CODING_DOC = "Defines the data coding according the SMPP 3.4 specification, section 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2 (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990)";
    public static final String CAMEL_SINK_SMPP_COMPONENT_DATA_CODING_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_ENCODING_CONF = "camel.component.smpp.encoding";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ENCODING_DOC = "Defines the encoding scheme of the short message user data. Only for SubmitSm, ReplaceSm and SubmitMulti.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_ENCODING_DEFAULT = "ISO-8859-1";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_HOST_CONF = "camel.component.smpp.httpProxyHost";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_HOST_DOC = "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the hostname or ip address of your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PASSWORD_CONF = "camel.component.smpp.httpProxyPassword";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PASSWORD_DOC = "If your HTTP proxy requires basic authentication, set this attribute to the password required for your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PORT_CONF = "camel.component.smpp.httpProxyPort";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PORT_DOC = "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the port of your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PORT_DEFAULT = "3128";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_USERNAME_CONF = "camel.component.smpp.httpProxyUsername";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_USERNAME_DOC = "If your HTTP proxy requires basic authentication, set this attribute to the username required for your HTTP proxy.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_USERNAME_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_PROXY_HEADERS_CONF = "camel.component.smpp.proxyHeaders";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PROXY_HEADERS_DOC = "These headers will be passed to the proxy server while establishing the connection.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PROXY_HEADERS_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_PASSWORD_CONF = "camel.component.smpp.password";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PASSWORD_DOC = "The password for connecting to SMSC server.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SMPP_COMPONENT_SYSTEM_ID_CONF = "camel.component.smpp.systemId";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SYSTEM_ID_DOC = "The system id (username) for connecting to SMSC server.";
    public static final String CAMEL_SINK_SMPP_COMPONENT_SYSTEM_ID_DEFAULT = "smppclient";
    public static final String CAMEL_SINK_SMPP_COMPONENT_USING_SSLCONF = "camel.component.smpp.usingSSL";
    public static final String CAMEL_SINK_SMPP_COMPONENT_USING_SSLDOC = "Whether using SSL with the smpps protocol";
    public static final Boolean CAMEL_SINK_SMPP_COMPONENT_USING_SSLDEFAULT = false;

    public CamelSmppSinkConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelSmppSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(CamelSmppSinkConnectorConfig.conf(), parsedConfig);
    }

    public static ConfigDef conf(Map<String, String> parsedConfig) {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_SMPP_PATH_HOST_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_PATH_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SMPP_PATH_HOST_DOC);
        conf.define(CAMEL_SINK_SMPP_PATH_PORT_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_PATH_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SMPP_PATH_PORT_DOC);
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_INITIAL_RECONNECT_DELAY_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SINK_SMPP_ENDPOINT_INITIAL_RECONNECT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the initial delay in milliseconds after the consumer/producer tries to reconnect to the SMSC, after the connection was lost.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_MAX_RECONNECT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_SMPP_ENDPOINT_MAX_RECONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the maximum number of attempts to reconnect to the SMSC, if SMSC returns a negative bind response");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_RECONNECT_DELAY_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SINK_SMPP_ENDPOINT_RECONNECT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the interval in milliseconds between the reconnect attempts, if the connection to the SMSC was lost and the previous was not succeed.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SPLITTING_POLICY_CONF, ConfigDef.Type.STRING, (Object)"ALLOW", ConfigDef.Importance.MEDIUM, "You can specify a policy for handling long messages: ALLOW - the default, long messages are split to 140 bytes per message TRUNCATE - long messages are split and only the first fragment will be sent to the SMSC. Some carriers drop subsequent fragments so this reduces load on the SMPP connection sending parts of a message that will never be delivered. REJECT - if a message would need to be split, it is rejected with an SMPP NegativeResponseException and the reason code signifying the message is too long. One of: [ALLOW] [REJECT] [TRUNCATE]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_TYPE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, "This parameter is used to categorize the type of ESME (External Short Message Entity) that is binding to the SMSC (max. 13 characters).");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_CONF, ConfigDef.Type.STRING, (Object)"1717", ConfigDef.Importance.MEDIUM, "Defines the destination SME address. For mobile terminated messages, this is the directory number of the recipient MS. Only for SubmitSm, SubmitMulti, CancelSm and DataSm.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_NPI_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_NPI_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_TON_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_DEST_ADDR_TON_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_LAZY_SESSION_CREATION_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_ENDPOINT_LAZY_SESSION_CREATION_DEFAULT, ConfigDef.Importance.MEDIUM, "Sessions can be lazily created to avoid exceptions, if the SMSC is not available when the Camel producer is started. Camel will check the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of the first exchange. If they are present, Camel will use these data to connect to the SMSC.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_NUMBERING_PLAN_INDICATOR_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_NUMBERING_PLAN_INDICATOR_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the numeric plan indicator (NPI) to be used in the SME. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_PRIORITY_FLAG_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_PRIORITY_FLAG_DEFAULT, ConfigDef.Importance.MEDIUM, "Allows the originating SME to assign a priority level to the short message. Only for SubmitSm and SubmitMulti. Four Priority Levels are supported: 0: Level 0 (lowest) priority 1: Level 1 priority 2: Level 2 priority 3: Level 3 (highest) priority One of: [0] [1] [2] [3]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_PROTOCOL_ID_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_PROTOCOL_ID_DEFAULT, ConfigDef.Importance.MEDIUM, "The protocol id");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_REGISTERED_DELIVERY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_REGISTERED_DELIVERY_DEFAULT, ConfigDef.Importance.MEDIUM, "Is used to request an SMSC delivery receipt and/or SME originated acknowledgements. The following values are defined: 0: No SMSC delivery receipt requested. 1: SMSC delivery receipt requested where final delivery outcome is success or failure. 2: SMSC delivery receipt requested where the final delivery outcome is delivery failure. One of: [0] [1] [2]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_REPLACE_IF_PRESENT_FLAG_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_REPLACE_IF_PRESENT_FLAG_DEFAULT, ConfigDef.Importance.MEDIUM, "Used to request the SMSC to replace a previously submitted message, that is still pending delivery. The SMSC will replace an existing message provided that the source address, destination address and service type match the same fields in the new message. The following replace if present flag values are defined: 0: Don't replace 1: Replace One of: [0] [1]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SERVICE_TYPE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_SERVICE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, "The service type parameter can be used to indicate the SMS Application service associated with the message. The following generic service_types are defined: CMT: Cellular Messaging CPT: Cellular Paging VMN: Voice Mail Notification VMA: Voice Mail Alerting WAP: Wireless Application Protocol USSD: Unstructured Supplementary Services Data One of: [CMT] [CPT] [VMN] [VMA] [WAP] [USSD]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_CONF, ConfigDef.Type.STRING, (Object)"1616", ConfigDef.Importance.MEDIUM, "Defines the address of SME (Short Message Entity) which originated this message.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_NPI_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_NPI_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the numeric plan indicator (NPI) to be used in the SME originator address parameters. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_TON_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_SOURCE_ADDR_TON_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME originator address parameters. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_TYPE_OF_NUMBER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_TYPE_OF_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SMPP_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_ENQUIRE_LINK_TIMER_CONF, ConfigDef.Type.STRING, (Object)"5000", ConfigDef.Importance.MEDIUM, "Defines the interval in milliseconds between the confidence checks. The confidence check is used to test the communication path between an ESME and an SMSC.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SESSION_STATE_LISTENER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_SESSION_STATE_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, "You can refer to a org.jsmpp.session.SessionStateListener in the Registry to receive callbacks when the session state changed.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SMPP_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_TRANSACTION_TIMER_CONF, ConfigDef.Type.STRING, (Object)"10000", ConfigDef.Importance.MEDIUM, "Defines the maximum period of inactivity allowed after a transaction, after which an SMPP entity may assume that the session is no longer active. This timer may be active on either communicating SMPP entity (i.e. SMSC or ESME).");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_ALPHABET_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_ALPHABET_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines encoding of data according the SMPP 3.4 specification, section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2 Alphabet One of: [0] [4] [8]");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_DATA_CODING_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_DATA_CODING_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the data coding according the SMPP 3.4 specification, section 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2 (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990)");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_ENCODING_CONF, ConfigDef.Type.STRING, (Object)"ISO-8859-1", ConfigDef.Importance.MEDIUM, "Defines the encoding scheme of the short message user data. Only for SubmitSm, ReplaceSm and SubmitMulti.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_HOST_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the hostname or ip address of your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PASSWORD_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "If your HTTP proxy requires basic authentication, set this attribute to the password required for your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_PORT_CONF, ConfigDef.Type.STRING, (Object)"3128", ConfigDef.Importance.MEDIUM, "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the port of your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_USERNAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_HTTP_PROXY_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, "If your HTTP proxy requires basic authentication, set this attribute to the username required for your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_PROXY_HEADERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_PROXY_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, "These headers will be passed to the proxy server while establishing the connection.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The password for connecting to SMSC server.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_SYSTEM_ID_CONF, ConfigDef.Type.STRING, (Object)"smppclient", ConfigDef.Importance.MEDIUM, "The system id (username) for connecting to SMSC server.");
        conf.define(CAMEL_SINK_SMPP_ENDPOINT_USING_SSLCONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_ENDPOINT_USING_SSLDEFAULT, ConfigDef.Importance.MEDIUM, "Whether using SSL with the smpps protocol");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_INITIAL_RECONNECT_DELAY_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SINK_SMPP_COMPONENT_INITIAL_RECONNECT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the initial delay in milliseconds after the consumer/producer tries to reconnect to the SMSC, after the connection was lost.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_MAX_RECONNECT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_SMPP_COMPONENT_MAX_RECONNECT_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the maximum number of attempts to reconnect to the SMSC, if SMSC returns a negative bind response");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_RECONNECT_DELAY_CONF, ConfigDef.Type.LONG, (Object)CAMEL_SINK_SMPP_COMPONENT_RECONNECT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the interval in milliseconds between the reconnect attempts, if the connection to the SMSC was lost and the previous was not succeed.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SPLITTING_POLICY_CONF, ConfigDef.Type.STRING, (Object)"ALLOW", ConfigDef.Importance.MEDIUM, "You can specify a policy for handling long messages: ALLOW - the default, long messages are split to 140 bytes per message TRUNCATE - long messages are split and only the first fragment will be sent to the SMSC. Some carriers drop subsequent fragments so this reduces load on the SMPP connection sending parts of a message that will never be delivered. REJECT - if a message would need to be split, it is rejected with an SMPP NegativeResponseException and the reason code signifying the message is too long. One of: [ALLOW] [REJECT] [TRUNCATE]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SYSTEM_TYPE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_SYSTEM_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, "This parameter is used to categorize the type of ESME (External Short Message Entity) that is binding to the SMSC (max. 13 characters).");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_CONF, ConfigDef.Type.STRING, (Object)"1717", ConfigDef.Importance.MEDIUM, "Defines the destination SME address. For mobile terminated messages, this is the directory number of the recipient MS. Only for SubmitSm, SubmitMulti, CancelSm and DataSm.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_NPI_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_NPI_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_TON_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_DEST_ADDR_TON_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME destination address parameters. Only for SubmitSm, SubmitMulti, CancelSm and DataSm. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_LAZY_SESSION_CREATION_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_COMPONENT_LAZY_SESSION_CREATION_DEFAULT, ConfigDef.Importance.MEDIUM, "Sessions can be lazily created to avoid exceptions, if the SMSC is not available when the Camel producer is started. Camel will check the in message headers 'CamelSmppSystemId' and 'CamelSmppPassword' of the first exchange. If they are present, Camel will use these data to connect to the SMSC.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_NUMBERING_PLAN_INDICATOR_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_NUMBERING_PLAN_INDICATOR_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the numeric plan indicator (NPI) to be used in the SME. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_PRIORITY_FLAG_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_PRIORITY_FLAG_DEFAULT, ConfigDef.Importance.MEDIUM, "Allows the originating SME to assign a priority level to the short message. Only for SubmitSm and SubmitMulti. Four Priority Levels are supported: 0: Level 0 (lowest) priority 1: Level 1 priority 2: Level 2 priority 3: Level 3 (highest) priority One of: [0] [1] [2] [3]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_PROTOCOL_ID_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_PROTOCOL_ID_DEFAULT, ConfigDef.Importance.MEDIUM, "The protocol id");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_REGISTERED_DELIVERY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_REGISTERED_DELIVERY_DEFAULT, ConfigDef.Importance.MEDIUM, "Is used to request an SMSC delivery receipt and/or SME originated acknowledgements. The following values are defined: 0: No SMSC delivery receipt requested. 1: SMSC delivery receipt requested where final delivery outcome is success or failure. 2: SMSC delivery receipt requested where the final delivery outcome is delivery failure. One of: [0] [1] [2]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_REPLACE_IF_PRESENT_FLAG_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_REPLACE_IF_PRESENT_FLAG_DEFAULT, ConfigDef.Importance.MEDIUM, "Used to request the SMSC to replace a previously submitted message, that is still pending delivery. The SMSC will replace an existing message provided that the source address, destination address and service type match the same fields in the new message. The following replace if present flag values are defined: 0: Don't replace 1: Replace One of: [0] [1]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SERVICE_TYPE_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_SERVICE_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, "The service type parameter can be used to indicate the SMS Application service associated with the message. The following generic service_types are defined: CMT: Cellular Messaging CPT: Cellular Paging VMN: Voice Mail Notification VMA: Voice Mail Alerting WAP: Wireless Application Protocol USSD: Unstructured Supplementary Services Data One of: [CMT] [CPT] [VMN] [VMA] [WAP] [USSD]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_CONF, ConfigDef.Type.STRING, (Object)"1616", ConfigDef.Importance.MEDIUM, "Defines the address of SME (Short Message Entity) which originated this message.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_NPI_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_NPI_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the numeric plan indicator (NPI) to be used in the SME originator address parameters. The following NPI values are defined: 0: Unknown 1: ISDN (E163/E164) 2: Data (X.121) 3: Telex (F.69) 6: Land Mobile (E.212) 8: National 9: Private 10: ERMES 13: Internet (IP) 18: WAP Client Id (to be defined by WAP Forum) One of: [0] [1] [2] [3] [6] [8] [9] [10] [13] [18]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_TON_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_SOURCE_ADDR_TON_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME originator address parameters. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_TYPE_OF_NUMBER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_TYPE_OF_NUMBER_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the type of number (TON) to be used in the SME. The following TON values are defined: 0: Unknown 1: International 2: National 3: Network Specific 4: Subscriber Number 5: Alphanumeric 6: Abbreviated One of: [0] [1] [2] [3] [4] [5] [6]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SMPP_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_SMPP_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SMPP_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_SMPP_COMPONENT_ENQUIRE_LINK_TIMER_CONF, ConfigDef.Type.STRING, (Object)"5000", ConfigDef.Importance.MEDIUM, "Defines the interval in milliseconds between the confidence checks. The confidence check is used to test the communication path between an ESME and an SMSC.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SESSION_STATE_LISTENER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_SESSION_STATE_LISTENER_DEFAULT, ConfigDef.Importance.MEDIUM, "You can refer to a org.jsmpp.session.SessionStateListener in the Registry to receive callbacks when the session state changed.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_TRANSACTION_TIMER_CONF, ConfigDef.Type.STRING, (Object)"10000", ConfigDef.Importance.MEDIUM, "Defines the maximum period of inactivity allowed after a transaction, after which an SMPP entity may assume that the session is no longer active. This timer may be active on either communicating SMPP entity (i.e. SMSC or ESME).");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_ALPHABET_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_ALPHABET_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines encoding of data according the SMPP 3.4 specification, section 5.2.19. 0: SMSC Default Alphabet 4: 8 bit Alphabet 8: UCS2 Alphabet One of: [0] [4] [8]");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_DATA_CODING_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_DATA_CODING_DEFAULT, ConfigDef.Importance.MEDIUM, "Defines the data coding according the SMPP 3.4 specification, section 5.2.19. Example data encodings are: 0: SMSC Default Alphabet 3: Latin 1 (ISO-8859-1) 4: Octet unspecified (8-bit binary) 8: UCS2 (ISO/IEC-10646) 13: Extended Kanji JIS(X 0212-1990)");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_ENCODING_CONF, ConfigDef.Type.STRING, (Object)"ISO-8859-1", ConfigDef.Importance.MEDIUM, "Defines the encoding scheme of the short message user data. Only for SubmitSm, ReplaceSm and SubmitMulti.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_HOST_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the hostname or ip address of your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PASSWORD_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "If your HTTP proxy requires basic authentication, set this attribute to the password required for your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_PORT_CONF, ConfigDef.Type.STRING, (Object)"3128", ConfigDef.Importance.MEDIUM, "If you need to tunnel SMPP through a HTTP proxy, set this attribute to the port of your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_USERNAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_HTTP_PROXY_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, "If your HTTP proxy requires basic authentication, set this attribute to the username required for your HTTP proxy.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_PROXY_HEADERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_PROXY_HEADERS_DEFAULT, ConfigDef.Importance.MEDIUM, "These headers will be passed to the proxy server while establishing the connection.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_PASSWORD_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_SMPP_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The password for connecting to SMSC server.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_SYSTEM_ID_CONF, ConfigDef.Type.STRING, (Object)"smppclient", ConfigDef.Importance.MEDIUM, "The system id (username) for connecting to SMSC server.");
        conf.define(CAMEL_SINK_SMPP_COMPONENT_USING_SSLCONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_SMPP_COMPONENT_USING_SSLDEFAULT, ConfigDef.Importance.MEDIUM, "Whether using SSL with the smpps protocol");
        return conf;
    }
}

