/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.BindResp;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySmResp;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SubmitMultiResp;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSmResp;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSession;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.BindCommandTask;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.CancelSmCommandTask;
import org.jsmpp.session.ClientSession;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.PDUProcessTask;
import org.jsmpp.session.QuerySmCommandTask;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.ReplaceSmCommandTask;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.SMPPSessionContext;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.SubmitMultiCommandTask;
import org.jsmpp.session.SubmitSmCommandTask;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.session.connection.socket.SocketConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPSession
extends AbstractSession
implements ClientSession {
    private static final Logger logger = LoggerFactory.getLogger(SMPPSession.class);
    private final PDUReader pduReader;
    private final ConnectionFactory connFactory;
    private Connection conn;
    private DataInputStream in;
    private OutputStream out;
    private PDUReaderWorker pduReaderWorker;
    private final ResponseHandler responseHandler = new ResponseHandlerImpl();
    private MessageReceiverListener messageReceiverListener;
    private BoundSessionStateListener sessionStateListener = new BoundSessionStateListener();
    private SMPPSessionContext sessionContext = new SMPPSessionContext(this, this.sessionStateListener);

    public SMPPSession() {
        this(new SynchronizedPDUSender(new DefaultPDUSender(new DefaultComposer())), new DefaultPDUReader(), SocketConnectionFactory.getInstance());
    }

    public SMPPSession(ConnectionFactory connFactory) {
        this(new SynchronizedPDUSender(new DefaultPDUSender(new DefaultComposer())), new DefaultPDUReader(), connFactory);
    }

    public SMPPSession(PDUSender pduSender, PDUReader pduReader, ConnectionFactory connFactory) {
        super(pduSender);
        this.pduReader = pduReader;
        this.connFactory = connFactory;
    }

    public SMPPSession(String host, int port, BindParameter bindParam, PDUSender pduSender, PDUReader pduReader, ConnectionFactory connFactory) throws IOException {
        this(pduSender, pduReader, connFactory);
        this.connectAndBind(host, port, bindParam);
    }

    public SMPPSession(String host, int port, BindParameter bindParam) throws IOException {
        this();
        this.connectAndBind(host, port, bindParam);
    }

    @Override
    public void connectAndBind(String host, int port, BindType bindType, String systemId, String password, String systemType, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange) throws IOException {
        this.connectAndBind(host, port, new BindParameter(bindType, systemId, password, systemType, addrTon, addrNpi, addressRange), 60000L);
    }

    @Override
    public void connectAndBind(String host, int port, BindType bindType, String systemId, String password, String systemType, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange, long timeout) throws IOException {
        this.connectAndBind(host, port, new BindParameter(bindType, systemId, password, systemType, addrTon, addrNpi, addressRange), timeout);
    }

    @Override
    public String connectAndBind(String host, int port, BindParameter bindParam) throws IOException {
        return this.connectAndBind(host, port, bindParam, 60000L);
    }

    @Override
    public String connectAndBind(String host, int port, BindParameter bindParam, long timeout) throws IOException {
        logger.debug("Connect and bind to {} port {}", (Object)host, (Object)port);
        if (this.getSessionState() != SessionState.CLOSED) {
            throw new IOException("Session state is not closed");
        }
        this.conn = this.connFactory.createConnection(host, port);
        logger.info("Connected to {}", (Object)this.conn.getInetAddress());
        this.conn.setSoTimeout(this.getEnquireLinkTimer());
        this.sessionContext.open();
        try {
            this.in = new DataInputStream(this.conn.getInputStream());
            this.out = this.conn.getOutputStream();
            this.pduReaderWorker = new PDUReaderWorker();
            this.pduReaderWorker.start();
            String smscSystemId = this.sendBind(bindParam.getBindType(), bindParam.getSystemId(), bindParam.getPassword(), bindParam.getSystemType(), bindParam.getInterfaceVersion(), bindParam.getAddrTon(), bindParam.getAddrNpi(), bindParam.getAddressRange(), timeout);
            this.sessionContext.bound(bindParam.getBindType());
            this.enquireLinkSender = new AbstractSession.EnquireLinkSender();
            this.enquireLinkSender.start();
            return smscSystemId;
        }
        catch (PDUException e) {
            logger.error("Failed sending bind command", (Throwable)e);
            throw new IOException("Failed sending bind since some string parameter area invalid: " + e.getMessage(), e);
        }
        catch (NegativeResponseException e) {
            String message = "Receive negative bind response";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (InvalidResponseException e) {
            String message = "Receive invalid response of bind";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (ResponseTimeoutException e) {
            String message = "Wait for bind response timed out";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            logger.error("IO error occurred", (Throwable)e);
            this.close();
            throw e;
        }
    }

    private String sendBind(BindType bindType, String systemId, String password, String systemType, InterfaceVersion interfaceVersion, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        BindCommandTask task = new BindCommandTask(this.pduSender(), bindType, systemId, password, systemType, interfaceVersion, addrTon, addrNpi, addressRange);
        BindResp resp = (BindResp)this.executeSendCommand(task, timeout);
        OptionalParameter.Sc_interface_version scVersion = resp.getOptionalParameter(OptionalParameter.Sc_interface_version.class);
        if (scVersion != null) {
            logger.info("Other side reports SMPP interface version {}", (Object)scVersion);
        }
        return resp.getSystemId();
    }

    @Override
    public String submitShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureTransmittable("submitShortMessage");
        SubmitSmCommandTask submitSmTask = new SubmitSmCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery, replaceIfPresentFlag, dataCoding, smDefaultMsgId, shortMessage, optionalParameters);
        SubmitSmResp resp = (SubmitSmResp)this.executeSendCommand(submitSmTask, this.getTransactionTimer());
        return resp.getMessageId();
    }

    @Override
    public SubmitMultiResult submitMultiple(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, Address[] destinationAddresses, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, ReplaceIfPresentFlag replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureTransmittable("submitMultiple");
        SubmitMultiCommandTask task = new SubmitMultiCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destinationAddresses, esmClass, protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery, replaceIfPresentFlag, dataCoding, smDefaultMsgId, shortMessage, optionalParameters);
        SubmitMultiResp resp = (SubmitMultiResp)this.executeSendCommand(task, this.getTransactionTimer());
        return new SubmitMultiResult(resp.getMessageId(), resp.getUnsuccessSmes());
    }

    @Override
    public QuerySmResult queryShortMessage(String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureTransmittable("queryShortMessage");
        QuerySmCommandTask task = new QuerySmCommandTask(this.pduSender(), messageId, sourceAddrTon, sourceAddrNpi, sourceAddr);
        QuerySmResp resp = (QuerySmResp)this.executeSendCommand(task, this.getTransactionTimer());
        if (resp.getMessageId().equals(messageId)) {
            return new QuerySmResult(resp.getFinalDate(), resp.getMessageState(), resp.getErrorCode());
        }
        throw new InvalidResponseException("Requested message_id doesn't match with the result");
    }

    @Override
    public void replaceShortMessage(String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte smDefaultMsgId, byte[] shortMessage) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureTransmittable("replaceShortMessage");
        ReplaceSmCommandTask replaceSmTask = new ReplaceSmCommandTask(this.pduSender(), messageId, sourceAddrTon, sourceAddrNpi, sourceAddr, scheduleDeliveryTime, validityPeriod, registeredDelivery, smDefaultMsgId, shortMessage);
        this.executeSendCommand(replaceSmTask, this.getTransactionTimer());
    }

    @Override
    public void cancelShortMessage(String serviceType, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddress) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureTransmittable("cancelShortMessage");
        CancelSmCommandTask task = new CancelSmCommandTask(this.pduSender(), serviceType, messageId, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddress);
        this.executeSendCommand(task, this.getTransactionTimer());
    }

    @Override
    public MessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    @Override
    public void setMessageReceiverListener(MessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    @Override
    protected Connection connection() {
        return this.conn;
    }

    @Override
    protected AbstractSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected GenericMessageReceiverListener messageReceiverListener() {
        return this.messageReceiverListener;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void fireAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        if (this.messageReceiverListener == null) {
            logger.warn("Receive deliver_sm but MessageReceiverListener is null. Short message = {}", (Object)new String(deliverSm.getShortMessage()));
            throw new ProcessRequestException("No message receiver listener registered", 100);
        }
        this.messageReceiverListener.onAcceptDeliverSm(deliverSm);
    }

    private void fireAcceptAlertNotification(AlertNotification alertNotification) {
        if (this.messageReceiverListener != null) {
            this.messageReceiverListener.onAcceptAlertNotification(alertNotification);
        } else {
            logger.warn("Receive alert_notification but MessageReceiverListener is null");
        }
    }

    private class BoundSessionStateListener
    implements SessionStateListener {
        private BoundSessionStateListener() {
        }

        @Override
        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            if (newState.isBound()) {
                try {
                    SMPPSession.this.conn.setSoTimeout(SMPPSession.this.getEnquireLinkTimer());
                }
                catch (IOException e) {
                    logger.error("Failed setting so_timeout for session timer", (Throwable)e);
                }
                logger.info("Changing processor degree to {}", (Object)SMPPSession.this.getPduProcessorDegree());
                ((ThreadPoolExecutor)SMPPSession.this.pduReaderWorker.executorService).setMaximumPoolSize(SMPPSession.this.getPduProcessorDegree());
                ((ThreadPoolExecutor)SMPPSession.this.pduReaderWorker.executorService).setCorePoolSize(SMPPSession.this.getPduProcessorDegree());
            }
        }
    }

    private class PDUReaderWorker
    extends Thread {
        private ExecutorService executorService;
        private Runnable onIOExceptionTask;

        private PDUReaderWorker() {
            super("PDUReaderWorker: " + SMPPSession.this);
            this.executorService = Executors.newFixedThreadPool(1);
            this.onIOExceptionTask = new Runnable(){

                @Override
                public void run() {
                    SMPPSession.this.close();
                }
            };
        }

        @Override
        public void run() {
            logger.info("Starting PDUReaderWorker");
            while (SMPPSession.this.isReadPdu()) {
                this.readPDU();
            }
            SMPPSession.this.close();
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(SMPPSession.this.getTransactionTimer(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("interrupted while waiting for executor service pool to finish");
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted");
            }
            logger.info("PDUReaderWorker stop");
        }

        private void readPDU() {
            try {
                Command pduHeader = SMPPSession.this.pduReader.readPDUHeader(SMPPSession.this.in);
                byte[] pdu = SMPPSession.this.pduReader.readPDU(SMPPSession.this.in, pduHeader);
                PDUProcessTask task = new PDUProcessTask(pduHeader, pdu, SMPPSession.this.sessionContext, SMPPSession.this.responseHandler, SMPPSession.this.sessionContext, this.onIOExceptionTask);
                this.executorService.execute(task);
            }
            catch (InvalidCommandLengthException e) {
                logger.warn("Received invalid command length: {}", (Object)e.getMessage());
                try {
                    SMPPSession.this.pduSender().sendGenericNack(SMPPSession.this.out, 2, 0);
                }
                catch (IOException ee) {
                    logger.warn("Failed sending generic nack", (Throwable)ee);
                }
                SMPPSession.this.unbindAndClose();
            }
            catch (SocketTimeoutException e) {
                this.notifyNoActivity();
            }
            catch (IOException e) {
                logger.info("Reading PDU session {} in state {}: {}", new Object[]{SMPPSession.this.getSessionId(), SMPPSession.this.getSessionState(), e.getMessage()});
                SMPPSession.this.close();
            }
            catch (RuntimeException e) {
                logger.warn("Runtime error while reading PDU", (Throwable)e);
                SMPPSession.this.close();
            }
        }

        private void notifyNoActivity() {
            logger.debug("No activity notified, sending enquireLink");
            if (SMPPSession.this.sessionContext().getSessionState().isBound()) {
                SMPPSession.this.enquireLinkSender.enquireLink();
            }
        }
    }

    private class ResponseHandlerImpl
    implements ResponseHandler {
        private ResponseHandlerImpl() {
        }

        @Override
        public void processDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
            try {
                SMPPSession.this.fireAcceptDeliverSm(deliverSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing deliver_sm";
                logger.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 100);
            }
        }

        @Override
        public DataSmResult processDataSm(DataSm dataSm) throws ProcessRequestException {
            try {
                return SMPPSession.this.fireAcceptDataSm(dataSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing data_sm";
                logger.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 100);
            }
        }

        @Override
        public void processAlertNotification(AlertNotification alertNotification) {
            try {
                SMPPSession.this.fireAcceptAlertNotification(alertNotification);
            }
            catch (Exception e) {
                logger.error("Invalid runtime exception thrown when processing alert_sm", (Throwable)e);
            }
        }

        @Override
        public void sendDataSmResp(DataSmResult dataSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPSession.this.pduSender().sendDataSmResp(SMPPSession.this.out, sequenceNumber, dataSmResult.getMessageId(), dataSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                logger.error("SYSTEM ERROR. Failed sending dataSmResp", (Throwable)e);
            }
        }

        @Override
        public PendingResponse<Command> removeSentItem(int sequenceNumber) {
            return SMPPSession.this.removePendingResponse(sequenceNumber);
        }

        @Override
        public void notifyUnbonded() {
            SMPPSession.this.sessionContext.unbound();
        }

        @Override
        public void sendDeliverSmResp(int commandStatus, int sequenceNumber, String messageId) throws IOException {
            SMPPSession.this.pduSender().sendDeliverSmResp(SMPPSession.this.out, commandStatus, sequenceNumber, messageId);
            logger.debug("deliver_sm_resp with sequence_number {} has been sent", (Object)sequenceNumber);
        }

        @Override
        public void sendEnquireLinkResp(int sequenceNumber) throws IOException {
            logger.debug("Sending enquire_link_resp");
            SMPPSession.this.pduSender().sendEnquireLinkResp(SMPPSession.this.out, sequenceNumber);
        }

        @Override
        public void sendGenerickNack(int commandStatus, int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendGenericNack(SMPPSession.this.out, commandStatus, sequenceNumber);
        }

        @Override
        public void sendNegativeResponse(int originalCommandId, int commandStatus, int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendHeader(SMPPSession.this.out, originalCommandId | Integer.MIN_VALUE, commandStatus, sequenceNumber);
        }

        @Override
        public void sendUnbindResp(int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendUnbindResp(SMPPSession.this.out, 0, sequenceNumber);
        }
    }
}

