/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.SlackFilesUploadV2Exception;
import com.slack.api.methods.request.files.FilesCompleteUploadExternalRequest;
import com.slack.api.methods.request.files.FilesGetUploadURLExternalRequest;
import com.slack.api.methods.request.files.FilesUploadV2Request;
import com.slack.api.methods.response.files.FilesCompleteUploadExternalResponse;
import com.slack.api.methods.response.files.FilesGetUploadURLExternalResponse;
import com.slack.api.methods.response.files.FilesUploadV2Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesUploadV2Helper
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilesUploadV2Helper.class);
    private final MethodsClient client;
    private final OkHttpClient okHttpClient;
    private final SlackFilesUploadV2Exception underlyingException = new SlackFilesUploadV2Exception();

    public FilesUploadV2Helper(MethodsClient client) {
        this.client = client;
        this.okHttpClient = client.getSlackHttpClient().getOkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(FilesUploadV2Request v2Request, FilesUploadV2Request.UploadFile uploadFile) throws IOException, SlackApiException, SlackFilesUploadV2Exception {
        byte[] fileContentBytes = FilesUploadV2Helper.readUploadFileBytes(uploadFile);
        FilesGetUploadURLExternalRequest req = FilesUploadV2Helper.buildGetUploadURLExternalRequest(uploadFile, v2Request.getToken(), fileContentBytes);
        FilesGetUploadURLExternalResponse uploadUrl = this.client.filesGetUploadURLExternal(req);
        this.underlyingException.getGetURLResponses().add(uploadUrl);
        if (!uploadUrl.isOk()) {
            throw this.underlyingException;
        }
        log.debug("Uploading a file (file_id: {}, size: {}, url: {})", new Object[]{uploadUrl.getFileId(), fileContentBytes.length, uploadUrl.getUploadUrl()});
        Response uploadResult = this.okHttpClient.newCall(new Request.Builder().url(uploadUrl.getUploadUrl()).post(RequestBody.create((byte[])fileContentBytes)).build()).execute();
        try {
            FilesUploadV2Response.UploadResponse uploadResponse = FilesUploadV2Response.UploadResponse.builder().code(uploadResult.code()).body(uploadResult.body().string()).build();
            log.debug("Upload request response: (file_id: {}, status code: {}, response body: {})", new Object[]{uploadUrl.getFileId(), uploadResponse.getCode(), uploadResponse.getBody()});
            this.underlyingException.getUploadResponses().put(uploadUrl.getFileId(), uploadResponse);
            if (uploadResponse.getCode() != 200) {
                throw this.underlyingException;
            }
            String string = uploadUrl.getFileId();
            return string;
        }
        finally {
            if (uploadResult != null) {
                try {
                    uploadResult.body().close();
                    uploadResult.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public FilesUploadV2Response completeUploads(FilesUploadV2Request v2Request, List<FilesCompleteUploadExternalRequest.FileDetails> files) throws SlackApiException, IOException, SlackFilesUploadV2Exception {
        FilesUploadV2Response result = new FilesUploadV2Response();
        FilesCompleteUploadExternalResponse response = this.client.filesCompleteUploadExternal(r -> r.token(v2Request.getToken()).files(files).channelId(v2Request.getChannel()).channels(v2Request.getChannels()).initialComment(v2Request.getInitialComment()).threadTs(v2Request.getThreadTs()));
        this.underlyingException.setCompleteResponse(response);
        if (!response.isOk()) {
            throw this.underlyingException;
        }
        result.setOk(true);
        result.setFiles(response.getFiles());
        if (response.getFiles().size() == 1) {
            result.setFile(result.getFiles().get(0));
        }
        result.getGetURLResponses().addAll(this.underlyingException.getGetURLResponses());
        result.getUploadResponses().putAll(this.underlyingException.getUploadResponses());
        result.getFileInfoResponses().addAll(this.underlyingException.getFileInfoResponses());
        result.setCompleteResponse(response);
        return result;
    }

    private static byte[] readUploadFileBytes(FilesUploadV2Request.UploadFile uploadFile) throws IOException {
        if (uploadFile.getFileData() != null) {
            return uploadFile.getFileData();
        }
        if (uploadFile.getFile() != null) {
            return Files.readAllBytes(uploadFile.getFile().toPath());
        }
        if (uploadFile.getContent() != null) {
            return uploadFile.getContent().getBytes(StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("No file content found!");
    }

    private static FilesGetUploadURLExternalRequest buildGetUploadURLExternalRequest(FilesUploadV2Request.UploadFile uploadFile, String tokenAsArg, byte[] fileContentBytes) {
        String filename;
        String string = filename = uploadFile.getFilename() == null ? "file" : uploadFile.getFilename();
        if (uploadFile.getContent() != null && uploadFile.getFilename() == null) {
            filename = "Text content";
        }
        return FilesGetUploadURLExternalRequest.builder().token(tokenAsArg).filename(filename).length(fileContentBytes.length).altTxt(uploadFile.getAltTxt()).snippetType(uploadFile.getSnippetType()).build();
    }

    @Override
    public void close() {
    }

    @Generated
    public MethodsClient getClient() {
        return this.client;
    }

    @Generated
    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    @Generated
    public SlackFilesUploadV2Exception getUnderlyingException() {
        return this.underlyingException;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesUploadV2Helper)) {
            return false;
        }
        FilesUploadV2Helper other = (FilesUploadV2Helper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodsClient this$client = this.getClient();
        MethodsClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        SlackFilesUploadV2Exception this$underlyingException = this.getUnderlyingException();
        SlackFilesUploadV2Exception other$underlyingException = other.getUnderlyingException();
        return !(this$underlyingException == null ? other$underlyingException != null : !((Object)this$underlyingException).equals(other$underlyingException));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilesUploadV2Helper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodsClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        SlackFilesUploadV2Exception $underlyingException = this.getUnderlyingException();
        result = result * 59 + ($underlyingException == null ? 43 : ((Object)$underlyingException).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FilesUploadV2Helper(client=" + this.getClient() + ", okHttpClient=" + this.getOkHttpClient() + ", underlyingException=" + this.getUnderlyingException() + ")";
    }
}

