/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.processor.SendDynamicAwareResolver;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDynamicProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SendDynamicProcessor.class);
    protected SendDynamicAware dynamicAware;
    protected volatile String scheme;
    protected CamelContext camelContext;
    protected final String uri;
    protected final Expression expression;
    protected ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected String id;
    protected String routeId;
    protected boolean ignoreInvalidEndpoint;
    protected int cacheSize;
    protected boolean allowOptimisedComponents = true;
    protected boolean autoStartupComponents = true;

    public SendDynamicProcessor(String uri, Expression expression) {
        this.uri = uri;
        this.expression = expression;
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ExchangePattern destinationExchangePattern;
        Endpoint endpoint;
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("SendProcessor has not been started: " + this));
            callback.done(true);
            return true;
        }
        final ExchangePattern existingPattern = exchange.getPattern();
        Object recipient = null;
        Processor preAwareProcessor = null;
        Processor postAwareProcessor = null;
        Object staticUri = null;
        boolean prototype = this.cacheSize < 0;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            if (this.dynamicAware != null) {
                SendDynamicAware.DynamicAwareEntry entry;
                String originalUri = this.uri;
                String uri = SendDynamicProcessor.resolveUri(exchange, recipient);
                String scheme = SendDynamicProcessor.resolveScheme(exchange, uri);
                if (this.dynamicAware.getScheme().equals(scheme) && (entry = this.dynamicAware.prepare(exchange, uri, originalUri)) != null) {
                    staticUri = this.dynamicAware.resolveStaticUri(exchange, entry);
                    preAwareProcessor = this.dynamicAware.createPreProcessor(exchange, entry);
                    postAwareProcessor = this.dynamicAware.createPostProcessor(exchange, entry);
                    if (staticUri != null && LOG.isDebugEnabled()) {
                        LOG.debug("Optimising toD via SendDynamicAware component: {} to use static uri: {}", (Object)scheme, (Object)URISupport.sanitizeUri((String)staticUri));
                    }
                }
            }
            Object targetRecipient = staticUri != null ? staticUri : recipient;
            if ((targetRecipient = SendDynamicProcessor.prepareRecipient(exchange, targetRecipient)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send dynamic evaluated as null so cannot send to any endpoint");
                }
                callback.done(true);
                return true;
            }
            Endpoint existing = SendDynamicProcessor.getExistingEndpoint(exchange, targetRecipient);
            if (existing == null) {
                endpoint = SendDynamicProcessor.resolveEndpoint(exchange, targetRecipient, prototype);
            } else {
                endpoint = existing;
                prototype = false;
            }
            destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl((String)endpoint.getEndpointUri());
        }
        catch (Throwable e2) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", e2);
                }
            } else {
                exchange.setException(e2);
            }
            callback.done(true);
            return true;
        }
        Processor preProcessor = preAwareProcessor;
        final Processor postProcessor = postAwareProcessor;
        ExchangePattern pattern = destinationExchangePattern != null ? destinationExchangePattern : this.pattern;
        final boolean stopEndpoint = prototype;
        return this.producerCache.doInAsyncProducer(endpoint, exchange, callback, (p, e, c) -> {
            final Exchange target = this.configureExchange(e, pattern, endpoint);
            try {
                if (preProcessor != null) {
                    preProcessor.process(target);
                }
            }
            catch (Throwable t) {
                e.setException(t);
                target.setPattern(existingPattern);
                c.done(true);
            }
            LOG.debug(">>>> {} {}", (Object)endpoint, (Object)e);
            return p.process(target, new AsyncCallback(){

                public void done(boolean doneSync) {
                    target.setPattern(existingPattern);
                    try {
                        if (postProcessor != null) {
                            postProcessor.process(target);
                        }
                    }
                    catch (Throwable e) {
                        target.setException(e);
                    }
                    if (stopEndpoint) {
                        ServiceHelper.stopAndShutdownService((Object)endpoint);
                    }
                    c.done(doneSync);
                }
            });
        });
    }

    protected static String resolveUri(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient == null) {
            return null;
        }
        String uri = recipient instanceof String ? ((String)recipient).trim() : (recipient instanceof Endpoint ? ((Endpoint)recipient).getEndpointKey() : (String)exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient));
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)exchange.getContext(), (String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        return uri;
    }

    protected static String resolveScheme(Exchange exchange, String uri) {
        return ExchangeHelper.resolveScheme((String)uri);
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        if (recipient != null) {
            ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
            String uri = recipient instanceof String ? (String)recipient : (String)ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            int colon = uri.indexOf(58);
            if (colon == -1 || colon == uri.length() - 1) {
                throw new ResolveEndpointFailedException(uri, "Endpoint should include scheme:path");
            }
            return ecc.normalizeUri(uri);
        }
        return null;
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof Endpoint) {
            return (Endpoint)recipient;
        }
        if (recipient != null) {
            if (recipient instanceof NormalizedEndpointUri) {
                NormalizedEndpointUri nu = (NormalizedEndpointUri)recipient;
                ExtendedCamelContext ecc = (ExtendedCamelContext)exchange.getContext();
                return ecc.hasEndpoint(nu);
            }
            String uri = recipient.toString();
            return exchange.getContext().hasEndpoint(uri);
        }
        return null;
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint((Exchange)exchange, (Object)recipient) : ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)recipient);
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern, Endpoint endpoint) {
        if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
        return exchange;
    }

    protected void doInit() throws Exception {
        block7: {
            this.expression.init(this.camelContext);
            if ((this.isAllowOptimisedComponents() || this.isAutoStartupComponents()) && this.uri != null) {
                String u = EndpointHelper.resolveEndpointUriPropertyPlaceholders((CamelContext)this.camelContext, (String)this.uri);
                this.scheme = ExchangeHelper.resolveScheme((String)u);
            }
            if (this.isAllowOptimisedComponents() && this.uri != null) {
                try {
                    if (this.scheme != null) {
                        String defaultScheme;
                        Component comp;
                        SendDynamicAwareResolver resolver = new SendDynamicAwareResolver();
                        this.dynamicAware = resolver.resolve(this.camelContext, this.scheme);
                        if (this.dynamicAware == null && (comp = this.camelContext.getComponent(this.scheme, false, this.isAutoStartupComponents())) != null && !this.scheme.equals(defaultScheme = comp.getDefaultName())) {
                            this.dynamicAware = resolver.resolve(this.camelContext, defaultScheme);
                            this.dynamicAware.setScheme(this.scheme);
                        }
                        if (this.dynamicAware != null && LOG.isDebugEnabled()) {
                            LOG.debug("Detected SendDynamicAware component: {} optimising toD: {}", (Object)this.scheme, (Object)URISupport.sanitizeUri((String)this.uri));
                        }
                    }
                }
                catch (Throwable e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("Error creating optimised SendDynamicAwareResolver for uri: " + URISupport.sanitizeUri((String)this.uri) + " due to " + e.getMessage() + ". This exception is ignored", e);
                }
            }
        }
        ServiceHelper.initService((Object)this.dynamicAware);
    }

    protected void doStart() throws Exception {
        if (this.autoStartupComponents && this.scheme != null) {
            this.camelContext.getComponent(this.scheme);
        }
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache((Object)this, this.camelContext);
                LOG.debug("DynamicSendTo {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("DynamicSendTo {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService((Object[])new Object[]{this.dynamicAware, this.producerCache});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.producerCache, this.dynamicAware});
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public SendDynamicAware getDynamicAware() {
        return this.dynamicAware;
    }

    public String getUri() {
        return this.uri;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(boolean allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }

    public boolean isAutoStartupComponents() {
        return this.autoStartupComponents;
    }

    public void setAutoStartupComponents(boolean autoStartupComponents) {
        this.autoStartupComponents = autoStartupComponents;
    }
}

