/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.dataformat.Any23Type;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="3.0.0", label="dataformat,transformation", title="Any23")
@XmlRootElement(name="any23")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Any23DataFormat
extends DataFormatDefinition {
    @XmlAttribute
    @Metadata(defaultValue="RDF4JMODEL", enums="NTRIPLES,TURTLE,NQUADS,RDFXML,JSONLD,RDFJSON,RDF4JMODEL", javaType="org.apache.camel.dataformat.any23.Any23OutputFormat")
    private String outputFormat;
    @XmlAttribute
    private String baseUri;
    @XmlElement(name="configuration")
    private List<PropertyDefinition> configuration;
    @XmlTransient
    private Map<String, String> configurations;
    @XmlElement
    private List<String> extractors;

    public Any23DataFormat() {
        super("any23");
    }

    public Any23DataFormat(String baseuri) {
        this();
        this.baseUri = baseuri;
    }

    public Any23DataFormat(String baseuri, Any23Type outputFormat) {
        this(baseuri);
        this.outputFormat = outputFormat.name();
    }

    public Any23DataFormat(String baseuri, Any23Type outputFormat, Map<String, String> configurations) {
        this(baseuri, outputFormat);
        this.outputFormat = outputFormat.name();
        this.configurations = configurations;
    }

    public Any23DataFormat(String baseuri, Any23Type outputFormat, Map<String, String> configurations, List<String> extractors) {
        this(baseuri, outputFormat, configurations);
        this.outputFormat = outputFormat.name();
        this.configurations = configurations;
        this.extractors = extractors;
    }

    private Any23DataFormat(Builder builder) {
        this(builder.baseUri);
        this.outputFormat = builder.outputFormat;
        this.configuration = builder.configuration;
        this.configurations = builder.configurations;
        this.extractors = builder.extractors;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public Map<String, String> getConfigurationAsMap() {
        if (this.configurations == null && this.configuration != null) {
            this.configurations = new HashMap<String, String>();
        }
        if (this.configuration != null) {
            for (PropertyDefinition def : this.configuration) {
                this.configurations.put(def.getKey(), def.getValue());
            }
        }
        return this.configurations;
    }

    public List<PropertyDefinition> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<PropertyDefinition> configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = new ArrayList<PropertyDefinition>();
        configuration.forEach((k, v) -> this.configuration.add(new PropertyDefinition((String)k, (String)v)));
    }

    public List<String> getExtractors() {
        return this.extractors;
    }

    public void setExtractors(List<String> extractors) {
        this.extractors = extractors;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<Any23DataFormat> {
        private String outputFormat;
        private String baseUri;
        private List<PropertyDefinition> configuration;
        private Map<String, String> configurations;
        private List<String> extractors;

        public Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public Builder configuration(List<PropertyDefinition> configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder configuration(Map<String, String> configurations) {
            this.configurations = configurations;
            return this;
        }

        public Builder baseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Builder extractors(List<String> extractors) {
            this.extractors = extractors;
            return this;
        }

        @Override
        public Any23DataFormat end() {
            return new Any23DataFormat(this);
        }
    }
}

