/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.debugger;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Message;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NamedRoute;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.impl.debugger.DefaultBacklogTracerEventMessage;
import org.apache.camel.impl.debugger.DefaultDebugger;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BacklogTracerEventMessage;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;
import org.apache.camel.support.BreakpointSupport;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultBacklogDebugger
extends ServiceSupport
implements BacklogDebugger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBacklogDebugger.class);
    private long fallbackTimeout = 300L;
    private final CamelContext camelContext;
    private LoggingLevel loggingLevel = LoggingLevel.INFO;
    private final CamelLogger logger = new CamelLogger(LOG, this.loggingLevel);
    private final AtomicBoolean enabled = new AtomicBoolean();
    private final AtomicBoolean standby = new AtomicBoolean();
    private final AtomicLong debugCounter = new AtomicLong();
    private final Debugger debugger;
    private final ConcurrentMap<String, NodeBreakpoint> breakpoints = new ConcurrentHashMap<String, NodeBreakpoint>();
    private final ConcurrentMap<String, SuspendedExchange> suspendedBreakpoints = new ConcurrentHashMap<String, SuspendedExchange>();
    private final ConcurrentMap<String, BacklogTracerEventMessage> suspendedBreakpointMessages = new ConcurrentHashMap<String, BacklogTracerEventMessage>();
    private final AtomicReference<CountDownLatch> suspend = new AtomicReference();
    private volatile String singleStepExchangeId;
    private boolean suspendMode;
    private String initialBreakpoints;
    private boolean singleStepIncludeStartEnd;
    private int bodyMaxChars = 131072;
    private boolean bodyIncludeStreams;
    private boolean bodyIncludeFiles = true;
    private boolean includeExchangeProperties = true;
    private boolean includeExchangeVariables = true;
    private boolean includeException = true;

    private DefaultBacklogDebugger(CamelContext camelContext, boolean suspendMode) {
        this.camelContext = camelContext;
        this.debugger = new DefaultDebugger(camelContext);
        this.suspendMode = suspendMode;
        this.detach();
    }

    public static BacklogDebugger createDebugger(CamelContext context) {
        context.setSourceLocationEnabled(Boolean.valueOf(true));
        context.setMessageHistory(Boolean.valueOf(true));
        DefaultBacklogDebugger answer = new DefaultBacklogDebugger(context, DefaultBacklogDebugger.resolveSuspendMode());
        answer.setStandby(context.isDebugStandby());
        return answer;
    }

    public static BacklogDebugger getBacklogDebugger(CamelContext context) {
        return (BacklogDebugger)context.hasService(DefaultBacklogDebugger.class);
    }

    public String getInitialBreakpoints() {
        return this.initialBreakpoints;
    }

    public void setInitialBreakpoints(String initialBreakpoints) {
        this.initialBreakpoints = initialBreakpoints;
    }

    public String getLoggingLevel() {
        return this.loggingLevel.name();
    }

    public void setLoggingLevel(String level) {
        this.loggingLevel = LoggingLevel.valueOf((String)level);
        this.logger.setLevel(this.loggingLevel);
    }

    public void enableDebugger() {
        this.logger.log("Enabling Camel debugger");
        try {
            ServiceHelper.startService((Service)this.debugger);
            this.enabled.set(true);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void disableDebugger() {
        this.logger.log("Disabling Camel debugger");
        try {
            this.enabled.set(false);
            ServiceHelper.stopService((Service)this.debugger);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clearBreakpoints();
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean isStandby() {
        return this.standby.get();
    }

    public void setStandby(boolean standby) {
        this.standby.set(standby);
    }

    public boolean hasBreakpoint(String nodeId) {
        return this.breakpoints.containsKey(nodeId);
    }

    public void setSuspendMode(boolean suspendMode) {
        this.suspendMode = suspendMode;
    }

    public boolean isSuspendMode() {
        return this.suspendMode;
    }

    public boolean isSingleStepMode() {
        return this.singleStepExchangeId != null;
    }

    public void attach() {
        if (this.suspendMode) {
            this.logger.log("A debugger has been attached");
            this.resumeMessageProcessing();
        }
    }

    public void detach() {
        if (this.suspendMode) {
            this.logger.log("Waiting for a debugger to attach");
            this.suspendMessageProcessing();
        }
    }

    private static boolean resolveSuspendMode() {
        String value = System.getenv("CAMEL_DEBUGGER_SUSPEND");
        return value == null ? Boolean.getBoolean("org.apache.camel.debugger.suspend") : Boolean.parseBoolean(value);
    }

    private void suspendIfNeeded() {
        CountDownLatch countDownLatch = this.suspend.get();
        if (countDownLatch != null) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void suspendMessageProcessing() {
        this.suspend.compareAndSet(null, new CountDownLatch(1));
    }

    private void resumeMessageProcessing() {
        CountDownLatch countDownLatch;
        while ((countDownLatch = this.suspend.get()) != null) {
            if (!this.suspend.compareAndSet(countDownLatch, null)) continue;
            countDownLatch.countDown();
        }
    }

    public void addBreakpoint(String nodeId) {
        NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)this.breakpoints.get(nodeId));
        if (breakpoint == null) {
            this.logger.log("Adding breakpoint " + nodeId);
            breakpoint = new NodeBreakpoint(nodeId, null);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint((Breakpoint)breakpoint, new Condition[]{breakpoint});
        } else {
            breakpoint.setCondition(null);
        }
    }

    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        Predicate condition = this.camelContext.resolveLanguage(language).createPredicate(predicate);
        NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)this.breakpoints.get(nodeId));
        if (breakpoint == null) {
            this.logger.log("Adding conditional breakpoint " + nodeId + " [" + predicate + "]");
            breakpoint = new NodeBreakpoint(nodeId, condition);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint((Breakpoint)breakpoint, new Condition[]{breakpoint});
        } else if (breakpoint.getCondition() == null) {
            this.logger.log("Updating to conditional breakpoint " + nodeId + " [" + predicate + "]");
            this.debugger.removeBreakpoint((Breakpoint)breakpoint);
            this.breakpoints.put(nodeId, breakpoint);
            this.debugger.addBreakpoint((Breakpoint)breakpoint, new Condition[]{breakpoint});
        } else {
            this.logger.log("Updating conditional breakpoint " + nodeId + " [" + predicate + "]");
            breakpoint.setCondition(condition);
        }
    }

    public void removeBreakpoint(String nodeId) {
        this.logger.log("Removing breakpoint " + nodeId);
        this.suspendedBreakpointMessages.remove(nodeId);
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)this.breakpoints.remove(nodeId));
        if (breakpoint != null) {
            this.debugger.removeBreakpoint((Breakpoint)breakpoint);
        }
        if (se != null) {
            se.getLatch().countDown();
        }
    }

    public void removeAllBreakpoints() {
        this.singleStepExchangeId = null;
        for (String nodeId : this.getSuspendedBreakpointNodeIds()) {
            this.removeBreakpoint(nodeId);
        }
    }

    public Set<String> getBreakpoints() {
        return new LinkedHashSet<String>(this.breakpoints.keySet());
    }

    public void resumeBreakpoint(String nodeId) {
        this.resumeBreakpoint(nodeId, false);
    }

    public void resumeBreakpoint(String nodeId, boolean stepMode) {
        this.logger.log("Resume breakpoint " + nodeId);
        if (!stepMode && this.singleStepExchangeId != null) {
            this.debugger.stopSingleStepExchange(this.singleStepExchangeId);
            this.singleStepExchangeId = null;
        }
        this.suspendedBreakpointMessages.remove(nodeId);
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(nodeId);
        if (se != null) {
            se.getLatch().countDown();
        }
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            boolean remove;
            boolean bl = remove = body == null;
            if (remove) {
                this.removeMessageBodyOnBreakpoint(nodeId);
            } else {
                Class<?> oldType = se.getExchange().getMessage().getBody() == null ? null : se.getExchange().getMessage().getBody().getClass();
                this.setMessageBodyOnBreakpoint(nodeId, body, oldType);
            }
        }
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body, Class<?> type) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            boolean remove;
            boolean bl = remove = body == null;
            if (remove) {
                this.removeMessageBodyOnBreakpoint(nodeId);
            } else {
                this.logger.log(String.format("Breakpoint at node %s is updating message body on exchangeId: %s with new body: %s", nodeId, se.getExchange().getExchangeId(), body));
                if (type == null) {
                    se.getExchange().getMessage().setBody(body);
                } else {
                    se.getExchange().getMessage().setBody(body, type);
                }
                this.refreshBacklogTracerEventMessage(nodeId, se);
            }
        }
    }

    public void removeMessageBodyOnBreakpoint(String nodeId) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log(String.format("Breakpoint at node %s is removing message body on exchangeId: %s", nodeId, se.getExchange().getExchangeId()));
            se.getExchange().getMessage().setBody(null);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(headerName) == null ? null : se.getExchange().getMessage().getHeader(headerName).getClass();
            this.setMessageHeaderOnBreakpoint(nodeId, headerName, value, oldType);
        }
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating message header on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + headerName + " and value: " + String.valueOf(value));
            if (type == null) {
                se.getExchange().getMessage().setHeader(headerName, value);
            } else {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().getMessage().setHeader(headerName, convertedValue);
            }
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(exchangePropertyName) == null ? null : se.getExchange().getMessage().getHeader(exchangePropertyName).getClass();
            this.setExchangePropertyOnBreakpoint(nodeId, exchangePropertyName, value, oldType);
        }
    }

    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating exchange property on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + exchangePropertyName + " and value: " + String.valueOf(value));
            if (type == null) {
                se.getExchange().setProperty(exchangePropertyName, value);
            } else {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().setProperty(exchangePropertyName, convertedValue);
            }
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public void removeExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing exchange property on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + exchangePropertyName);
            se.getExchange().removeProperty(exchangePropertyName);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public void setExchangeVariableOnBreakpoint(String nodeId, String variableName, Object value) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            Class<?> oldType = se.getExchange().getMessage().getHeader(variableName) == null ? null : se.getExchange().getMessage().getHeader(variableName).getClass();
            this.setExchangeVariableOnBreakpoint(nodeId, variableName, value, oldType);
        }
    }

    public void setExchangeVariableOnBreakpoint(String nodeId, String variableName, Object value, Class<?> type) throws NoTypeConversionAvailableException {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is updating exchange variable on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + variableName + " and value: " + String.valueOf(value));
            if (type == null) {
                se.getExchange().setVariable(variableName, value);
            } else {
                Object convertedValue = se.getExchange().getContext().getTypeConverter().mandatoryConvertTo(type, se.getExchange(), value);
                se.getExchange().setVariable(variableName, convertedValue);
            }
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public void removeExchangeVariableOnBreakpoint(String nodeId, String variableName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing variable on exchangeId: " + se.getExchange().getExchangeId() + " with key: " + variableName);
            se.getExchange().removeVariable(variableName);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public long getFallbackTimeout() {
        return this.fallbackTimeout;
    }

    public void setFallbackTimeout(long fallbackTimeout) {
        this.fallbackTimeout = fallbackTimeout;
    }

    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.get(nodeId);
        if (se != null) {
            this.logger.log("Breakpoint at node " + nodeId + " is removing message header on exchangeId: " + se.getExchange().getExchangeId() + " with header: " + headerName);
            se.getExchange().getMessage().removeHeader(headerName);
            this.refreshBacklogTracerEventMessage(nodeId, se);
        }
    }

    public void resumeAll() {
        this.logger.log("Resume all");
        this.singleStepExchangeId = null;
        for (String node : this.getSuspendedBreakpointNodeIds()) {
            this.suspendedBreakpointMessages.remove(node);
            SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(node);
            if (se == null) continue;
            se.getLatch().countDown();
        }
    }

    public void stepBreakpoint() {
        String nodeId;
        NodeBreakpoint breakpoint;
        if (this.isSingleStepMode()) {
            this.logger.log("Step breakpoint is already in single step mode, so stepping instead.");
            this.step();
        }
        if (this.suspendedBreakpointMessages.size() != 1) {
            return;
        }
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.values().iterator().next();
        if (msg != null && (breakpoint = (NodeBreakpoint)((Object)this.breakpoints.get(nodeId = msg.getToNode()))) != null) {
            this.singleStepExchangeId = msg.getExchangeId();
            if (this.debugger.startSingleStepExchange(this.singleStepExchangeId, (Breakpoint)new StepBreakpoint())) {
                this.resumeBreakpoint(nodeId, true);
            }
        }
    }

    public void stepBreakpoint(String nodeId) {
        if (this.isSingleStepMode()) {
            this.logger.log("Step breakpoint " + nodeId + " is already in single step mode, so stepping instead.");
            this.step();
        }
        this.logger.log("Step breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)this.breakpoints.get(nodeId));
        if (msg != null && breakpoint != null) {
            this.singleStepExchangeId = msg.getExchangeId();
            if (this.debugger.startSingleStepExchange(this.singleStepExchangeId, (Breakpoint)new StepBreakpoint())) {
                this.resumeBreakpoint(nodeId, true);
            }
        }
    }

    public void step() {
        for (String node : this.getSuspendedBreakpointNodeIds()) {
            this.suspendedBreakpointMessages.remove(node);
            SuspendedExchange se = (SuspendedExchange)this.suspendedBreakpoints.remove(node);
            if (se == null) continue;
            se.getLatch().countDown();
        }
    }

    public Set<String> getSuspendedBreakpointNodeIds() {
        return new LinkedHashSet<String>(this.suspendedBreakpoints.keySet());
    }

    public Exchange getSuspendedExchange(String id) {
        SuspendedExchange suspendedExchange = (SuspendedExchange)this.suspendedBreakpoints.get(id);
        return suspendedExchange == null ? null : suspendedExchange.getExchange();
    }

    public BacklogTracerEventMessage getSuspendedBreakpointMessage(String id) {
        return (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(id);
    }

    public void disableBreakpoint(String nodeId) {
        this.logger.log("Disable breakpoint " + nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)this.breakpoints.get(nodeId));
        if (breakpoint != null) {
            breakpoint.suspend();
        }
    }

    public void enableBreakpoint(String nodeId) {
        this.logger.log("Enable breakpoint " + nodeId);
        NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)this.breakpoints.get(nodeId));
        if (breakpoint != null) {
            breakpoint.activate();
        }
    }

    public boolean isSingleStepIncludeStartEnd() {
        return this.singleStepIncludeStartEnd;
    }

    public void setSingleStepIncludeStartEnd(boolean singleStepIncludeStartEnd) {
        this.singleStepIncludeStartEnd = singleStepIncludeStartEnd;
    }

    public int getBodyMaxChars() {
        return this.bodyMaxChars;
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.bodyMaxChars = bodyMaxChars;
    }

    public boolean isBodyIncludeStreams() {
        return this.bodyIncludeStreams;
    }

    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.bodyIncludeStreams = bodyIncludeStreams;
    }

    public boolean isBodyIncludeFiles() {
        return this.bodyIncludeFiles;
    }

    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.bodyIncludeFiles = bodyIncludeFiles;
    }

    public boolean isIncludeExchangeProperties() {
        return this.includeExchangeProperties;
    }

    public void setIncludeExchangeProperties(boolean includeExchangeProperties) {
        this.includeExchangeProperties = includeExchangeProperties;
    }

    public boolean isIncludeExchangeVariables() {
        return this.includeExchangeVariables;
    }

    public void setIncludeExchangeVariables(boolean includeExchangeVariables) {
        this.includeExchangeVariables = includeExchangeVariables;
    }

    public boolean isIncludeException() {
        return this.includeException;
    }

    public void setIncludeException(boolean includeException) {
        this.includeException = includeException;
    }

    public String dumpTracedMessagesAsXml(String nodeId) {
        this.logger.log("Dump trace message from breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        if (msg == null) {
            return null;
        }
        return msg.toXml(0);
    }

    public String dumpTracedMessagesAsJSon(String nodeId) {
        this.logger.log("Dump trace message from breakpoint " + nodeId);
        BacklogTracerEventMessage msg = (BacklogTracerEventMessage)this.suspendedBreakpointMessages.get(nodeId);
        if (msg == null) {
            return null;
        }
        return msg.toJSon(0);
    }

    public long getDebugCounter() {
        return this.debugCounter.get();
    }

    public void resetDebugCounter() {
        this.logger.log("Reset debug counter");
        this.debugCounter.set(0L);
    }

    public StopWatch beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
        this.suspendIfNeeded();
        if (this.isEnabled() && (this.hasBreakpoint(definition.getId()) || this.isSingleStepMode())) {
            StopWatch watch = new StopWatch();
            this.debugger.beforeProcess(exchange, processor, definition);
            return watch;
        }
        return null;
    }

    public void afterProcess(Exchange exchange, Processor processor, NamedNode definition, long timeTaken) {
        this.debugger.afterProcess(exchange, processor, definition, timeTaken);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.initialBreakpoints != null) {
            for (String b : this.initialBreakpoints.split(",")) {
                if ("_all_routes_".equals(b = b.trim())) continue;
                this.addBreakpoint(b);
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.enabled.get()) {
            this.disableDebugger();
        }
        this.clearBreakpoints();
    }

    private void clearBreakpoints() {
        this.breakpoints.clear();
        for (SuspendedExchange se : this.suspendedBreakpoints.values()) {
            se.getLatch().countDown();
        }
        this.suspendedBreakpoints.clear();
        this.suspendedBreakpointMessages.clear();
    }

    private void refreshBacklogTracerEventMessage(String nodeId, SuspendedExchange suspendedExchange) {
        this.suspendedBreakpointMessages.computeIfPresent(nodeId, (nId, message) -> new DefaultBacklogTracerEventMessage(false, false, message.getUid(), message.getTimestamp(), message.getLocation(), message.getRouteId(), message.getToNode(), message.getExchangeId(), false, false, this.dumpAsXml(suspendedExchange.getExchange()), this.dumpAsJSon(suspendedExchange.getExchange())));
    }

    private String dumpAsXml(Exchange exchange) {
        return MessageHelper.dumpAsXml((Message)exchange.getIn(), (boolean)this.includeExchangeProperties, (boolean)this.includeExchangeVariables, (boolean)true, (int)2, (boolean)true, (boolean)this.isBodyIncludeStreams(), (boolean)this.isBodyIncludeFiles(), (int)this.getBodyMaxChars());
    }

    private String dumpAsJSon(Exchange exchange) {
        return MessageHelper.dumpAsJSon((Message)exchange.getIn(), (boolean)this.includeExchangeProperties, (boolean)this.includeExchangeVariables, (boolean)true, (int)2, (boolean)true, (boolean)this.isBodyIncludeStreams(), (boolean)this.isBodyIncludeFiles(), (int)this.getBodyMaxChars(), (boolean)true);
    }

    private final class NodeBreakpoint
    extends BreakpointSupport
    implements Condition {
        private final String nodeId;
        private Predicate condition;

        private NodeBreakpoint(String nodeId, Predicate condition) {
            this.nodeId = nodeId;
            this.condition = condition;
        }

        public Predicate getCondition() {
            return this.condition;
        }

        public void setCondition(Predicate predicate) {
            this.condition = predicate;
        }

        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            long timestamp = System.currentTimeMillis();
            String toNode = definition.getId();
            String routeId = CamelContextHelper.getRouteId((NamedNode)definition);
            String exchangeId = exchange.getExchangeId();
            String messageAsXml = DefaultBacklogDebugger.this.dumpAsXml(exchange);
            String messageAsJSon = DefaultBacklogDebugger.this.dumpAsJSon(exchange);
            long uid = DefaultBacklogDebugger.this.debugCounter.incrementAndGet();
            String source = LoggerHelper.getLineNumberLoggerName((Object)definition);
            boolean first = "from".equals(definition.getShortName());
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(first, false, uid, timestamp, source, routeId, toNode, exchangeId, false, false, messageAsXml, messageAsJSon);
            DefaultBacklogDebugger.this.suspendedBreakpointMessages.put(this.nodeId, msg);
            SuspendedExchange se = (SuspendedExchange)DefaultBacklogDebugger.this.suspendedBreakpoints.get(this.nodeId);
            if (se != null) {
                DefaultBacklogDebugger.this.logger.log(String.format("NodeBreakpoint at node %s is waiting to continue for exchangeId: %s", toNode, exchangeId));
                try {
                    boolean hit = se.getLatch().await(DefaultBacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                    if (!hit) {
                        DefaultBacklogDebugger.this.logger.log(String.format("NodeBreakpoint at node %s timed out and is continued exchangeId: %s", toNode, exchangeId), LoggingLevel.WARN);
                    } else {
                        DefaultBacklogDebugger.this.logger.log(String.format("NodeBreakpoint at node %s is continued exchangeId: %s", toNode, exchangeId));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
            if (!before) {
                return false;
            }
            if (!this.nodeId.equals(definition.getId())) {
                return false;
            }
            if (this.condition != null && !this.condition.matches(exchange)) {
                return false;
            }
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            boolean existing = DefaultBacklogDebugger.this.suspendedBreakpoints.putIfAbsent(this.nodeId, se) != null;
            return !existing;
        }

        public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
            return false;
        }
    }

    private static final class SuspendedExchange {
        private final Exchange exchange;
        private final CountDownLatch latch;

        private SuspendedExchange(Exchange exchange, CountDownLatch latch) {
            this.exchange = exchange;
            this.latch = latch;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }

    private final class StepBreakpoint
    extends BreakpointSupport
    implements Condition {
        private StepBreakpoint() {
        }

        public void beforeProcess(Exchange exchange, Processor processor, NamedNode definition) {
            long timestamp = System.currentTimeMillis();
            String toNode = definition.getId();
            String routeId = CamelContextHelper.getRouteId((NamedNode)definition);
            String exchangeId = exchange.getExchangeId();
            String messageAsXml = DefaultBacklogDebugger.this.dumpAsXml(exchange);
            String messageAsJSon = DefaultBacklogDebugger.this.dumpAsJSon(exchange);
            long uid = DefaultBacklogDebugger.this.debugCounter.incrementAndGet();
            String source = LoggerHelper.getLineNumberLoggerName((Object)definition);
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(false, false, uid, timestamp, source, routeId, toNode, exchangeId, false, false, messageAsXml, messageAsJSon);
            DefaultBacklogDebugger.this.suspendedBreakpointMessages.put(toNode, msg);
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            DefaultBacklogDebugger.this.suspendedBreakpoints.put(toNode, se);
            DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is waiting to continue for exchangeId: %s", toNode, exchange.getExchangeId()));
            try {
                boolean hit = se.getLatch().await(DefaultBacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                if (!hit) {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s timed out and is continued exchangeId: %s", toNode, exchange.getExchangeId()), LoggingLevel.WARN);
                } else {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is continued exchangeId: %s", toNode, exchange.getExchangeId()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        public boolean matchProcess(Exchange exchange, Processor processor, NamedNode definition, boolean before) {
            return true;
        }

        public boolean matchEvent(Exchange exchange, CamelEvent.ExchangeEvent event) {
            return event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(Exchange exchange, CamelEvent.ExchangeEvent event, NamedNode definition) {
            if (event instanceof CamelEvent.ExchangeCompletedEvent || event instanceof CamelEvent.ExchangeFailedEvent) {
                Throwable cause = null;
                if (event instanceof CamelEvent.ExchangeFailedEvent) {
                    CamelEvent.ExchangeFailedEvent fe = (CamelEvent.ExchangeFailedEvent)event;
                    cause = fe.getCause();
                }
                NamedRoute route = this.getOriginalRoute(exchange);
                String completedId = event.getExchange().getExchangeId();
                try {
                    if (DefaultBacklogDebugger.this.isSingleStepIncludeStartEnd() && DefaultBacklogDebugger.this.singleStepExchangeId != null && DefaultBacklogDebugger.this.singleStepExchangeId.equals(completedId)) {
                        this.doCompleted(exchange, definition, route, cause);
                    }
                }
                finally {
                    DefaultBacklogDebugger.this.logger.log("ExchangeId: " + completedId + " is completed, so exiting single step mode.");
                    DefaultBacklogDebugger.this.singleStepExchangeId = null;
                }
            }
        }

        private NamedRoute getOriginalRoute(Exchange exchange) {
            List list = (List)exchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class);
            if (list != null) {
                for (MessageHistory h : list) {
                    boolean skip;
                    NamedNode n = h.getNode();
                    NamedRoute nr = CamelContextHelper.getRoute((NamedNode)n);
                    if (nr == null || (skip = nr.isCreatedFromRest() || nr.isCreatedFromTemplate())) continue;
                    return nr;
                }
            }
            return null;
        }

        private void doCompleted(Exchange exchange, NamedNode definition, NamedRoute route, Throwable cause) {
            long timestamp = System.currentTimeMillis();
            String toNode = CamelContextHelper.getRouteId((NamedNode)definition);
            String routeId = route != null ? route.getRouteId() : toNode;
            String exchangeId = exchange.getExchangeId();
            String messageAsXml = DefaultBacklogDebugger.this.dumpAsXml(exchange);
            String messageAsJSon = DefaultBacklogDebugger.this.dumpAsJSon(exchange);
            long uid = DefaultBacklogDebugger.this.debugCounter.incrementAndGet();
            String source = LoggerHelper.getLineNumberLoggerName((Object)(route != null ? route : definition));
            DefaultBacklogTracerEventMessage msg = new DefaultBacklogTracerEventMessage(false, true, uid, timestamp, source, routeId, toNode, exchangeId, false, false, messageAsXml, messageAsJSon);
            if (cause != null) {
                String xml = MessageHelper.dumpExceptionAsXML((Throwable)cause, (int)4);
                msg.setExceptionAsXml(xml);
                String json = MessageHelper.dumpExceptionAsJSon((Throwable)cause, (int)4, (boolean)true);
                msg.setExceptionAsJSon(json);
            }
            DefaultBacklogDebugger.this.suspendedBreakpointMessages.put(toNode, msg);
            SuspendedExchange se = new SuspendedExchange(exchange, new CountDownLatch(1));
            DefaultBacklogDebugger.this.suspendedBreakpoints.put(toNode, se);
            DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is waiting to continue for exchangeId: %s", toNode, exchange.getExchangeId()));
            try {
                boolean hit = se.getLatch().await(DefaultBacklogDebugger.this.fallbackTimeout, TimeUnit.SECONDS);
                if (!hit) {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s timed out and is continued exchangeId: %s", toNode, exchange.getExchangeId()), LoggingLevel.WARN);
                } else {
                    DefaultBacklogDebugger.this.logger.log(String.format("StepBreakpoint at node %s is continued exchangeId: %s", toNode, exchange.getExchangeId()));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

