/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.camel.spi.ExceptionHandler;

public class SjmsLoggingExceptionListener
implements ExceptionListener {
    private final ExceptionHandler handler;
    private final boolean logStackTrace;

    public SjmsLoggingExceptionListener(ExceptionHandler exceptionHandler, boolean logStackTrace) {
        this.handler = exceptionHandler;
        this.logStackTrace = logStackTrace;
    }

    public void onException(JMSException throwable) {
        if (this.logStackTrace) {
            this.handler.handleException("Execution of JMS message listener failed", (Throwable)throwable);
        } else {
            this.handler.handleException("Execution of JMS message listener failed. Caused by: [" + throwable.getMessage() + "]", null);
        }
    }
}

