/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.producer;

import javax.jms.Message;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;

public class InOnlyProducer
extends SjmsProducer {
    public InOnlyProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    protected TransactionCommitStrategy getCommitStrategy() {
        if (this.isEndpointTransacted()) {
            return super.getCommitStrategy() == null ? new DefaultTransactionCommitStrategy() : super.getCommitStrategy();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback, MessageProducerResources producer, SjmsProducer.ReleaseProducerCallback releaseProducerCallback) throws Exception {
        try {
            Message message = this.getEndpoint().getBinding().makeJmsMessage(exchange, producer.getSession());
            producer.getMessageProducer().send(message);
        }
        catch (Exception e) {
            exchange.setException((Throwable)new CamelExchangeException("Unable to complete sending the JMS message", exchange, (Throwable)e));
        }
        finally {
            releaseProducerCallback.release(producer);
            callback.done(this.isSynchronous());
        }
    }
}

