/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.camel.Exchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class JmsMessageHelper {
    private JmsMessageHelper() {
    }

    public static Object removeJmsProperty(Message jmsMessage, String name) throws JMSException {
        if (!jmsMessage.propertyExists(name)) {
            return null;
        }
        String answer = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (name.equals(key)) {
                answer = key;
                continue;
            }
            map.put(key, JmsMessageHelper.getProperty(jmsMessage, key));
        }
        jmsMessage.clearProperties();
        for (Map.Entry entry : map.entrySet()) {
            jmsMessage.setObjectProperty((String)entry.getKey(), entry.getValue());
        }
        return answer;
    }

    public static boolean hasProperty(Message jmsMessage, String name) throws JMSException {
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!name.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static Object getProperty(Message jmsMessage, String name) throws JMSException {
        Object value = jmsMessage.getObjectProperty(name);
        if (value == null) {
            value = jmsMessage.getStringProperty(name);
        }
        return value;
    }

    public static void setProperty(Message jmsMessage, String name, Object value) throws JMSException {
        if (value == null) {
            return;
        }
        if (value instanceof Byte) {
            jmsMessage.setByteProperty(name, ((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            jmsMessage.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            jmsMessage.setDoubleProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            jmsMessage.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            jmsMessage.setIntProperty(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            jmsMessage.setLongProperty(name, ((Long)value).longValue());
        } else if (value instanceof Short) {
            jmsMessage.setShortProperty(name, ((Short)value).shortValue());
        } else if (value instanceof String) {
            jmsMessage.setStringProperty(name, (String)value);
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public static void setCorrelationId(Message message, String correlationId) {
        try {
            message.setJMSCorrelationID(correlationId);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public static boolean isQueuePrefix(String destination) {
        if (ObjectHelper.isEmpty((Object)destination)) {
            return false;
        }
        return destination.startsWith("queue:") || destination.startsWith("temp:queue:");
    }

    public static boolean isTopicPrefix(String destination) {
        if (ObjectHelper.isEmpty((Object)destination)) {
            return false;
        }
        return destination.startsWith("topic:") || destination.startsWith("temp:topic:");
    }

    public static String normalizeDestinationName(String destination) {
        return JmsMessageHelper.normalizeDestinationName(destination, false);
    }

    public static String normalizeDestinationName(String destination, boolean includePrefix) {
        if (ObjectHelper.isEmpty((Object)destination)) {
            return destination;
        }
        if (destination.startsWith("queue:")) {
            String s = StringHelper.removeStartingCharacters((String)destination.substring("queue:".length()), (char)'/');
            if (includePrefix) {
                s = "queue://" + s;
            }
            return s;
        }
        if (destination.startsWith("temp:queue:")) {
            String s = StringHelper.removeStartingCharacters((String)destination.substring("temp:queue:".length()), (char)'/');
            if (includePrefix) {
                s = "temp:queue://" + s;
            }
            return s;
        }
        if (destination.startsWith("topic:")) {
            String s = StringHelper.removeStartingCharacters((String)destination.substring("topic:".length()), (char)'/');
            if (includePrefix) {
                s = "topic://" + s;
            }
            return s;
        }
        if (destination.startsWith("temp:topic:")) {
            String s = StringHelper.removeStartingCharacters((String)destination.substring("temp:topic:".length()), (char)'/');
            if (includePrefix) {
                s = "temp:topic://" + s;
            }
            return s;
        }
        return destination;
    }

    public static void setJMSReplyTo(Message message, Destination replyTo) {
        try {
            message.setJMSReplyTo(replyTo);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Destination getJMSReplyTo(Message message) {
        try {
            return message.getJMSReplyTo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJMSType(Message message) {
        try {
            return message.getJMSType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getStringProperty(Message message, String propertyName) {
        try {
            return message.getStringProperty(propertyName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Boolean getJMSRedelivered(Message message) {
        try {
            return message.getJMSRedelivered();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJMSMessageID(Message message) {
        try {
            return message.getJMSMessageID();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setJMSDeliveryMode(Exchange exchange, Message message, Object deliveryMode) throws JMSException {
        Integer mode = null;
        if (deliveryMode instanceof String) {
            String s = (String)deliveryMode;
            if ("PERSISTENT".equalsIgnoreCase(s)) {
                mode = 2;
            } else if ("NON_PERSISTENT".equalsIgnoreCase(s)) {
                mode = 1;
            } else {
                Integer value = (Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)deliveryMode);
                if (value == null) throw new IllegalArgumentException("Unknown delivery mode with value: " + deliveryMode);
                mode = value;
            }
        } else {
            Integer value = (Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)deliveryMode);
            if (value != null) {
                mode = value;
            }
        }
        if (mode == null) return;
        message.setJMSDeliveryMode(mode.intValue());
        message.setIntProperty("JMSDeliveryMode", mode.intValue());
    }

    public static String getJMSCorrelationID(Message message) {
        try {
            return message.getJMSCorrelationID();
        }
        catch (JMSException jMSException) {
            return null;
        }
    }

    public static String getJMSCorrelationIDAsBytes(Message message) {
        try {
            return new String(message.getJMSCorrelationIDAsBytes());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Destination getJMSDestination(Message message) {
        try {
            return message.getJMSDestination();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

