/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.consumer;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sjms.MessageListenerContainer;
import org.apache.camel.component.sjms.SessionMessageListener;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsHelper;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.backoff.BackOff;
import org.apache.camel.util.backoff.BackOffTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessageListenerContainer
extends ServiceSupport
implements MessageListenerContainer,
ExceptionListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessageListenerContainer.class);
    private final SjmsEndpoint endpoint;
    private SessionMessageListener messageListener;
    private String clientId;
    private int concurrentConsumers = 1;
    private ExceptionListener exceptionListener;
    private String destinationName;
    private DestinationCreationStrategy destinationCreationStrategy;
    private final Object connectionLock = new Object();
    private Connection connection;
    private volatile boolean connectionStarted;
    private final Object consumerLock = new Object();
    private Set<MessageConsumer> consumers;
    private Set<Session> sessions;
    private BackOffTimer.Task recoverTask;
    private ScheduledExecutorService scheduler;

    public SimpleMessageListenerContainer(SjmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public SjmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setMessageListener(SessionMessageListener messageListener) {
        this.messageListener = messageListener;
    }

    @Override
    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.endpoint.getConnectionFactory();
    }

    protected void configureConsumer(MessageConsumer consumer, Session session) throws Exception {
        consumer.setMessageListener((MessageListener)new SimpleMessageListener(this.messageListener, session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException exception) {
        if (this.exceptionListener != null) {
            try {
                this.exceptionListener.onException(exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (this.endpoint.getExceptionListener() != null) {
            try {
                this.endpoint.getExceptionListener().onException(exception);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        Object object = this.connectionLock;
        synchronized (object) {
            this.sessions = null;
            this.consumers = null;
        }
        this.scheduleConnectionRecovery();
    }

    protected boolean recoverConnection(BackOffTimer.Task task) throws Exception {
        LOG.debug("Recovering from JMS Connection exception (attempt: {})", (Object)task.getCurrentAttempts());
        try {
            this.refreshConnection();
            this.initConsumers();
            LOG.debug("Successfully recovered JMS Connection (attempt: {})", (Object)task.getCurrentAttempts());
            return false;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to recover JMS Connection. Will try again in " + task.getCurrentDelay() + " millis", (Throwable)e);
            }
            return true;
        }
    }

    protected void scheduleConnectionRecovery() {
        if (this.scheduler == null) {
            this.scheduler = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "SimpleMessageListenerContainer");
        }
        if (this.recoverTask == null || this.recoverTask.getStatus() != BackOffTimer.Task.Status.Active) {
            BackOff backOff = BackOff.builder().delay(this.endpoint.getRecoveryInterval()).build();
            this.recoverTask = new BackOffTimer(this.scheduler).schedule(backOff, this::recoverConnection);
        }
    }

    protected void doStart() throws Exception {
        this.createConnection();
        this.initConsumers();
        this.startConnection();
    }

    protected void doStop() throws Exception {
        if (this.recoverTask != null) {
            this.recoverTask.cancel();
        }
        this.stopConnection();
        this.stopConsumers();
        if (this.scheduler != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown((ExecutorService)this.scheduler);
            this.scheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConsumers() throws Exception {
        Object object = this.consumerLock;
        synchronized (object) {
            if (this.consumers == null) {
                LOG.debug("Initializing {} concurrent consumers as JMS listener on destination: {}", (Object)this.concurrentConsumers, (Object)this.destinationName);
                this.sessions = new HashSet<Session>(this.concurrentConsumers);
                this.consumers = new HashSet<MessageConsumer>(this.concurrentConsumers);
                for (int i = 0; i < this.concurrentConsumers; ++i) {
                    Session session = this.createSession(this.connection, this.endpoint);
                    MessageConsumer consumer = this.createMessageConsumer(session);
                    this.configureConsumer(consumer, session);
                    this.sessions.add(session);
                    this.consumers.add(consumer);
                }
            }
        }
    }

    protected Session createSession(Connection connection, SjmsEndpoint endpoint) throws Exception {
        return connection.createSession(endpoint.isTransacted(), endpoint.getAcknowledgementMode().intValue());
    }

    protected MessageConsumer createMessageConsumer(Session session) throws Exception {
        return this.endpoint.getJmsObjectFactory().createMessageConsumer(session, (Endpoint)this.endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopConsumers() throws Exception {
        Object object = this.consumerLock;
        synchronized (object) {
            if (this.consumers != null) {
                LOG.debug("Stopping JMS MessageConsumers");
                for (MessageConsumer consumer : this.consumers) {
                    SjmsHelper.closeConsumer(consumer);
                }
                if (this.sessions != null) {
                    LOG.debug("Stopping JMS Sessions");
                    for (Session session : this.sessions) {
                        SjmsHelper.closeSession(session);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnection() throws Exception {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.connection == null) {
                Connection con = null;
                try {
                    String cid;
                    con = this.endpoint.getConnectionFactory().createConnection();
                    String string = cid = this.clientId != null ? this.clientId : this.endpoint.getClientId();
                    if (cid != null) {
                        con.setClientID(cid);
                    }
                    con.setExceptionListener((ExceptionListener)this);
                }
                catch (JMSException e) {
                    SjmsHelper.closeConnection(con);
                    throw e;
                }
                this.connection = con;
                LOG.debug("Created JMS Connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshConnection() throws Exception {
        Object object = this.connectionLock;
        synchronized (object) {
            SjmsHelper.closeConnection(this.connection);
            this.connection = null;
            this.createConnection();
            if (this.connectionStarted) {
                this.startConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startConnection() throws Exception {
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionStarted = true;
            if (this.connection != null) {
                try {
                    this.connection.start();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopConnection() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionStarted = false;
            if (this.connection != null) {
                try {
                    this.connection.stop();
                }
                catch (Exception e) {
                    LOG.debug("Error stopping connection. This exception is ignored.", (Throwable)e);
                }
            }
        }
    }

    private class SimpleMessageListener
    implements MessageListener {
        private final SessionMessageListener messageListener;
        private final Session session;

        public SimpleMessageListener(SessionMessageListener messageListener, Session session) {
            this.messageListener = messageListener;
            this.session = session;
        }

        public void onMessage(Message message) {
            try {
                this.doOnMessage(message);
            }
            catch (Exception e) {
                if (e instanceof JMSException) {
                    if (SimpleMessageListenerContainer.this.endpoint.getExceptionListener() != null) {
                        SimpleMessageListenerContainer.this.endpoint.getExceptionListener().onException((JMSException)((Object)e));
                    }
                }
                LOG.warn("Execution of JMS message listener failed. This exception is ignored.", (Throwable)e);
            }
        }

        protected void doOnMessage(Message message) throws Exception {
            try {
                this.messageListener.onMessage(message, this.session);
            }
            catch (Exception e) {
                SjmsHelper.rollbackIfNeeded(this.session);
                throw e;
            }
            SjmsHelper.commitIfNeeded(this.session, message);
        }
    }
}

