/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

public abstract class FhirDataformat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlTransient
    @Metadata(label="advanced")
    private Object fhirContext;
    @XmlAttribute
    @Metadata(enums="DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4,R5", defaultValue="R4")
    private String fhirVersion;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String prettyPrint;
    @XmlTransient
    @Metadata(label="advanced")
    private Object parserErrorHandler;
    @XmlTransient
    @Metadata(label="advanced")
    private Object parserOptions;
    @XmlTransient
    @Metadata(label="advanced")
    private Object preferTypes;
    @XmlTransient
    @Metadata(label="advanced")
    private Object forceResourceId;
    @XmlAttribute
    @Metadata(label="advanced")
    private String serverBaseUrl;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String omitResourceId;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String encodeElementsAppliesToChildResourcesOnly;
    @XmlAttribute
    @Metadata(label="advanced")
    private Set<String> encodeElements;
    @XmlAttribute
    @Metadata(label="advanced")
    private Set<String> dontEncodeElements;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String stripVersionsFromReferences;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String overrideResourceIdWithBundleEntryFullUrl;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String summaryMode;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String suppressNarratives;
    @XmlAttribute
    @Metadata(label="advanced")
    private List<String> dontStripVersionsFromReferencesAtPaths;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;

    protected FhirDataformat(String dataFormatName) {
        super(dataFormatName);
    }

    protected FhirDataformat() {
    }

    protected FhirDataformat(String dataFormatName, AbstractBuilder<?, ?> builder) {
        this(dataFormatName);
        this.fhirContext = builder.fhirContext;
        this.fhirVersion = builder.fhirVersion;
        this.prettyPrint = builder.prettyPrint;
        this.parserErrorHandler = builder.parserErrorHandler;
        this.parserOptions = builder.parserOptions;
        this.preferTypes = builder.preferTypes;
        this.forceResourceId = builder.forceResourceId;
        this.serverBaseUrl = builder.serverBaseUrl;
        this.omitResourceId = builder.omitResourceId;
        this.encodeElementsAppliesToChildResourcesOnly = builder.encodeElementsAppliesToChildResourcesOnly;
        this.encodeElements = builder.encodeElements;
        this.dontEncodeElements = builder.dontEncodeElements;
        this.stripVersionsFromReferences = builder.stripVersionsFromReferences;
        this.overrideResourceIdWithBundleEntryFullUrl = builder.overrideResourceIdWithBundleEntryFullUrl;
        this.summaryMode = builder.summaryMode;
        this.suppressNarratives = builder.suppressNarratives;
        this.dontStripVersionsFromReferencesAtPaths = builder.dontStripVersionsFromReferencesAtPaths;
        this.contentTypeHeader = builder.contentTypeHeader;
    }

    public Object getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(Object fhirContext) {
        this.fhirContext = fhirContext;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Object getParserErrorHandler() {
        return this.parserErrorHandler;
    }

    public void setParserErrorHandler(Object parserErrorHandler) {
        this.parserErrorHandler = parserErrorHandler;
    }

    public Object getParserOptions() {
        return this.parserOptions;
    }

    public void setParserOptions(Object parserOptions) {
        this.parserOptions = parserOptions;
    }

    public Object getPreferTypes() {
        return this.preferTypes;
    }

    public void setPreferTypes(Object preferTypes) {
        this.preferTypes = preferTypes;
    }

    public Object getForceResourceId() {
        return this.forceResourceId;
    }

    public void setForceResourceId(Object forceResourceId) {
        this.forceResourceId = forceResourceId;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public String getOmitResourceId() {
        return this.omitResourceId;
    }

    public void setOmitResourceId(String omitResourceId) {
        this.omitResourceId = omitResourceId;
    }

    public String getEncodeElementsAppliesToChildResourcesOnly() {
        return this.encodeElementsAppliesToChildResourcesOnly;
    }

    public void setEncodeElementsAppliesToChildResourcesOnly(String encodeElementsAppliesToChildResourcesOnly) {
        this.encodeElementsAppliesToChildResourcesOnly = encodeElementsAppliesToChildResourcesOnly;
    }

    public Set<String> getEncodeElements() {
        return this.encodeElements;
    }

    public void setEncodeElements(Set<String> encodeElements) {
        this.encodeElements = encodeElements;
    }

    public Set<String> getDontEncodeElements() {
        return this.dontEncodeElements;
    }

    public void setDontEncodeElements(Set<String> dontEncodeElements) {
        this.dontEncodeElements = dontEncodeElements;
    }

    public String getStripVersionsFromReferences() {
        return this.stripVersionsFromReferences;
    }

    public void setStripVersionsFromReferences(String stripVersionsFromReferences) {
        this.stripVersionsFromReferences = stripVersionsFromReferences;
    }

    public String getOverrideResourceIdWithBundleEntryFullUrl() {
        return this.overrideResourceIdWithBundleEntryFullUrl;
    }

    public void setOverrideResourceIdWithBundleEntryFullUrl(String overrideResourceIdWithBundleEntryFullUrl) {
        this.overrideResourceIdWithBundleEntryFullUrl = overrideResourceIdWithBundleEntryFullUrl;
    }

    public String getSummaryMode() {
        return this.summaryMode;
    }

    public void setSummaryMode(String summaryMode) {
        this.summaryMode = summaryMode;
    }

    public String getSuppressNarratives() {
        return this.suppressNarratives;
    }

    public void setSuppressNarratives(String suppressNarratives) {
        this.suppressNarratives = suppressNarratives;
    }

    public List<String> getDontStripVersionsFromReferencesAtPaths() {
        return this.dontStripVersionsFromReferencesAtPaths;
    }

    public void setDontStripVersionsFromReferencesAtPaths(List<String> dontStripVersionsFromReferencesAtPaths) {
        this.dontStripVersionsFromReferencesAtPaths = dontStripVersionsFromReferencesAtPaths;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    @XmlTransient
    static abstract class AbstractBuilder<T extends AbstractBuilder<T, F>, F extends FhirDataformat>
    implements DataFormatBuilder<F> {
        private Object fhirContext;
        private String fhirVersion;
        private String prettyPrint;
        private Object parserErrorHandler;
        private Object parserOptions;
        private Object preferTypes;
        private Object forceResourceId;
        private String serverBaseUrl;
        private String omitResourceId;
        private String encodeElementsAppliesToChildResourcesOnly;
        private Set<String> encodeElements;
        private Set<String> dontEncodeElements;
        private String stripVersionsFromReferences;
        private String overrideResourceIdWithBundleEntryFullUrl;
        private String summaryMode;
        private String suppressNarratives;
        private List<String> dontStripVersionsFromReferencesAtPaths;
        private String contentTypeHeader;

        AbstractBuilder() {
        }

        public T fhirContext(Object fhirContext) {
            this.fhirContext = fhirContext;
            return (T)this;
        }

        public T fhirVersion(String fhirVersion) {
            this.fhirVersion = fhirVersion;
            return (T)this;
        }

        public T prettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return (T)this;
        }

        public T prettyPrint(boolean prettyPrint) {
            this.prettyPrint = Boolean.toString(prettyPrint);
            return (T)this;
        }

        public T parserErrorHandler(Object parserErrorHandler) {
            this.parserErrorHandler = parserErrorHandler;
            return (T)this;
        }

        public T parserOptions(Object parserOptions) {
            this.parserOptions = parserOptions;
            return (T)this;
        }

        public T preferTypes(Object preferTypes) {
            this.preferTypes = preferTypes;
            return (T)this;
        }

        public T forceResourceId(Object forceResourceId) {
            this.forceResourceId = forceResourceId;
            return (T)this;
        }

        public T serverBaseUrl(String serverBaseUrl) {
            this.serverBaseUrl = serverBaseUrl;
            return (T)this;
        }

        public T omitResourceId(String omitResourceId) {
            this.omitResourceId = omitResourceId;
            return (T)this;
        }

        public T omitResourceId(boolean omitResourceId) {
            this.omitResourceId = Boolean.toString(omitResourceId);
            return (T)this;
        }

        public T encodeElementsAppliesToChildResourcesOnly(String encodeElementsAppliesToChildResourcesOnly) {
            this.encodeElementsAppliesToChildResourcesOnly = encodeElementsAppliesToChildResourcesOnly;
            return (T)this;
        }

        public T encodeElementsAppliesToChildResourcesOnly(boolean encodeElementsAppliesToChildResourcesOnly) {
            this.encodeElementsAppliesToChildResourcesOnly = Boolean.toString(encodeElementsAppliesToChildResourcesOnly);
            return (T)this;
        }

        public T encodeElements(Set<String> encodeElements) {
            this.encodeElements = encodeElements;
            return (T)this;
        }

        public T dontEncodeElements(Set<String> dontEncodeElements) {
            this.dontEncodeElements = dontEncodeElements;
            return (T)this;
        }

        public T stripVersionsFromReferences(String stripVersionsFromReferences) {
            this.stripVersionsFromReferences = stripVersionsFromReferences;
            return (T)this;
        }

        public T stripVersionsFromReferences(boolean stripVersionsFromReferences) {
            this.stripVersionsFromReferences = Boolean.toString(stripVersionsFromReferences);
            return (T)this;
        }

        public T overrideResourceIdWithBundleEntryFullUrl(String overrideResourceIdWithBundleEntryFullUrl) {
            this.overrideResourceIdWithBundleEntryFullUrl = overrideResourceIdWithBundleEntryFullUrl;
            return (T)this;
        }

        public T overrideResourceIdWithBundleEntryFullUrl(boolean overrideResourceIdWithBundleEntryFullUrl) {
            this.overrideResourceIdWithBundleEntryFullUrl = Boolean.toString(overrideResourceIdWithBundleEntryFullUrl);
            return (T)this;
        }

        public T summaryMode(String summaryMode) {
            this.summaryMode = summaryMode;
            return (T)this;
        }

        public T summaryMode(boolean summaryMode) {
            this.summaryMode = Boolean.toString(summaryMode);
            return (T)this;
        }

        public T suppressNarratives(String suppressNarratives) {
            this.suppressNarratives = suppressNarratives;
            return (T)this;
        }

        public T suppressNarratives(boolean suppressNarratives) {
            this.suppressNarratives = Boolean.toString(suppressNarratives);
            return (T)this;
        }

        public T dontStripVersionsFromReferencesAtPaths(List<String> dontStripVersionsFromReferencesAtPaths) {
            this.dontStripVersionsFromReferencesAtPaths = dontStripVersionsFromReferencesAtPaths;
            return (T)this;
        }

        public T contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return (T)this;
        }

        public T contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return (T)this;
        }
    }
}

