/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.servicenow;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelServicenowSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_SERVICENOW_PATH_INSTANCE_NAME_CONF = "camel.sink.path.instanceName";
    public static final String CAMEL_SINK_SERVICENOW_PATH_INSTANCE_NAME_DOC = "The ServiceNow instance name";
    public static final String CAMEL_SINK_SERVICENOW_PATH_INSTANCE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_CONF = "camel.sink.endpoint.display";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_DOC = "Set this parameter to true to return only scorecards where the indicator Display field is selected. Set this parameter to all to return scorecards with any Display field value. This parameter is true by default. One of: [false] [true] [all]";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_DEFAULT = "true";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_VALUE_CONF = "camel.sink.endpoint.displayValue";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_VALUE_DOC = "Return the display value (true), actual value (false), or both (all) for reference fields (default: false) One of: [false] [true] [all]";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_VALUE_DEFAULT = "false";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_EXCLUDE_REFERENCE_LINK_CONF = "camel.sink.endpoint.excludeReferenceLink";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_EXCLUDE_REFERENCE_LINK_DOC = "True to exclude Table API links for reference fields (default: false)";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_EXCLUDE_REFERENCE_LINK_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_FAVORITES_CONF = "camel.sink.endpoint.favorites";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_FAVORITES_DOC = "Set this parameter to true to return only scorecards that are favorites of the querying user.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_FAVORITES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AGGREGATES_CONF = "camel.sink.endpoint.includeAggregates";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AGGREGATES_DOC = "Set this parameter to true to always return all available aggregates for an indicator, including when an aggregate has already been applied. If a value is not specified, this parameter defaults to false and returns no aggregates.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AGGREGATES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_AGGREGATES_CONF = "camel.sink.endpoint.includeAvailableAggregates";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_AGGREGATES_DOC = "Set this parameter to true to return all available aggregates for an indicator when no aggregate has been applied. If a value is not specified, this parameter defaults to false and returns no aggregates.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_AGGREGATES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_BREAKDOWNS_CONF = "camel.sink.endpoint.includeAvailableBreakdowns";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_BREAKDOWNS_DOC = "Set this parameter to true to return all available breakdowns for an indicator. If a value is not specified, this parameter defaults to false and returns no breakdowns.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_BREAKDOWNS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORE_NOTES_CONF = "camel.sink.endpoint.includeScoreNotes";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORE_NOTES_DOC = "Set this parameter to true to return all notes associated with the score. The note element contains the note text as well as the author and timestamp when the note was added.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORE_NOTES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORES_CONF = "camel.sink.endpoint.includeScores";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORES_DOC = "Set this parameter to true to return all scores for a scorecard. If a value is not specified, this parameter defaults to false and returns only the most recent score value.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INPUT_DISPLAY_VALUE_CONF = "camel.sink.endpoint.inputDisplayValue";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INPUT_DISPLAY_VALUE_DOC = "True to set raw value of input fields (default: false)";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_INPUT_DISPLAY_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_KEY_CONF = "camel.sink.endpoint.key";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_KEY_DOC = "Set this parameter to true to return only scorecards for key indicators.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_SERVICENOW_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_MODELS_CONF = "camel.sink.endpoint.models";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_MODELS_DOC = "Defines both request and response models";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_MODELS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PER_PAGE_CONF = "camel.sink.endpoint.perPage";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PER_PAGE_DOC = "Enter the maximum number of scorecards each query can return. By default this value is 10, and the maximum is 100.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PER_PAGE_DEFAULT = "10";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RELEASE_CONF = "camel.sink.endpoint.release";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RELEASE_DOC = "The ServiceNow release to target, default to Helsinki See https://docs.servicenow.com One of: [FUJI] [GENEVA] [HELSINKI]";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RELEASE_DEFAULT = "HELSINKI";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_REQUEST_MODELS_CONF = "camel.sink.endpoint.requestModels";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_REQUEST_MODELS_DOC = "Defines the request model";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_REQUEST_MODELS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RESOURCE_CONF = "camel.sink.endpoint.resource";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RESOURCE_DOC = "The default resource, can be overridden by header CamelServiceNowResource";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RESPONSE_MODELS_CONF = "camel.sink.endpoint.responseModels";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RESPONSE_MODELS_DOC = "Defines the response model";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RESPONSE_MODELS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_BY_CONF = "camel.sink.endpoint.sortBy";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_BY_DOC = "Specify the value to use when sorting results. By default, queries sort records by value. One of: [value] [change] [changeperc] [gap] [gapperc] [duedate] [name] [order] [default] [group] [indicator_group] [frequency] [target] [date] [trend] [bullet] [direction]";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_BY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_DIR_CONF = "camel.sink.endpoint.sortDir";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_DIR_DOC = "Specify the sort direction, ascending or descending. By default, queries sort records in descending order. Use sysparm_sortdir=asc to sort in ascending order. One of: [asc] [desc]";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_AUTO_SYS_FIELD_CONF = "camel.sink.endpoint.suppressAutoSysField";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_AUTO_SYS_FIELD_DOC = "True to suppress auto generation of system fields (default: false)";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_AUTO_SYS_FIELD_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_PAGINATION_HEADER_CONF = "camel.sink.endpoint.suppressPaginationHeader";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_PAGINATION_HEADER_DOC = "Set this value to true to remove the Link header from the response. The Link header allows you to request additional pages of data when the number of records matching your query exceeds the query limit";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_PAGINATION_HEADER_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TABLE_CONF = "camel.sink.endpoint.table";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TABLE_DOC = "The default table, can be overridden by header CamelServiceNowTable";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TABLE_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TARGET_CONF = "camel.sink.endpoint.target";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TARGET_DOC = "Set this parameter to true to return only scorecards that have a target.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TARGET_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TOP_LEVEL_ONLY_CONF = "camel.sink.endpoint.topLevelOnly";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TOP_LEVEL_ONLY_DOC = "Gets only those categories whose parent is a catalog.";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TOP_LEVEL_ONLY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_API_VERSION_CONF = "camel.sink.endpoint.apiVersion";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_API_VERSION_DOC = "The ServiceNow REST API version, default latest";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_API_VERSION_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_FORMAT_CONF = "camel.sink.endpoint.dateFormat";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_FORMAT_DOC = "The date format used for Json serialization/deserialization";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_TIME_FORMAT_CONF = "camel.sink.endpoint.dateTimeFormat";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_TIME_FORMAT_DOC = "The date-time format used for Json serialization/deserialization";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_TIME_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_HTTP_CLIENT_POLICY_CONF = "camel.sink.endpoint.httpClientPolicy";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_HTTP_CLIENT_POLICY_DOC = "To configure http-client";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_HTTP_CLIENT_POLICY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_MAPPER_CONF = "camel.sink.endpoint.mapper";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_MAPPER_DOC = "Sets Jackson's ObjectMapper to use for request/reply";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_MAPPER_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_AUTHORIZATION_POLICY_CONF = "camel.sink.endpoint.proxyAuthorizationPolicy";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_AUTHORIZATION_POLICY_DOC = "To configure proxy authentication";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_AUTHORIZATION_POLICY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RETRIEVE_TARGET_RECORD_ON_IMPORT_CONF = "camel.sink.endpoint.retrieveTargetRecordOnImport";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DOC = "Set this parameter to true to retrieve the target record when using import set api. The import set result is then replaced by the target record";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DEFAULT = "false";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TIME_FORMAT_CONF = "camel.sink.endpoint.timeFormat";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TIME_FORMAT_DOC = "The time format used for Json serialization/deserialization";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_TIME_FORMAT_DEFAULT = "HH:mm:ss";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_HOST_CONF = "camel.sink.endpoint.proxyHost";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_HOST_DOC = "The proxy host name";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PORT_CONF = "camel.sink.endpoint.proxyPort";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PORT_DOC = "The proxy port number";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_API_URL_CONF = "camel.sink.endpoint.apiUrl";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_API_URL_DOC = "The ServiceNow REST API url";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_API_URL_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_ID_CONF = "camel.sink.endpoint.oauthClientId";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_ID_DOC = "OAuth2 ClientID";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_SECRET_CONF = "camel.sink.endpoint.oauthClientSecret";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_SECRET_DOC = "OAuth2 ClientSecret";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_TOKEN_URL_CONF = "camel.sink.endpoint.oauthTokenUrl";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_TOKEN_URL_DOC = "OAuth token Url";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_TOKEN_URL_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PASSWORD_CONF = "camel.sink.endpoint.password";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PASSWORD_DOC = "ServiceNow account password, MUST be provided";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PASSWORD_CONF = "camel.sink.endpoint.proxyPassword";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PASSWORD_DOC = "Password for proxy authentication";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_USER_NAME_CONF = "camel.sink.endpoint.proxyUserName";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_USER_NAME_DOC = "Username for proxy authentication";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_USER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.sink.endpoint.sslContextParameters";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters. See http://camel.apache.org/camel-configuration-utilities.html";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_USER_NAME_CONF = "camel.sink.endpoint.userName";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_USER_NAME_DOC = "ServiceNow user account name, MUST be provided";
    public static final String CAMEL_SINK_SERVICENOW_ENDPOINT_USER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_CONFIGURATION_CONF = "camel.component.servicenow.configuration";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_CONFIGURATION_DOC = "Component configuration";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_CONF = "camel.component.servicenow.display";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_DOC = "Set this parameter to true to return only scorecards where the indicator Display field is selected. Set this parameter to all to return scorecards with any Display field value. This parameter is true by default. One of: [false] [true] [all]";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_DEFAULT = "true";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_VALUE_CONF = "camel.component.servicenow.displayValue";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_VALUE_DOC = "Return the display value (true), actual value (false), or both (all) for reference fields (default: false) One of: [false] [true] [all]";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_VALUE_DEFAULT = "false";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_EXCLUDE_REFERENCE_LINK_CONF = "camel.component.servicenow.excludeReferenceLink";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_EXCLUDE_REFERENCE_LINK_DOC = "True to exclude Table API links for reference fields (default: false)";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_EXCLUDE_REFERENCE_LINK_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_FAVORITES_CONF = "camel.component.servicenow.favorites";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_FAVORITES_DOC = "Set this parameter to true to return only scorecards that are favorites of the querying user.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_FAVORITES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AGGREGATES_CONF = "camel.component.servicenow.includeAggregates";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AGGREGATES_DOC = "Set this parameter to true to always return all available aggregates for an indicator, including when an aggregate has already been applied. If a value is not specified, this parameter defaults to false and returns no aggregates.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AGGREGATES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_AGGREGATES_CONF = "camel.component.servicenow.includeAvailableAggregates";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_AGGREGATES_DOC = "Set this parameter to true to return all available aggregates for an indicator when no aggregate has been applied. If a value is not specified, this parameter defaults to false and returns no aggregates.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_AGGREGATES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_BREAKDOWNS_CONF = "camel.component.servicenow.includeAvailableBreakdowns";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_BREAKDOWNS_DOC = "Set this parameter to true to return all available breakdowns for an indicator. If a value is not specified, this parameter defaults to false and returns no breakdowns.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_BREAKDOWNS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORE_NOTES_CONF = "camel.component.servicenow.includeScoreNotes";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORE_NOTES_DOC = "Set this parameter to true to return all notes associated with the score. The note element contains the note text as well as the author and timestamp when the note was added.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORE_NOTES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORES_CONF = "camel.component.servicenow.includeScores";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORES_DOC = "Set this parameter to true to return all scores for a scorecard. If a value is not specified, this parameter defaults to false and returns only the most recent score value.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORES_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INPUT_DISPLAY_VALUE_CONF = "camel.component.servicenow.inputDisplayValue";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INPUT_DISPLAY_VALUE_DOC = "True to set raw value of input fields (default: false)";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INPUT_DISPLAY_VALUE_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_KEY_CONF = "camel.component.servicenow.key";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_KEY_DOC = "Set this parameter to true to return only scorecards for key indicators.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.servicenow.lazyStartProducer";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_SERVICENOW_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_MODELS_CONF = "camel.component.servicenow.models";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_MODELS_DOC = "Defines both request and response models";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_MODELS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PER_PAGE_CONF = "camel.component.servicenow.perPage";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PER_PAGE_DOC = "Enter the maximum number of scorecards each query can return. By default this value is 10, and the maximum is 100.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PER_PAGE_DEFAULT = "10";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RELEASE_CONF = "camel.component.servicenow.release";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RELEASE_DOC = "The ServiceNow release to target, default to Helsinki See https://docs.servicenow.com One of: [FUJI] [GENEVA] [HELSINKI]";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RELEASE_DEFAULT = "HELSINKI";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_REQUEST_MODELS_CONF = "camel.component.servicenow.requestModels";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_REQUEST_MODELS_DOC = "Defines the request model";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_REQUEST_MODELS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RESOURCE_CONF = "camel.component.servicenow.resource";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RESOURCE_DOC = "The default resource, can be overridden by header CamelServiceNowResource";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RESOURCE_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RESPONSE_MODELS_CONF = "camel.component.servicenow.responseModels";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RESPONSE_MODELS_DOC = "Defines the response model";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RESPONSE_MODELS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SORT_BY_CONF = "camel.component.servicenow.sortBy";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SORT_BY_DOC = "Specify the value to use when sorting results. By default, queries sort records by value. One of: [value] [change] [changeperc] [gap] [gapperc] [duedate] [name] [order] [default] [group] [indicator_group] [frequency] [target] [date] [trend] [bullet] [direction]";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SORT_BY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SORT_DIR_CONF = "camel.component.servicenow.sortDir";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SORT_DIR_DOC = "Specify the sort direction, ascending or descending. By default, queries sort records in descending order. Use sysparm_sortdir=asc to sort in ascending order. One of: [asc] [desc]";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SORT_DIR_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_AUTO_SYS_FIELD_CONF = "camel.component.servicenow.suppressAutoSysField";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_AUTO_SYS_FIELD_DOC = "True to suppress auto generation of system fields (default: false)";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_AUTO_SYS_FIELD_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_PAGINATION_HEADER_CONF = "camel.component.servicenow.suppressPaginationHeader";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_PAGINATION_HEADER_DOC = "Set this value to true to remove the Link header from the response. The Link header allows you to request additional pages of data when the number of records matching your query exceeds the query limit";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_PAGINATION_HEADER_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TABLE_CONF = "camel.component.servicenow.table";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TABLE_DOC = "The default table, can be overridden by header CamelServiceNowTable";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TABLE_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TARGET_CONF = "camel.component.servicenow.target";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TARGET_DOC = "Set this parameter to true to return only scorecards that have a target.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TARGET_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TOP_LEVEL_ONLY_CONF = "camel.component.servicenow.topLevelOnly";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TOP_LEVEL_ONLY_DOC = "Gets only those categories whose parent is a catalog.";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TOP_LEVEL_ONLY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_API_VERSION_CONF = "camel.component.servicenow.apiVersion";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_API_VERSION_DOC = "The ServiceNow REST API version, default latest";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_API_VERSION_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.servicenow.autowiredEnabled";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_SERVICENOW_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DATE_FORMAT_CONF = "camel.component.servicenow.dateFormat";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DATE_FORMAT_DOC = "The date format used for Json serialization/deserialization";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DATE_FORMAT_DEFAULT = "yyyy-MM-dd";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DATE_TIME_FORMAT_CONF = "camel.component.servicenow.dateTimeFormat";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DATE_TIME_FORMAT_DOC = "The date-time format used for Json serialization/deserialization";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_DATE_TIME_FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_HTTP_CLIENT_POLICY_CONF = "camel.component.servicenow.httpClientPolicy";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_HTTP_CLIENT_POLICY_DOC = "To configure http-client";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_HTTP_CLIENT_POLICY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INSTANCE_NAME_CONF = "camel.component.servicenow.instanceName";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INSTANCE_NAME_DOC = "The ServiceNow instance name";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_INSTANCE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_MAPPER_CONF = "camel.component.servicenow.mapper";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_MAPPER_DOC = "Sets Jackson's ObjectMapper to use for request/reply";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_MAPPER_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_AUTHORIZATION_POLICY_CONF = "camel.component.servicenow.proxyAuthorizationPolicy";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_AUTHORIZATION_POLICY_DOC = "To configure proxy authentication";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_AUTHORIZATION_POLICY_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RETRIEVE_TARGET_RECORD_ON_IMPORT_CONF = "camel.component.servicenow.retrieveTargetRecordOnImport";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DOC = "Set this parameter to true to retrieve the target record when using import set api. The import set result is then replaced by the target record";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DEFAULT = "false";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TIME_FORMAT_CONF = "camel.component.servicenow.timeFormat";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TIME_FORMAT_DOC = "The time format used for Json serialization/deserialization";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_TIME_FORMAT_DEFAULT = "HH:mm:ss";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_HOST_CONF = "camel.component.servicenow.proxyHost";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_HOST_DOC = "The proxy host name";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PORT_CONF = "camel.component.servicenow.proxyPort";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PORT_DOC = "The proxy port number";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_API_URL_CONF = "camel.component.servicenow.apiUrl";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_API_URL_DOC = "The ServiceNow REST API url";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_API_URL_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_ID_CONF = "camel.component.servicenow.oauthClientId";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_ID_DOC = "OAuth2 ClientID";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_SECRET_CONF = "camel.component.servicenow.oauthClientSecret";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_SECRET_DOC = "OAuth2 ClientSecret";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_SECRET_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_TOKEN_URL_CONF = "camel.component.servicenow.oauthTokenUrl";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_TOKEN_URL_DOC = "OAuth token Url";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_TOKEN_URL_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PASSWORD_CONF = "camel.component.servicenow.password";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PASSWORD_DOC = "ServiceNow account password, MUST be provided";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PASSWORD_CONF = "camel.component.servicenow.proxyPassword";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PASSWORD_DOC = "Password for proxy authentication";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_USER_NAME_CONF = "camel.component.servicenow.proxyUserName";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_USER_NAME_DOC = "Username for proxy authentication";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_USER_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.servicenow.sslContextParameters";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "To configure security using SSLContextParameters. See http://camel.apache.org/camel-configuration-utilities.html";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.servicenow.useGlobalSslContextParameters";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SINK_SERVICENOW_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_USER_NAME_CONF = "camel.component.servicenow.userName";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_USER_NAME_DOC = "ServiceNow user account name, MUST be provided";
    public static final String CAMEL_SINK_SERVICENOW_COMPONENT_USER_NAME_DEFAULT = null;

    public CamelServicenowSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelServicenowSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_SERVICENOW_PATH_INSTANCE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_PATH_INSTANCE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SERVICENOW_PATH_INSTANCE_NAME_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_DISPLAY_VALUE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_EXCLUDE_REFERENCE_LINK_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_EXCLUDE_REFERENCE_LINK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_EXCLUDE_REFERENCE_LINK_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_FAVORITES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_FAVORITES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_FAVORITES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AGGREGATES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AGGREGATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AGGREGATES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_AGGREGATES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_AGGREGATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_AGGREGATES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_BREAKDOWNS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_BREAKDOWNS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_AVAILABLE_BREAKDOWNS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORE_NOTES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORE_NOTES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORE_NOTES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_INCLUDE_SCORES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_INPUT_DISPLAY_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_INPUT_DISPLAY_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_INPUT_DISPLAY_VALUE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_KEY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SERVICENOW_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_MODELS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_MODELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_MODELS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PER_PAGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_PER_PAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_PER_PAGE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_RELEASE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_RELEASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_RELEASE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_REQUEST_MODELS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_REQUEST_MODELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_REQUEST_MODELS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_RESOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_RESOURCE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_RESPONSE_MODELS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_RESPONSE_MODELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_RESPONSE_MODELS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_BY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_BY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_BY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_SORT_DIR_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_AUTO_SYS_FIELD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_AUTO_SYS_FIELD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_AUTO_SYS_FIELD_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_PAGINATION_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_PAGINATION_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_SUPPRESS_PAGINATION_HEADER_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_TABLE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_TABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_TABLE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_TARGET_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_TARGET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_TARGET_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_TOP_LEVEL_ONLY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_TOP_LEVEL_ONLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_TOP_LEVEL_ONLY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_API_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_API_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_API_VERSION_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_FORMAT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_TIME_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_TIME_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_DATE_TIME_FORMAT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_HTTP_CLIENT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_HTTP_CLIENT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_HTTP_CLIENT_POLICY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_MAPPER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_MAPPER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_MAPPER_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_AUTHORIZATION_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_AUTHORIZATION_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_AUTHORIZATION_POLICY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_RETRIEVE_TARGET_RECORD_ON_IMPORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_TIME_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_TIME_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_TIME_FORMAT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_HOST_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PORT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_API_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_API_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_API_URL_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_ID_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_SECRET_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_TOKEN_URL_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_TOKEN_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_OAUTH_TOKEN_URL_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SERVICENOW_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_PASSWORD_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_USER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_USER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_PROXY_USER_NAME_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_ENDPOINT_USER_NAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_ENDPOINT_USER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SERVICENOW_ENDPOINT_USER_NAME_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_DISPLAY_VALUE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_EXCLUDE_REFERENCE_LINK_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_EXCLUDE_REFERENCE_LINK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_EXCLUDE_REFERENCE_LINK_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_FAVORITES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_FAVORITES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_FAVORITES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AGGREGATES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AGGREGATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AGGREGATES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_AGGREGATES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_AGGREGATES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_AGGREGATES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_BREAKDOWNS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_BREAKDOWNS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_AVAILABLE_BREAKDOWNS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORE_NOTES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORE_NOTES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORE_NOTES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORES_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INCLUDE_SCORES_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INPUT_DISPLAY_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INPUT_DISPLAY_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INPUT_DISPLAY_VALUE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_KEY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SERVICENOW_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_MODELS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_MODELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_MODELS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PER_PAGE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_PER_PAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_PER_PAGE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_RELEASE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_RELEASE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_RELEASE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_REQUEST_MODELS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_REQUEST_MODELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_REQUEST_MODELS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_RESOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_RESOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_RESOURCE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_RESPONSE_MODELS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_RESPONSE_MODELS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_RESPONSE_MODELS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_SORT_BY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_SORT_BY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_SORT_BY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_SORT_DIR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_SORT_DIR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_SORT_DIR_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_AUTO_SYS_FIELD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_AUTO_SYS_FIELD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_AUTO_SYS_FIELD_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_PAGINATION_HEADER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_PAGINATION_HEADER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_SUPPRESS_PAGINATION_HEADER_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_TABLE_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_TABLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_TABLE_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_TARGET_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_TARGET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_TARGET_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_TOP_LEVEL_ONLY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_TOP_LEVEL_ONLY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_TOP_LEVEL_ONLY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_API_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_API_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_API_VERSION_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SERVICENOW_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_DATE_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_DATE_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_DATE_FORMAT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_DATE_TIME_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_DATE_TIME_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_DATE_TIME_FORMAT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_HTTP_CLIENT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_HTTP_CLIENT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_HTTP_CLIENT_POLICY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_INSTANCE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_INSTANCE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_INSTANCE_NAME_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_MAPPER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_MAPPER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_MAPPER_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_AUTHORIZATION_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_AUTHORIZATION_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_AUTHORIZATION_POLICY_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_RETRIEVE_TARGET_RECORD_ON_IMPORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_RETRIEVE_TARGET_RECORD_ON_IMPORT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_TIME_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_TIME_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_TIME_FORMAT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_HOST_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PORT_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_API_URL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_API_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_API_URL_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_ID_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_ID_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_SECRET_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_CLIENT_SECRET_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_TOKEN_URL_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_TOKEN_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_OAUTH_TOKEN_URL_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SERVICENOW_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_PASSWORD_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_USER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_USER_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_PROXY_USER_NAME_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, CAMEL_SINK_SERVICENOW_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_SERVICENOW_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_SERVICENOW_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        conf.define(CAMEL_SINK_SERVICENOW_COMPONENT_USER_NAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SINK_SERVICENOW_COMPONENT_USER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_SERVICENOW_COMPONENT_USER_NAME_DOC);
        return conf;
    }
}