/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jackson.converter.JacksonTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

public final class JacksonTypeConvertersLoader
implements TypeConverterLoader {
    private volatile JacksonTypeConverters jacksonTypeConverters;

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        JacksonTypeConvertersLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getJacksonTypeConverters().convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }

    private JacksonTypeConverters getJacksonTypeConverters() {
        if (this.jacksonTypeConverters == null) {
            this.jacksonTypeConverters = new JacksonTypeConverters();
        }
        return this.jacksonTypeConverters;
    }
}

