/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde.strategy;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.rest.beans.ArtifactMetaData;
import io.apicurio.registry.rest.beans.IfExistsType;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.ConcurrentUtil;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class AbstractCrudIdStrategy<T>
implements GlobalIdStrategy<T> {
    protected <R> R unwrap(CompletionStage<R> cs) {
        return (R)ConcurrentUtil.result(cs);
    }

    protected boolean isNotFound(Response response) {
        return response.getStatus() == 404;
    }

    protected abstract long initialLookup(RegistryService var1, String var2, ArtifactType var3, T var4);

    protected void afterCreateArtifact(T schema, ArtifactMetaData amd) {
    }

    @Override
    public long findId(RegistryService service, String artifactId, ArtifactType artifactType, T schema) {
        try {
            return this.initialLookup(service, artifactId, artifactType, schema);
        }
        catch (WebApplicationException e) {
            if (this.isNotFound(e.getResponse())) {
                CompletionStage cs = service.createArtifact(artifactType, artifactId, IfExistsType.RETURN_OR_UPDATE, this.toStream(schema));
                ArtifactMetaData amd = (ArtifactMetaData)this.unwrap(cs);
                this.afterCreateArtifact(schema, amd);
                return amd.getGlobalId();
            }
            throw new IllegalStateException(String.format("Error [%s] retrieving schema: %s", e.getMessage(), artifactId));
        }
    }
}

