/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.serde.AbstractKafkaSerializer;
import io.apicurio.registry.utils.serde.AvroEncoding;
import io.apicurio.registry.utils.serde.avro.AvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.DefaultAvroDatumProvider;
import io.apicurio.registry.utils.serde.avro.NonRecordContainer;
import io.apicurio.registry.utils.serde.strategy.ArtifactIdStrategy;
import io.apicurio.registry.utils.serde.strategy.GlobalIdStrategy;
import io.apicurio.registry.utils.serde.util.HeaderUtils;
import io.apicurio.registry.utils.serde.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.kafka.common.header.Headers;

public class AvroKafkaSerializer<U>
extends AbstractKafkaSerializer<Schema, U, AvroKafkaSerializer<U>> {
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private AvroDatumProvider<U> avroDatumProvider = new DefaultAvroDatumProvider<U>();
    private AvroEncoding encoding;

    public AvroKafkaSerializer() {
    }

    public AvroKafkaSerializer(RegistryService client) {
        super(client);
    }

    public AvroKafkaSerializer(RegistryService client, ArtifactIdStrategy<Schema> artifactIdStrategy, GlobalIdStrategy<Schema> idStrategy) {
        super(client, artifactIdStrategy, idStrategy);
    }

    public AvroKafkaSerializer(RegistryService client, ArtifactIdStrategy<Schema> artifactIdStrategy, GlobalIdStrategy<Schema> globalIdStrategy, AvroDatumProvider<U> avroDatumProvider) {
        super(client, artifactIdStrategy, globalIdStrategy);
        this.setAvroDatumProvider(avroDatumProvider);
    }

    public AvroKafkaSerializer<U> setAvroDatumProvider(AvroDatumProvider<U> avroDatumProvider) {
        this.avroDatumProvider = Objects.requireNonNull(avroDatumProvider);
        return this;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        this.encoding = AvroEncoding.fromConfig(configs);
        if (Utils.isTrue(configs.get("apicurio.registry.use.headers"))) {
            this.headerUtils = new HeaderUtils(configs, isKey);
        }
        Object adp = configs.get("apicurio.registry.avro-datum-provider");
        Consumer<AvroDatumProvider> consumer = this::setAvroDatumProvider;
        this.instantiate(AvroDatumProvider.class, adp, consumer);
        this.avroDatumProvider.configure(configs);
    }

    @Override
    protected Schema toSchema(U data) {
        return this.avroDatumProvider.toSchema(data);
    }

    @Override
    protected ArtifactType artifactType() {
        return ArtifactType.AVRO;
    }

    @Override
    protected void serializeData(Schema schema, U data, OutputStream out) throws IOException {
        Encoder encoder = this.createEncoder(schema, out);
        if (data instanceof NonRecordContainer) {
            data = ((NonRecordContainer)NonRecordContainer.class.cast(data)).getValue();
        }
        DatumWriter<U> writer = this.avroDatumProvider.createDatumWriter(data, schema);
        writer.write(data, encoder);
        encoder.flush();
    }

    @Override
    protected void serializeData(Headers headers, Schema schema, U data, ByteArrayOutputStream out) throws IOException {
        if (this.headerUtils != null) {
            this.headerUtils.addEncodingHeader(headers, this.encoding);
        }
        this.serializeData(schema, data, (OutputStream)out);
    }

    private Encoder createEncoder(Schema schema, OutputStream os) throws IOException {
        if (this.encoding == AvroEncoding.JSON) {
            return this.encoderFactory.jsonEncoder(schema, os);
        }
        return this.encoderFactory.directBinaryEncoder(os, null);
    }
}

