/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.ReaderCache;
import org.apache.camel.util.IOHelper;

public final class StreamSourceCache
extends StreamSource
implements StreamCache {
    private final StreamCache streamCache;
    private final ReaderCache readCache;

    public StreamSourceCache(StreamSource source, Exchange exchange) throws IOException {
        if (source.getInputStream() != null) {
            CachedOutputStream cos = new CachedOutputStream(exchange);
            IOHelper.copyAndCloseInput((InputStream)source.getInputStream(), (OutputStream)cos);
            this.streamCache = cos.newStreamCache();
            this.readCache = null;
            this.setSystemId(source.getSystemId());
            this.setInputStream((InputStream)this.streamCache);
        } else if (source.getReader() != null) {
            String data = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)source.getReader());
            this.readCache = new ReaderCache(data);
            this.streamCache = null;
            this.setReader((Reader)this.readCache);
        } else {
            this.streamCache = null;
            this.readCache = null;
        }
    }

    public StreamSourceCache(StreamCache streamCache) {
        this.streamCache = streamCache;
        if (streamCache instanceof InputStream) {
            this.setInputStream((InputStream)streamCache);
            this.readCache = null;
        } else if (streamCache instanceof ReaderCache) {
            this.readCache = (ReaderCache)streamCache;
            this.setReader((Reader)streamCache);
        } else {
            this.readCache = null;
        }
    }

    public void reset() {
        if (this.streamCache != null) {
            this.streamCache.reset();
        }
        if (this.readCache != null) {
            this.readCache.reset();
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.streamCache != null) {
            this.streamCache.writeTo(os);
        } else if (this.readCache != null) {
            this.readCache.writeTo(os);
        }
    }

    public StreamCache copy(Exchange exchange) throws IOException {
        if (this.streamCache != null) {
            return new StreamSourceCache(this.streamCache.copy(exchange));
        }
        if (this.readCache != null) {
            return new StreamSourceCache(this.readCache.copy(exchange));
        }
        return null;
    }

    public boolean inMemory() {
        if (this.streamCache != null) {
            return this.streamCache.inMemory();
        }
        if (this.readCache != null) {
            return this.readCache.inMemory();
        }
        return true;
    }

    public long length() {
        if (this.streamCache != null) {
            return this.streamCache.length();
        }
        if (this.readCache != null) {
            return this.readCache.length();
        }
        return 0L;
    }
}

