/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ScpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/directoryName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "scp".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "directoryName", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(25);
        props.add("allowNullBody");
        props.add("chmod");
        props.add("ciphers");
        props.add("connectTimeout");
        props.add("directoryName");
        props.add("disconnect");
        props.add("disconnectOnBatchComplete");
        props.add("fileName");
        props.add("flatten");
        props.add("host");
        props.add("jailStartingDirectory");
        props.add("knownHostsFile");
        props.add("lazyStartProducer");
        props.add("moveExistingFileStrategy");
        props.add("password");
        props.add("port");
        props.add("preferredAuthentications");
        props.add("privateKeyBytes");
        props.add("privateKeyFile");
        props.add("privateKeyFilePassphrase");
        props.add("soTimeout");
        props.add("strictHostKeyChecking");
        props.add("timeout");
        props.add("useUserKnownHostsFile");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(7);
        secretProps.add("knownHostsFile");
        secretProps.add("password");
        secretProps.add("preferredAuthentications");
        secretProps.add("privateKeyBytes");
        secretProps.add("privateKeyFile");
        secretProps.add("privateKeyFilePassphrase");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

