/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dsl.support.RouteBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationMode;
import org.apache.camel.dsl.yaml.common.YamlDeserializerResolver;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.dsl.yaml.deserializers.CustomResolver;
import org.apache.camel.dsl.yaml.deserializers.ModelDeserializersResolver;
import org.apache.camel.spi.Resource;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.parser.Parser;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

public abstract class YamlRoutesBuilderLoaderSupport
extends RouteBuilderLoaderSupport {
    public static final String DESERIALIZATION_MODE = "CamelYamlDslDeserializationMode";

    public YamlRoutesBuilderLoaderSupport(String extension) {
        super(extension);
    }

    protected YamlDeserializationContext newYamlDeserializationContext(LoadSettings settings, Resource resource) {
        YamlDeserializationContext ctx = new YamlDeserializationContext(settings);
        YamlDeserializationMode deserializationMode = YamlDeserializationMode.FLOW;
        Map options = this.getCamelContext().getGlobalOptions();
        String mode = (String)options.get(DESERIALIZATION_MODE);
        if (mode != null) {
            deserializationMode = YamlDeserializationMode.valueOf((String)mode.toUpperCase(Locale.US));
        }
        ctx.setDeserializationMode(deserializationMode);
        ctx.setResource(resource);
        ctx.setCamelContext(this.getCamelContext());
        ctx.addResolvers(new YamlDeserializerResolver[]{new CustomResolver()});
        ctx.addResolvers(new YamlDeserializerResolver[]{new ModelDeserializersResolver()});
        return ctx;
    }

    public RouteBuilder doLoadRouteBuilder(Resource resource) throws Exception {
        if (!resource.exists()) {
            throw new FileNotFoundException("Resource not found: " + resource.getLocation());
        }
        try (InputStream is = this.resourceInputStream(resource);){
            LoadSettings local = LoadSettings.builder().setLabel(resource.getLocation()).build();
            YamlDeserializationContext ctx = this.newYamlDeserializationContext(local, resource);
            StreamReader reader = new StreamReader(local, (Reader)new YamlUnicodeReader(is));
            ParserImpl parser = new ParserImpl(local, reader);
            Composer composer = new Composer(local, (Parser)parser);
            RouteBuilder routeBuilder = composer.getSingleNode().map(node -> this.builder(ctx, (Node)node)).orElseThrow(() -> new YamlDeserializationException("Unable to parse resource: " + resource.getLocation()));
            return routeBuilder;
        }
    }

    protected abstract RouteBuilder builder(YamlDeserializationContext var1, Node var2);

    protected boolean anyTupleMatches(List<NodeTuple> list, String aKey, String aValue) {
        return this.anyTupleMatches(list, aKey, Predicate.isEqual(aValue));
    }

    protected boolean anyTupleMatches(List<NodeTuple> list, String aKey, Predicate<String> predicate) {
        for (NodeTuple tuple : list) {
            String value;
            String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            if (!Objects.equals(aKey, key) || !NodeType.SCALAR.equals((Object)val.getNodeType()) || !predicate.test(value = YamlDeserializerSupport.asText((Node)tuple.getValueNode()))) continue;
            return true;
        }
        return false;
    }

    protected String extractTupleValue(List<NodeTuple> list, String aKey) {
        for (NodeTuple tuple : list) {
            String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            if (!Objects.equals(aKey, key) || !NodeType.SCALAR.equals((Object)val.getNodeType())) continue;
            return YamlDeserializerSupport.asText((Node)tuple.getValueNode());
        }
        return null;
    }
}

