/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ScpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/directoryName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "scp".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "directoryName", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(26);
        props.add("useUserKnownHostsFile");
        props.add("disconnect");
        props.add("disconnectOnBatchComplete");
        props.add("moveExistingFileStrategy");
        props.add("fileName");
        props.add("strictHostKeyChecking");
        props.add("synchronous");
        props.add("timeout");
        props.add("flatten");
        props.add("password");
        props.add("jailStartingDirectory");
        props.add("privateKeyFile");
        props.add("host");
        props.add("connectTimeout");
        props.add("ciphers");
        props.add("chmod");
        props.add("privateKeyBytes");
        props.add("directoryName");
        props.add("allowNullBody");
        props.add("privateKeyFilePassphrase");
        props.add("soTimeout");
        props.add("lazyStartProducer");
        props.add("port");
        props.add("preferredAuthentications");
        props.add("knownHostsFile");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(7);
        secretProps.add("password");
        secretProps.add("privateKeyFile");
        secretProps.add("preferredAuthentications");
        secretProps.add("privateKeyFilePassphrase");
        secretProps.add("privateKeyBytes");
        secretProps.add("knownHostsFile");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

