/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.BeanScope;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanProcessorFactory;

public class BeanReifier
extends ProcessorReifier<BeanDefinition> {
    public BeanReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ProcessorDefinition)BeanDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Object bean = ((BeanDefinition)this.definition).getBean();
        String ref = this.parseString(((BeanDefinition)this.definition).getRef());
        String method = this.parseString(((BeanDefinition)this.definition).getMethod());
        String beanType = this.parseString(((BeanDefinition)this.definition).getBeanType());
        Class beanClass = ((BeanDefinition)this.definition).getBeanClass();
        BeanProcessorFactory fac = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanProcessorFactory();
        BeanScope scope = BeanScope.Singleton;
        if (((BeanDefinition)this.definition).getScope() != null) {
            scope = this.parse(BeanScope.class, ((BeanDefinition)this.definition).getScope());
        }
        Processor answer = fac.createBeanProcessor(this.camelContext, bean, beanType, beanClass, ref, method, scope);
        return answer;
    }
}

