/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FtpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FtpUtils.class);

    private FtpUtils() {
    }

    public static String extractDirNameFromAbsolutePath(String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return FileUtil.stripPath((String)path);
    }

    public static String compactPath(String path) {
        String[] parts;
        if (path == null) {
            return null;
        }
        if (path.indexOf(File.separator) == -1) {
            return path;
        }
        boolean endsWithSlash = path.endsWith("/") || path.endsWith("\\");
        boolean startsWithSlash = path.startsWith("/") || path.startsWith("\\");
        ArrayDeque<String> stack = new ArrayDeque<String>();
        String separatorRegex = File.separator;
        if (FileUtil.isWindows()) {
            separatorRegex = "\\\\";
        }
        for (String part : parts = path.split(separatorRegex)) {
            if (part.equals("..") && !stack.isEmpty() && !"..".equals(stack.peek())) {
                stack.pop();
                continue;
            }
            if (part.equals(".") || part.isEmpty()) continue;
            stack.push(part);
        }
        StringBuilder sb = new StringBuilder();
        if (startsWithSlash) {
            sb.append(File.separator);
        }
        Iterator it = stack.descendingIterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(File.separator);
        }
        if (endsWithSlash && !stack.isEmpty()) {
            sb.append(File.separator);
        }
        if (sb.length() >= 2) {
            boolean secondSlash;
            boolean firstSlash = sb.charAt(0) == '/' || sb.charAt(0) == '\\';
            boolean bl = secondSlash = sb.charAt(1) == '/' || sb.charAt(1) == '\\';
            if (firstSlash && secondSlash) {
                sb = sb.replace(1, 2, "");
            }
        }
        return sb.toString();
    }

    public static void ensureRelativeFtpDirectory(Component ftpComponent, RemoteFileConfiguration configuration) {
        if (FileUtil.hasLeadingSeparator((String)configuration.getDirectoryName())) {
            String relativePath = FileUtil.stripLeadingSeparator((String)configuration.getDirectoryName());
            LOG.warn(String.format("%s doesn't support absolute paths, \"%s\" will be converted to \"%s\". After Camel 2.16, absolute paths will be invalid.", ftpComponent.getClass().getSimpleName(), configuration.getDirectoryName(), relativePath));
            configuration.setDirectory(relativePath);
            configuration.setDirectoryName(relativePath);
        }
    }
}

