/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scp;

import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.scp.ScpComponent;
import org.apache.camel.component.scp.ScpConfiguration;
import org.apache.camel.component.scp.ScpFile;
import org.apache.camel.component.scp.ScpOperations;
import org.apache.camel.component.scp.ScpProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="2.10.0", scheme="scp", extendsScheme="ftp", title="SCP", syntax="scp:host:port/directoryName", producerOnly=true, label="file")
@Metadata(excludeProperties="appendChars,binary,charset,doneFileName,download,fastExistsCheck,fileExist,moveExisting,passiveMode,separator,tempFileName,tempPrefix,eagerDeleteTargetFile,keepLastModified,sendNoop,maximumReconnectAttempts,reconnectDelay,autoCreate,bufferSize,siteCommand,stepwise,throwExceptionOnConnectFailed,transferLoggingIntervalSeconds,transferLoggingLevel,transferLoggingVerbose,resumeDownload,handleDirectoryParserAbsoluteResult,activePortRange,ftpClient,ftpClientConfig,ftpClientConfigParameters,ftpClientParameters,account")
public class ScpEndpoint
extends RemoteFileEndpoint<ScpFile> {
    @UriParam
    private ScpConfiguration configuration;

    public ScpEndpoint() {
    }

    public ScpEndpoint(String uri, ScpComponent component, ScpConfiguration configuration) {
        super(uri, (RemoteFileComponent)component, (RemoteFileConfiguration)configuration);
        this.configuration = configuration;
    }

    public ScpConfiguration getConfiguration() {
        return this.configuration;
    }

    protected RemoteFileConsumer<ScpFile> buildConsumer(Processor processor) {
        throw new UnsupportedOperationException("This component does not support consuming from this endpoint");
    }

    protected GenericFileProducer<ScpFile> buildProducer() {
        return new ScpProducer(this, this.createRemoteFileOperations());
    }

    public RemoteFileOperations<ScpFile> createRemoteFileOperations() {
        ScpOperations operations = new ScpOperations();
        operations.setEndpoint((GenericFileEndpoint<ScpFile>)this);
        return operations;
    }

    public String getScheme() {
        return "scp";
    }

    public Expression getTempFileName() {
        return null;
    }
}

