/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncProcessorAwaitManager
extends ServiceSupport
implements AsyncProcessorAwaitManager,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAsyncProcessorAwaitManager.class);
    private final AsyncProcessorAwaitManager.Statistics statistics = new UtilizationStatistics();
    private final AtomicLong blockedCounter = new AtomicLong();
    private final AtomicLong interruptedCounter = new AtomicLong();
    private final AtomicLong totalDuration = new AtomicLong();
    private final AtomicLong minDuration = new AtomicLong();
    private final AtomicLong maxDuration = new AtomicLong();
    private final AtomicLong meanDuration = new AtomicLong();
    private final Map<Exchange, AsyncProcessorAwaitManager.AwaitThread> inflight = new ConcurrentHashMap<Exchange, AsyncProcessorAwaitManager.AwaitThread>();
    private final ExchangeFormatter exchangeFormatter;
    private boolean interruptThreadsWhileStopping = true;

    public DefaultAsyncProcessorAwaitManager() {
        DefaultExchangeFormatter formatter = new DefaultExchangeFormatter();
        formatter.setShowExchangeId(true);
        formatter.setMultiline(true);
        formatter.setShowHeaders(true);
        formatter.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
        this.exchangeFormatter = formatter;
    }

    public void process(AsyncProcessor processor, Exchange exchange) {
        CountDownLatch latch = new CountDownLatch(1);
        processor.process(exchange, doneSync -> this.countDown(exchange, latch));
        if (latch.getCount() > 0L) {
            this.await(exchange, latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(Exchange exchange, CountDownLatch latch) {
        AsyncProcessorAwaitManager.AwaitThread thread;
        ReactiveExecutor reactiveExecutor = ((ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class)).getReactiveExecutor();
        do {
            if (latch.getCount() > 0L) continue;
            return;
        } while (reactiveExecutor.executeFromQueue());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Waiting for asynchronous callback before continuing for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        try {
            if (this.statistics.isStatisticsEnabled()) {
                this.blockedCounter.incrementAndGet();
            }
            this.inflight.put(exchange, new AwaitThreadEntry(Thread.currentThread(), exchange, latch));
            latch.await();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Asynchronous callback received, will continue routing exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            }
            thread = this.inflight.remove(exchange);
        }
        catch (InterruptedException e) {
            AsyncProcessorAwaitManager.AwaitThread thread2;
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Interrupted while waiting for callback, will continue routing exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                }
                exchange.setException((Throwable)e);
                thread2 = this.inflight.remove(exchange);
            }
            catch (Throwable throwable) {
                AsyncProcessorAwaitManager.AwaitThread thread3 = this.inflight.remove(exchange);
                if (this.statistics.isStatisticsEnabled() && thread3 != null) {
                    long time = thread3.getWaitDuration();
                    long total = this.totalDuration.get() + time;
                    this.totalDuration.set(total);
                    if (time < this.minDuration.get()) {
                        this.minDuration.set(time);
                    } else if (time > this.maxDuration.get()) {
                        this.maxDuration.set(time);
                    }
                    long count = this.blockedCounter.get();
                    long mean = count > 0L ? total / count : 0L;
                    this.meanDuration.set(mean);
                }
                throw throwable;
            }
            if (this.statistics.isStatisticsEnabled() && thread2 != null) {
                long time = thread2.getWaitDuration();
                long total = this.totalDuration.get() + time;
                this.totalDuration.set(total);
                if (time < this.minDuration.get()) {
                    this.minDuration.set(time);
                } else if (time > this.maxDuration.get()) {
                    this.maxDuration.set(time);
                }
                long count = this.blockedCounter.get();
                long mean = count > 0L ? total / count : 0L;
                this.meanDuration.set(mean);
            }
        }
        if (this.statistics.isStatisticsEnabled() && thread != null) {
            long time = thread.getWaitDuration();
            long total = this.totalDuration.get() + time;
            this.totalDuration.set(total);
            if (time < this.minDuration.get()) {
                this.minDuration.set(time);
            } else if (time > this.maxDuration.get()) {
                this.maxDuration.set(time);
            }
            long count = this.blockedCounter.get();
            long mean = count > 0L ? total / count : 0L;
            this.meanDuration.set(mean);
        }
    }

    public void countDown(Exchange exchange, CountDownLatch latch) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Asynchronous callback received for exchangeId: {}", (Object)exchange.getExchangeId());
        }
        latch.countDown();
    }

    public int size() {
        return this.inflight.size();
    }

    public Collection<AsyncProcessorAwaitManager.AwaitThread> browse() {
        return Collections.unmodifiableCollection(this.inflight.values());
    }

    public void interrupt(String exchangeId) {
        Exchange found = null;
        for (AsyncProcessorAwaitManager.AwaitThread entry : this.browse()) {
            Exchange exchange = entry.getExchange();
            if (!exchangeId.equals(exchange.getExchangeId())) continue;
            found = exchange;
            break;
        }
        if (found != null) {
            this.interrupt(found);
        }
    }

    public void interrupt(Exchange exchange) {
        AwaitThreadEntry entry = (AwaitThreadEntry)this.inflight.get(exchange);
        if (entry != null) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("Interrupted while waiting for asynchronous callback, will release the following blocked thread which was waiting for exchange to finish processing with exchangeId: ");
                sb.append(exchange.getExchangeId());
                sb.append("\n");
                sb.append(DefaultAsyncProcessorAwaitManager.dumpBlockedThread(entry));
                String routeStackTrace = MessageHelper.dumpMessageHistoryStacktrace((Exchange)exchange, (ExchangeFormatter)this.exchangeFormatter, (boolean)false);
                if (routeStackTrace != null) {
                    sb.append(routeStackTrace);
                }
                LOG.warn(sb.toString());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            finally {
                if (this.statistics.isStatisticsEnabled()) {
                    this.interruptedCounter.incrementAndGet();
                }
                exchange.setException((Throwable)new RejectedExecutionException("Interrupted while waiting for asynchronous callback for exchangeId: " + exchange.getExchangeId()));
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).setInterrupted(true);
                entry.getLatch().countDown();
            }
        }
    }

    public boolean isInterruptThreadsWhileStopping() {
        return this.interruptThreadsWhileStopping;
    }

    public void setInterruptThreadsWhileStopping(boolean interruptThreadsWhileStopping) {
        this.interruptThreadsWhileStopping = interruptThreadsWhileStopping;
    }

    public AsyncProcessorAwaitManager.Statistics getStatistics() {
        return this.statistics;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        Collection<AsyncProcessorAwaitManager.AwaitThread> threads = this.browse();
        int count = threads.size();
        if (count > 0) {
            LOG.warn("Shutting down while there are still {} inflight threads currently blocked.", (Object)count);
            StringBuilder sb = new StringBuilder();
            for (AsyncProcessorAwaitManager.AwaitThread entry : threads) {
                sb.append(DefaultAsyncProcessorAwaitManager.dumpBlockedThread(entry));
            }
            if (this.isInterruptThreadsWhileStopping()) {
                LOG.warn("The following threads are blocked and will be interrupted so the threads are released:\n{}", (Object)sb);
                for (AsyncProcessorAwaitManager.AwaitThread entry : threads) {
                    try {
                        this.interrupt(entry.getExchange());
                    }
                    catch (Throwable e) {
                        LOG.warn("Error while interrupting thread: " + entry.getBlockedThread().getName() + ". This exception is ignored.", e);
                    }
                }
            } else {
                LOG.warn("The following threads are blocked, and may reside in the JVM:\n{}", (Object)sb);
            }
        } else {
            LOG.debug("Shutting down with no inflight threads.");
        }
        this.inflight.clear();
    }

    private static String dumpBlockedThread(AsyncProcessorAwaitManager.AwaitThread entry) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Blocked Thread\n");
        sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
        sb.append(DefaultAsyncProcessorAwaitManager.style("Id:")).append(entry.getBlockedThread().getId()).append("\n");
        sb.append(DefaultAsyncProcessorAwaitManager.style("Name:")).append(entry.getBlockedThread().getName()).append("\n");
        sb.append(DefaultAsyncProcessorAwaitManager.style("RouteId:")).append(DefaultAsyncProcessorAwaitManager.safeNull(entry.getRouteId())).append("\n");
        sb.append(DefaultAsyncProcessorAwaitManager.style("NodeId:")).append(DefaultAsyncProcessorAwaitManager.safeNull(entry.getNodeId())).append("\n");
        sb.append(DefaultAsyncProcessorAwaitManager.style("Duration:")).append(entry.getWaitDuration()).append(" msec.\n");
        return sb.toString();
    }

    private static String style(String label) {
        return String.format("\t%-20s", label);
    }

    private static String safeNull(Object value) {
        return value != null ? value.toString() : "";
    }

    private final class UtilizationStatistics
    implements AsyncProcessorAwaitManager.Statistics {
        private boolean statisticsEnabled;

        private UtilizationStatistics() {
        }

        public long getThreadsBlocked() {
            return DefaultAsyncProcessorAwaitManager.this.blockedCounter.get();
        }

        public long getThreadsInterrupted() {
            return DefaultAsyncProcessorAwaitManager.this.interruptedCounter.get();
        }

        public long getTotalDuration() {
            return DefaultAsyncProcessorAwaitManager.this.totalDuration.get();
        }

        public long getMinDuration() {
            return DefaultAsyncProcessorAwaitManager.this.minDuration.get();
        }

        public long getMaxDuration() {
            return DefaultAsyncProcessorAwaitManager.this.maxDuration.get();
        }

        public long getMeanDuration() {
            return DefaultAsyncProcessorAwaitManager.this.meanDuration.get();
        }

        public void reset() {
            DefaultAsyncProcessorAwaitManager.this.blockedCounter.set(0L);
            DefaultAsyncProcessorAwaitManager.this.interruptedCounter.set(0L);
            DefaultAsyncProcessorAwaitManager.this.totalDuration.set(0L);
            DefaultAsyncProcessorAwaitManager.this.minDuration.set(0L);
            DefaultAsyncProcessorAwaitManager.this.maxDuration.set(0L);
            DefaultAsyncProcessorAwaitManager.this.meanDuration.set(0L);
        }

        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }

        public String toString() {
            return String.format("AsyncProcessAwaitManager utilization[blocked=%s, interrupted=%s, total=%s min=%s, max=%s, mean=%s]", this.getThreadsBlocked(), this.getThreadsInterrupted(), this.getTotalDuration(), this.getMinDuration(), this.getMaxDuration(), this.getMeanDuration());
        }
    }

    private static final class AwaitThreadEntry
    implements AsyncProcessorAwaitManager.AwaitThread {
        private final Thread thread;
        private final Exchange exchange;
        private final CountDownLatch latch;
        private final long start;

        private AwaitThreadEntry(Thread thread, Exchange exchange, CountDownLatch latch) {
            this.thread = thread;
            this.exchange = exchange;
            this.latch = latch;
            this.start = System.currentTimeMillis();
        }

        public Thread getBlockedThread() {
            return this.thread;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public long getWaitDuration() {
            return System.currentTimeMillis() - this.start;
        }

        public String getRouteId() {
            RouteContext rc;
            UnitOfWork uow = this.exchange.getUnitOfWork();
            RouteContext routeContext = rc = uow != null ? uow.getRouteContext() : null;
            if (rc != null) {
                return rc.getRouteId();
            }
            return null;
        }

        public String getNodeId() {
            return ((ExtendedExchange)this.exchange.adapt(ExtendedExchange.class)).getHistoryNodeId();
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public String toString() {
            return "AwaitThreadEntry[name=" + this.thread.getName() + ", exchangeId=" + this.exchange.getExchangeId() + "]";
        }
    }
}

