/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;

@Provider
@Produces(value={"application/x-java-serialized-object"})
@Consumes(value={"application/x-java-serialized-object"})
@Deprecated
public class SerializableProvider
implements MessageBodyReader<Serializable>,
AsyncMessageBodyWriter<Serializable> {
    public static final MediaType APPLICATION_SERIALIZABLE_TYPE = new MediaType("application", "x-java-serialized-object");
    public static final String APPLICATION_SERIALIZABLE = APPLICATION_SERIALIZABLE_TYPE.toString();

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Serializable.class.isAssignableFrom(type) && APPLICATION_SERIALIZABLE_TYPE.getType().equals(mediaType.getType()) && APPLICATION_SERIALIZABLE_TYPE.getSubtype().equals(mediaType.getSubtype());
    }

    public long getSize(Serializable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Serializable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        BufferedOutputStream bos = new BufferedOutputStream(entityStream);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(t);
        oos.close();
    }

    public CompletionStage<Void> asyncWriteTo(Serializable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(t);
            oos.close();
        }
        catch (IOException e) {
            return ProviderHelper.completedException(e);
        }
        return entityStream.asyncWrite(bos.toByteArray());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Serializable.class.isAssignableFrom(type) && APPLICATION_SERIALIZABLE_TYPE.getType().equals(mediaType.getType()) && APPLICATION_SERIALIZABLE_TYPE.getSubtype().equals(mediaType.getSubtype());
    }

    public Serializable readFrom(Class<Serializable> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        BufferedInputStream bis = new BufferedInputStream(entityStream);
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            return (Serializable)Serializable.class.cast(ois.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

