/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resteasy;

import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.resteasy.ResteasyConsumer;
import org.apache.camel.component.resteasy.ResteasyEndpoint;
import org.apache.camel.http.common.DefaultHttpRegistry;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRegistry;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

@Component(value="resteasy")
@Metadata(excludeProperties="clientConnectionManager,connectionsPerRoute,connectionTimeToLive,httpBinding,httpClientConfigurer,httpConfiguration,httpContext,httpRegistry,maxTotalConnections,connectionRequestTimeout,connectTimeout,socketTimeout,cookieStore,x509HostnameVerifier,sslContextParameters,useGlobalSslContextParameters,proxyMethod,proxyHost,proxyPort,proxyAuthScheme,proxyAuthMethod,proxyAuthUsername,proxyAuthPassword,proxyAuthHost,proxyAuthPort,proxyAuthDomain,proxyAuthNtHost")
public class ResteasyComponent
extends HttpComponent
implements RestConsumerFactory {
    @Metadata(label="advanced")
    private HttpRegistry httpRegistry;
    @Metadata(label="consumer")
    private String proxyConsumersClasses;

    public ResteasyComponent() {
        super(ResteasyEndpoint.class);
    }

    public ResteasyComponent(HttpServletDispatcher dispatcher) {
        super(ResteasyEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = (Boolean)this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        Boolean matchOnUriPrefix = (Boolean)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)uri)), parameters);
        ResteasyEndpoint endpoint = new ResteasyEndpoint(uri, this, httpUri);
        this.setProperties((Endpoint)endpoint, parameters);
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        URI u = new URI(remaining);
        String protocol = u.getScheme();
        String uriPattern = u.getPath();
        if (parameters.size() > 0) {
            uriPattern = uriPattern + "?" + URISupport.createQueryString(parameters);
        }
        int port = 0;
        String host = u.getHost();
        if (u.getPort() > 0) {
            port = u.getPort();
        }
        endpoint.setProtocol(protocol);
        endpoint.setUriPattern(uriPattern);
        endpoint.setHost(host);
        if (port > 0) {
            endpoint.setPort(port);
        }
        return endpoint;
    }

    public void connect(HttpConsumer consumer) throws Exception {
        ResteasyConsumer sc = (ResteasyConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry((String)name);
        }
        registry.register(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        ResteasyConsumer sc = (ResteasyConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry((String)name);
        }
        registry.unregister(consumer);
    }

    public String getProxyConsumersClasses() {
        return this.proxyConsumersClasses;
    }

    public void setProxyConsumersClasses(String proxyConsumersClasses) {
        this.proxyConsumersClasses = proxyConsumersClasses;
    }

    public HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    public void setHttpRegistry(HttpRegistry httpRegistry) {
        this.httpRegistry = httpRegistry;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = this.getCamelContext().getRestConfiguration();
        HashMap map = new HashMap();
        if ((config.getComponent() == null || config.getComponent().equals("resteasy")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        String query = URISupport.createQueryString(map);
        String url = "resteasy:/%s";
        if (!query.isEmpty()) {
            url = url + "?" + query;
        }
        String restrict = verb.toUpperCase(Locale.US);
        url = String.format(url, path, restrict);
        ResteasyEndpoint endpoint = (ResteasyEndpoint)camelContext.getEndpoint(url, ResteasyEndpoint.class);
        this.setProperties((Endpoint)endpoint, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }
}

