/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.core.validation.rules.invalid.format;

import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.validation.ValidationRule;
import io.apicurio.datamodels.core.validation.ValidationRuleMetaData;
import io.apicurio.datamodels.openapi.v2.models.Oas20Document;

public class OasInvalidApiHostRule
extends ValidationRule {
    public OasInvalidApiHostRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    public static boolean isValidHost(String propertyValue) {
        return propertyValue.indexOf("http:") != 0 && propertyValue.indexOf("https:") != 0;
    }

    @Override
    public void visitDocument(Document node) {
        Oas20Document doc = (Oas20Document)node;
        if (this.hasValue(doc.host)) {
            this.reportIfInvalid(OasInvalidApiHostRule.isValidHost(doc.host), doc, "host", this.map(new String[0]));
        }
    }
}

