/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.JsonCompat;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllOperationsCommand
extends AbstractCommand {
    private static final String[] ALL_METHODS = new String[]{"get", "put", "post", "delete", "head", "patch", "options", "trace"};
    public NodePath _parentPath;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldOperations;

    DeleteAllOperationsCommand() {
    }

    DeleteAllOperationsCommand(OasPathItem parent) {
        this._parentPath = Library.createNodePath(parent);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllOperationsCommand] Executing.", new Object[0]);
        this._oldOperations = new ArrayList<Object>();
        OasPathItem parent = (OasPathItem)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        for (String method : ALL_METHODS) {
            OasOperation oldOp = (OasOperation)NodeCompat.getProperty(parent, method);
            if (this.isNullOrUndefined(oldOp)) continue;
            ObjectNode oldOpData = JsonCompat.objectNode();
            JsonCompat.setPropertyString(oldOpData, "_method", method);
            JsonCompat.setProperty(oldOpData, "_operation", Library.writeNode(oldOp));
            this._oldOperations.add(oldOpData);
            NodeCompat.setProperty(parent, method, null);
        }
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllOperationsCommand] Reverting.", new Object[0]);
        if (this._oldOperations == null || this._oldOperations.size() == 0) {
            return;
        }
        OasPathItem parent = (OasPathItem)this._parentPath.resolve(document);
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        for (Object oldOperationData : this._oldOperations) {
            String method = JsonCompat.getPropertyString(oldOperationData, "_method");
            OasOperation operation = parent.createOperation(method);
            Library.readNode(JsonCompat.getProperty(oldOperationData, "_operation"), operation);
            NodeCompat.setProperty(parent, method, operation);
        }
    }
}

