/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.openapi.v3.models;

import io.apicurio.datamodels.core.models.ExtensibleNode;
import io.apicurio.datamodels.core.models.common.INamed;
import io.apicurio.datamodels.core.visitors.IVisitor;
import io.apicurio.datamodels.openapi.v3.models.Oas30Header;
import io.apicurio.datamodels.openapi.v3.visitors.IOas30Visitor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Oas30Encoding
extends ExtensibleNode
implements INamed {
    private String _name;
    public String contentType;
    public Map<String, Oas30Header> headers = new LinkedHashMap<String, Oas30Header>();
    public String style;
    public Boolean explode;
    public Boolean allowReserved;

    public Oas30Encoding(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void rename(String newName) {
        this._name = newName;
    }

    @Override
    public void accept(IVisitor visitor) {
        IOas30Visitor viz = (IOas30Visitor)visitor;
        viz.visitEncoding(this);
    }

    public Oas30Header createHeader(String name) {
        Oas30Header rval = new Oas30Header(name);
        rval._ownerDocument = this.ownerDocument();
        rval._parent = this;
        return rval;
    }

    public void addHeader(String name, Oas30Header header) {
        this.headers.put(name, header);
    }

    public Oas30Header getHeader(String name) {
        return this.headers.get(name);
    }

    public List<String> getHeaderNames() {
        ArrayList<String> rval = new ArrayList<String>();
        rval.addAll(this.headers.keySet());
        return rval;
    }

    public Oas30Header removeHeader(String name) {
        return this.headers.remove(name);
    }

    public List<Oas30Header> getHeaders() {
        ArrayList<Oas30Header> rval = new ArrayList<Oas30Header>();
        rval.addAll(this.headers.values());
        return rval;
    }
}

