/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.cmd.util.ModelUtils;
import io.apicurio.datamodels.combined.visitors.CombinedVisitorAdapter;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.core.models.common.Operation;
import io.apicurio.datamodels.core.util.VisitorUtil;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(value={"isPathItem", "isOperation"})
public class RenameParameterCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _oldParamName;
    public String _newParamName;
    public String _paramIn;
    private transient boolean isPathItem;
    private transient boolean isOperation;

    RenameParameterCommand() {
    }

    RenameParameterCommand(IOasParameterParent parent, String oldParamName, String newParamName, String paramIn) {
        this._oldParamName = oldParamName;
        this._newParamName = newParamName;
        this._paramIn = paramIn;
        this._parentPath = Library.createNodePath((Node)((Object)parent));
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[RenameParameterCommand] Executing.", new Object[0]);
        this._doParameterRename(document, this._oldParamName, this._newParamName);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[RenameParameterCommand] Reverting.", new Object[0]);
        this._doParameterRename(document, this._newParamName, this._oldParamName);
    }

    private void _doParameterRename(Document document, String from, String to) {
        OasOperation operation;
        OasPathItem pathItem;
        OasParameter pparam;
        IOasParameterParent parent = (IOasParameterParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        OasParameter param = parent.getParameter(this._paramIn, from);
        if (this.isNullOrUndefined(param)) {
            return;
        }
        ArrayList<OasParameter> allParams = new ArrayList<OasParameter>();
        allParams.add(param);
        this.isPathItem = false;
        this.isOperation = false;
        VisitorUtil.visitNode((Node)((Object)parent), new CombinedVisitorAdapter(){

            @Override
            public void visitPathItem(OasPathItem node) {
                RenameParameterCommand.this.isPathItem = true;
            }

            @Override
            public void visitOperation(Operation node) {
                RenameParameterCommand.this.isOperation = true;
            }
        });
        List<String> methods = NodeCompat.asList("get", "put", "post", "delete", "options", "head", "patch", "trace");
        if (this.isPathItem) {
            OasPathItem pathItem2 = (OasPathItem)parent;
            for (String method : methods) {
                OasParameter opParam;
                OasOperation op = (OasOperation)NodeCompat.getProperty(pathItem2, method);
                if (this.isNullOrUndefined(op) || this.isNullOrUndefined(opParam = op.getParameter(this._paramIn, from))) continue;
                allParams.add(opParam);
            }
        }
        if (this.isOperation && !this.isNullOrUndefined(pparam = (pathItem = (OasPathItem)(operation = (OasOperation)parent).parent()).getParameter(this._paramIn, from))) {
            allParams.add(pparam);
            for (String method : methods) {
                OasParameter opParam;
                OasOperation peerOperation = (OasOperation)NodeCompat.getProperty(pathItem, method);
                if (!ModelUtils.isDefined(peerOperation) || peerOperation == operation || this.isNullOrUndefined(opParam = peerOperation.getParameter(this._paramIn, from))) continue;
                allParams.add(opParam);
            }
        }
        allParams.forEach(p -> {
            p.name = to;
        });
    }
}

