/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.compat.NodeCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.Node;
import io.apicurio.datamodels.core.models.NodePath;
import io.apicurio.datamodels.openapi.models.IOasParameterParent;
import io.apicurio.datamodels.openapi.models.OasParameter;
import java.util.ArrayList;
import java.util.List;

public class DeleteAllParametersCommand
extends AbstractCommand {
    public NodePath _parentPath;
    public String _paramType;
    @JsonDeserialize(contentUsing=MarshallCompat.NullableJsonNodeDeserializer.class)
    public List<Object> _oldParams;

    DeleteAllParametersCommand() {
    }

    DeleteAllParametersCommand(IOasParameterParent parent, String type) {
        this._parentPath = Library.createNodePath((Node)((Object)parent));
        this._paramType = type;
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[DeleteAllParameters] Executing.", new Object[0]);
        this._oldParams = new ArrayList<Object>();
        IOasParameterParent parent = (IOasParameterParent)((Object)this._parentPath.resolve(document));
        List<OasParameter> parameters = parent.getParameters();
        if (this.isNullOrUndefined(parent) || this.isNullOrUndefined(parameters) || parameters.size() == 0) {
            return;
        }
        ArrayList<OasParameter> paramsToRemove = new ArrayList<OasParameter>();
        for (OasParameter param : parameters) {
            if (!NodeCompat.equals(param.in, this._paramType)) continue;
            this._oldParams.add(Library.writeNode(param));
            paramsToRemove.add(param);
        }
        if (this._oldParams.size() == 0) {
            return;
        }
        paramsToRemove.forEach(paramToRemove -> parameters.remove(paramToRemove));
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[DeleteAllParameters] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldParams) || this._oldParams.size() == 0) {
            return;
        }
        IOasParameterParent parent = (IOasParameterParent)((Object)this._parentPath.resolve(document));
        if (this.isNullOrUndefined(parent)) {
            return;
        }
        this._oldParams.forEach(param -> {
            OasParameter p = parent.createParameter();
            Library.readNode(param, p);
            parent.addParameter(p);
        });
    }
}

