/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.cmd.commands;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.cmd.AbstractCommand;
import io.apicurio.datamodels.compat.LoggerCompat;
import io.apicurio.datamodels.compat.MarshallCompat;
import io.apicurio.datamodels.core.models.Document;
import io.apicurio.datamodels.core.models.common.SecurityScheme;

public abstract class ChangeSecuritySchemeCommand
extends AbstractCommand {
    public String _schemeName;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _schemeObj;
    @JsonDeserialize(using=MarshallCompat.NullableJsonNodeDeserializer.class)
    public Object _oldScheme;

    ChangeSecuritySchemeCommand() {
    }

    ChangeSecuritySchemeCommand(SecurityScheme scheme) {
        this._schemeName = scheme.getName();
        this._schemeObj = Library.writeNode(scheme);
    }

    @Override
    public void execute(Document document) {
        LoggerCompat.info("[ChangeSecuritySchemeCommand] Executing.", new Object[0]);
        this._oldScheme = null;
        SecurityScheme scheme = this.getSchemeFromDocument(document);
        if (this.isNullOrUndefined(scheme)) {
            return;
        }
        this._oldScheme = Library.writeNode(scheme);
        this.replaceSchemeWith(scheme, this._schemeObj);
    }

    @Override
    public void undo(Document document) {
        LoggerCompat.info("[ChangeSecuritySchemeCommand] Reverting.", new Object[0]);
        if (this.isNullOrUndefined(this._oldScheme)) {
            return;
        }
        SecurityScheme scheme = this.getSchemeFromDocument(document);
        if (this.isNullOrUndefined(scheme)) {
            return;
        }
        this.nullScheme(scheme);
        Library.readNode(this._oldScheme, scheme);
    }

    protected abstract SecurityScheme getSchemeFromDocument(Document var1);

    protected void replaceSchemeWith(SecurityScheme toScheme, Object fromScheme) {
        this.nullScheme(toScheme);
        Library.readNode(fromScheme, toScheme);
    }

    protected void nullScheme(SecurityScheme scheme) {
        scheme.description = null;
        scheme.type = null;
        scheme.name = null;
        scheme.in = null;
    }
}

